/*
 * Decompiled with CFR 0.152.
 */
package com.uber.tchannel.messages;

import com.uber.tchannel.api.ResponseCode;
import com.uber.tchannel.messages.ErrorResponse;
import com.uber.tchannel.messages.RawMessage;
import com.uber.tchannel.messages.Request;
import com.uber.tchannel.messages.Response;
import com.uber.tchannel.utils.TChannelUtilities;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.util.CharsetUtil;
import java.util.Map;

public class RawResponse
extends Response
implements RawMessage {
    private String header = null;
    private String body = null;

    private RawResponse(Builder builder) {
        super(builder);
    }

    protected RawResponse(long id, ResponseCode responseCode, Map<String, String> transportHeaders, ByteBuf arg2, ByteBuf arg3) {
        super(id, responseCode, transportHeaders, arg2, arg3);
    }

    protected RawResponse(ErrorResponse error) {
        super(error);
    }

    public String getHeader() {
        if (this.header == null) {
            this.header = this.arg2 == null ? "" : this.arg2.toString(CharsetUtil.UTF_8);
        }
        return this.header;
    }

    public String getBody() {
        if (this.body == null) {
            this.body = this.arg3 == null ? "" : this.arg3.toString(CharsetUtil.UTF_8);
        }
        return this.body;
    }

    @Override
    public String toString() {
        if (this.isError()) {
            return this.getError().toString();
        }
        return String.format("<%s responseCode=%s transportHeaders=%s header=%s body=%s>", new Object[]{this.getClass().getSimpleName(), this.responseCode, this.transportHeaders, this.getHeader(), this.getBody()});
    }

    public static class Builder
    extends Response.Builder {
        protected String header = null;
        protected String body = null;

        public Builder(Request req) {
            super(req);
        }

        @Override
        public Builder setResponseCode(ResponseCode responseCode) {
            this.responseCode = responseCode;
            return this;
        }

        @Override
        public Builder setArg2(ByteBuf arg2) {
            super.setArg2(arg2);
            this.header = null;
            return this;
        }

        @Override
        public Builder setArg3(ByteBuf arg3) {
            super.setArg3(arg3);
            this.body = null;
            return this;
        }

        @Override
        public Builder setTransportHeader(String key, String value) {
            super.setTransportHeader(key, value);
            return this;
        }

        @Override
        public Builder setTransportHeaders(Map<String, String> transportHeaders) {
            super.setTransportHeaders(transportHeaders);
            return this;
        }

        public final Builder setHeader(String header) {
            this.setArg2(Unpooled.wrappedBuffer(header.getBytes()));
            this.header = header;
            return this;
        }

        public final Builder setBody(String body) {
            this.setArg3(Unpooled.wrappedBuffer(body.getBytes()));
            this.body = body;
            return this;
        }

        @Override
        public Builder validate() {
            super.validate();
            if (this.arg2 == null) {
                this.arg2 = TChannelUtilities.emptyByteBuf;
            }
            if (this.arg3 == null) {
                this.arg3 = TChannelUtilities.emptyByteBuf;
            }
            return this;
        }

        public RawResponse build() {
            return new RawResponse(this.validate());
        }
    }
}

