/*
 * Decompiled with CFR 0.152.
 */
package com.uber.tchannel.messages;

import com.uber.tchannel.frames.FrameType;
import com.uber.tchannel.headers.ArgScheme;
import com.uber.tchannel.headers.RetryFlag;
import com.uber.tchannel.messages.JsonRequest;
import com.uber.tchannel.messages.RawMessage;
import com.uber.tchannel.messages.RawRequest;
import com.uber.tchannel.messages.ThriftRequest;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.util.CharsetUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;

public abstract class Request
implements RawMessage {
    protected final FrameType type = FrameType.CallRequest;
    protected long id = -1L;
    protected String service = null;
    protected ByteBuf arg1 = null;
    protected ByteBuf arg2 = null;
    protected ByteBuf arg3 = null;
    protected String endpoint = null;
    protected long ttl = 100L;
    protected Map<String, String> transportHeaders = new HashMap<String, String>();
    protected final int retryLimit;

    protected Request(Builder builder) {
        this.service = builder.service;
        this.arg1 = builder.arg1;
        this.arg2 = builder.arg2;
        this.arg3 = builder.arg3;
        this.ttl = builder.ttl;
        this.transportHeaders = builder.transportHeaders;
        this.endpoint = builder.endpoint;
        this.retryLimit = builder.retryLimit;
    }

    protected Request(long id, long ttl, String service, Map<String, String> transportHeaders, ByteBuf arg1, ByteBuf arg2, ByteBuf arg3) {
        this.id = id;
        this.ttl = ttl;
        this.service = service;
        this.arg1 = arg1;
        this.arg2 = arg2;
        this.arg3 = arg3;
        this.transportHeaders = transportHeaders;
        this.retryLimit = 0;
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public FrameType getType() {
        return this.type;
    }

    @Override
    public ByteBuf getArg1() {
        return this.arg1;
    }

    @Override
    public ByteBuf getArg2() {
        return this.arg2;
    }

    @Override
    public ByteBuf getArg3() {
        return this.arg3;
    }

    @Override
    public Map<String, String> getTransportHeaders() {
        return this.transportHeaders;
    }

    public String toString() {
        return String.format("<%s id=%d service=%s transportHeaders=%s arg1=%s arg2=%s arg3=%s>", this.getClass().getSimpleName(), this.id, this.service, this.transportHeaders, this.arg1.toString(CharsetUtil.UTF_8), this.arg2.toString(CharsetUtil.UTF_8), this.arg3.toString(CharsetUtil.UTF_8));
    }

    @Override
    public final void release() {
        if (this.arg1 != null) {
            this.arg1.release();
            this.arg1 = null;
        }
        if (this.arg2 != null) {
            this.arg2.release();
            this.arg2 = null;
        }
        if (this.arg3 != null) {
            this.arg3.release();
            this.arg3 = null;
        }
    }

    @Override
    public void close() {
        this.release();
    }

    public final int argSize() {
        int size = 0;
        if (this.arg1 != null) {
            size += this.arg1.readableBytes();
        }
        if (this.arg2 != null) {
            size += this.arg2.readableBytes();
        }
        if (this.arg3 != null) {
            size += this.arg3.readableBytes();
        }
        return size;
    }

    public final void setId(int id) {
        this.id = id;
    }

    public final long getTTL() {
        return this.ttl;
    }

    public final String getService() {
        return this.service;
    }

    public final void setTransportHeader(String key, String value) {
        this.transportHeaders.put(key, value);
    }

    public final long getTimeout() {
        return this.ttl;
    }

    public final int getRetryLimit() {
        return this.retryLimit;
    }

    public final void reset() {
        this.arg1.resetReaderIndex();
        this.arg2.resetReaderIndex();
        this.arg3.resetReaderIndex();
    }

    public final String getEndpoint() {
        if (this.endpoint == null) {
            this.endpoint = this.arg1.toString(CharsetUtil.UTF_8);
        }
        return this.endpoint;
    }

    public final ArgScheme getArgScheme() {
        return ArgScheme.toScheme(this.transportHeaders.get("as"));
    }

    public final void setArgScheme(ArgScheme argScheme) {
        this.setTransportHeader("as", argScheme.getScheme());
    }

    public final String getRetryFlags() {
        return this.transportHeaders.get("re");
    }

    public final void setRetryFlags(Set<RetryFlag> flags) {
        this.setRetryFlags(RetryFlag.flagsToString(flags));
    }

    public final void setRetryFlags(String flags) {
        if (!RetryFlag.validFlags(flags)) {
            throw new UnsupportedOperationException("Invalid retry flag: " + flags);
        }
        this.setTransportHeader("re", flags);
    }

    public static Request build(long id, long ttl, String service, Map<String, String> transportHeaders, ByteBuf arg1, ByteBuf arg2, ByteBuf arg3) {
        ArgScheme argScheme = ArgScheme.toScheme(transportHeaders.get("as"));
        if (argScheme == null) {
            return null;
        }
        return Request.build(argScheme, id, ttl, service, transportHeaders, arg1, arg2, arg3);
    }

    public static Request build(ArgScheme argScheme, long id, long ttl, String service, Map<String, String> transportHeaders, ByteBuf arg1, ByteBuf arg2, ByteBuf arg3) {
        Request req;
        switch (argScheme) {
            case RAW: {
                req = new RawRequest(id, ttl, service, transportHeaders, arg1, arg2, arg3);
                break;
            }
            case JSON: {
                req = new JsonRequest(id, ttl, service, transportHeaders, arg1, arg2, arg3);
                break;
            }
            case THRIFT: {
                req = new ThriftRequest(id, ttl, service, transportHeaders, arg1, arg2, arg3);
                break;
            }
            default: {
                req = null;
            }
        }
        return req;
    }

    public static class Builder {
        protected Map<String, String> transportHeaders = new HashMap<String, String>();
        protected ByteBuf arg2 = null;
        protected ByteBuf arg3 = null;
        private long id = -1L;
        private String endpoint = null;
        private ByteBuf arg1 = null;
        private final String service;
        private long ttl = 100L;
        protected int retryLimit = 4;

        public Builder(String service, String endpoint) {
            this.service = service;
            this.setEndpoint(endpoint);
        }

        public Builder(String service, ByteBuf arg1) {
            this.service = service;
            this.arg1 = arg1;
        }

        private Builder setEndpoint(String endpoint) {
            this.setArg1(Unpooled.wrappedBuffer(endpoint.getBytes()));
            this.endpoint = endpoint;
            return this;
        }

        private Builder setArg1(ByteBuf arg1) {
            if (this.arg1 != null) {
                this.arg1.release();
            }
            this.arg1 = arg1;
            this.endpoint = null;
            return this;
        }

        public Builder setArg2(ByteBuf arg2) {
            if (this.arg2 != null) {
                this.arg2.release();
            }
            this.arg2 = arg2;
            return this;
        }

        public Builder setArg3(ByteBuf arg3) {
            if (this.arg3 != null) {
                this.arg3.release();
            }
            this.arg3 = arg3;
            return this;
        }

        public Builder setTransportHeader(String key, String value) {
            this.transportHeaders.put(key, value);
            return this;
        }

        public Builder setTransportHeaders(Map<String, String> transportHeaders) {
            this.transportHeaders = transportHeaders;
            return this;
        }

        public Builder setId(long id) {
            this.id = id;
            return this;
        }

        public Builder setRetryLimit(int retryLimit) {
            this.retryLimit = retryLimit;
            return this;
        }

        public Builder setTimeout(long timeout) {
            this.ttl = timeout;
            return this;
        }

        public Builder setTimeout(long timeout, TimeUnit timeUnit) {
            this.ttl = TimeUnit.MILLISECONDS.convert(timeout, timeUnit);
            return this;
        }

        public Builder validate() {
            if (this.service == null) {
                throw new IllegalStateException("`service` cannot be null.");
            }
            if (this.arg1 == null && this.endpoint == null) {
                throw new IllegalStateException("`arg1` or `endpoint` cannot be null.");
            }
            if (this.ttl <= 0L) {
                throw new IllegalStateException("`timeout` must be greater than 0.");
            }
            if (this.retryLimit < 0) {
                throw new IllegalStateException("`retryLimit` must be greater equal to 0.");
            }
            return this;
        }
    }
}

