/*
 * Decompiled with CFR 0.152.
 */
package com.uber.tchannel.messages;

import com.uber.tchannel.codecs.CodecUtils;
import com.uber.tchannel.messages.Serializer;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.Unpooled;
import io.netty.util.CharsetUtil;
import java.util.Map;
import org.apache.thrift.TBase;
import org.apache.thrift.TDeserializer;
import org.apache.thrift.TException;
import org.apache.thrift.TSerializer;
import org.apache.thrift.protocol.TBinaryProtocol;

public class ThriftSerializer
implements Serializer.SerializerInterface {
    @Override
    public String decodeEndpoint(ByteBuf arg1) {
        String endpoint = arg1.toString(CharsetUtil.UTF_8);
        return endpoint;
    }

    @Override
    public Map<String, String> decodeHeaders(ByteBuf arg2) {
        Map<String, String> headers = CodecUtils.decodeHeaders(arg2);
        return headers;
    }

    @Override
    public <T> T decodeBody(ByteBuf arg3, Class<T> bodyType) {
        try {
            T base = bodyType.newInstance();
            byte[] payloadBytes = new byte[arg3.readableBytes()];
            arg3.readBytes(payloadBytes);
            TDeserializer deserializer = new TDeserializer(new TBinaryProtocol.Factory());
            deserializer.deserialize((TBase)base, payloadBytes);
            return base;
        }
        catch (IllegalAccessException | InstantiationException | TException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public ByteBuf encodeEndpoint(String method) {
        return Unpooled.wrappedBuffer(method.getBytes());
    }

    @Override
    public ByteBuf encodeHeaders(Map<String, String> applicationHeaders) {
        ByteBuf buf = ByteBufAllocator.DEFAULT.buffer();
        CodecUtils.encodeHeaders(applicationHeaders, buf);
        return buf;
    }

    @Override
    public ByteBuf encodeBody(Object body) {
        try {
            TSerializer serializer = new TSerializer(new TBinaryProtocol.Factory());
            byte[] payloadBytes = serializer.serialize((TBase)body);
            return Unpooled.wrappedBuffer(payloadBytes);
        }
        catch (TException e) {
            e.printStackTrace();
            return null;
        }
    }
}

