/*
 * Decompiled with CFR 0.152.
 */
package com.uber.tchannel.hyperbahn.api;

import com.google.gson.Gson;
import com.uber.tchannel.api.SubChannel;
import com.uber.tchannel.api.TChannel;
import com.uber.tchannel.api.TFuture;
import com.uber.tchannel.api.handlers.TFutureCallback;
import com.uber.tchannel.channels.Connection;
import com.uber.tchannel.hyperbahn.messages.AdvertiseRequest;
import com.uber.tchannel.hyperbahn.messages.AdvertiseResponse;
import com.uber.tchannel.messages.JsonRequest;
import com.uber.tchannel.messages.JsonResponse;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HyperbahnClient {
    private static final Logger logger = LoggerFactory.getLogger(HyperbahnClient.class);
    private static final String HYPERBAHN_SERVICE_NAME = "hyperbahn";
    private static final String HYPERBAHN_ADVERTISE_ENDPOINT = "ad";
    public AtomicBoolean destroyed = new AtomicBoolean(false);
    private final String service;
    private final TChannel tchannel;
    private final SubChannel hyperbahnChannel;
    private final List<InetSocketAddress> routers;
    private final long advertiseTimeout;
    private final long advertiseInterval;
    private final Timer advertiseTimer = new Timer(true);
    private static final long requestTimeout = 1000L;

    private HyperbahnClient(Builder builder) {
        this.service = builder.service;
        this.tchannel = builder.channel;
        this.routers = builder.routers;
        this.advertiseTimeout = builder.advertiseTimeout;
        this.advertiseInterval = builder.advertiseInterval;
        this.hyperbahnChannel = this.makeClientChannel(HYPERBAHN_SERVICE_NAME);
    }

    public SubChannel makeClientChannel(String service) {
        return this.tchannel.makeSubChannel(service, Connection.Direction.IN).setPeers(this.routers);
    }

    public TFuture<JsonResponse<AdvertiseResponse>> advertise() {
        AdvertiseRequest advertiseRequest = new AdvertiseRequest();
        advertiseRequest.addService(this.service, 0);
        JsonRequest request = new JsonRequest.Builder(HYPERBAHN_SERVICE_NAME, HYPERBAHN_ADVERTISE_ENDPOINT).setBody((Object)advertiseRequest).setTimeout(1000L).setRetryLimit(4).build();
        TFuture future = this.hyperbahnChannel.send(request);
        future.addCallback((TFutureCallback)new TFutureCallback<JsonResponse<AdvertiseResponse>>(){

            public void onResponse(JsonResponse<AdvertiseResponse> response) {
                if (response.isError()) {
                    logger.error("Failed to advertise to Hyperbahn: {} - {}", (Object)response.getError().getErrorType(), (Object)response.getError().getMessage());
                }
                if (HyperbahnClient.this.destroyed.get()) {
                    return;
                }
                HyperbahnClient.this.scheduleAdvertise();
            }
        });
        return future;
    }

    private void scheduleAdvertise() {
        if (this.destroyed.get()) {
            return;
        }
        this.advertiseTimer.schedule(new TimerTask(){

            @Override
            public void run() {
                HyperbahnClient.this.advertise();
            }
        }, this.advertiseInterval);
    }

    public void stopAdvertising() {
        this.advertiseTimer.cancel();
    }

    public void shutdown() {
        if (!this.destroyed.compareAndSet(false, true)) {
            return;
        }
        logger.info("Shutting down HyperbahnClient and TChannel.");
        this.stopAdvertising();
        this.tchannel.shutdown();
        this.routers.clear();
        logger.info("HyperbahnClient shutdown complete.");
    }

    public static class Builder {
        private final String service;
        private final TChannel channel;
        private List<InetSocketAddress> routers;
        private long advertiseTimeout = 5000L;
        private long advertiseInterval = 60000L;

        public Builder(String service, TChannel channel) {
            if (service == null) {
                throw new NullPointerException("`service` cannot be null");
            }
            if (channel == null) {
                throw new NullPointerException("`channel` cannot be null");
            }
            this.service = service;
            this.channel = channel;
        }

        public Builder setAdvertiseTimeout(long advertiseTimeout) {
            this.advertiseTimeout = advertiseTimeout;
            return this;
        }

        public Builder setAdvertiseInterval(long advertiseInterval) {
            this.advertiseInterval = advertiseInterval;
            return this;
        }

        public Builder setRouters(List<InetSocketAddress> routers) {
            this.routers = routers;
            return this;
        }

        public Builder setRouterFile(String routerFile) throws IOException {
            this.routers = Builder.loadRouters(routerFile);
            return this;
        }

        private static List<InetSocketAddress> loadRouters(String hostsFilePath) throws IOException {
            List hostPorts;
            FileReader reader = new FileReader(hostsFilePath);
            Object object = null;
            try {
                hostPorts = (List)new Gson().fromJson((Reader)reader, List.class);
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (reader != null) {
                    if (object != null) {
                        try {
                            ((Reader)reader).close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        ((Reader)reader).close();
                    }
                }
            }
            ArrayList<InetSocketAddress> routers = new ArrayList<InetSocketAddress>();
            for (String hostPort : hostPorts) {
                String[] hostPortPair = hostPort.split(Pattern.quote(":"));
                String host = hostPortPair[0];
                int port = Integer.parseInt(hostPortPair[1]);
                InetSocketAddress router = new InetSocketAddress(host, port);
                routers.add(router);
            }
            return routers;
        }

        public HyperbahnClient build() {
            return new HyperbahnClient(this);
        }
    }
}

