/*
 * Copyright (c) 2015 Uber Technologies, Inc.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

package com.uber.tchannel.hyperbahn.messages;

import java.util.ArrayList;
import java.util.List;

public class AdvertiseRequest {

    private final List<Service> services;

    public AdvertiseRequest(List<Service> services) {
        this.services = services;
    }

    public AdvertiseRequest() {
        services = new ArrayList<Service>();
    }

    public void addService(String serviceName, int cost) {
        services.add(new Service(serviceName, cost));
    }

    @Override
    public String toString() {
        return String.format(
                "<%s services=%s>",
                this.getClass().getSimpleName(),
                this.services
        );
    }

    // Inner class representing a service object in a hyperbahn message.
    public class Service {
        private final String serviceName;
        private final int cost;

        public Service(String serviceName, int cost) {
            this.serviceName = serviceName;
            this.cost = cost;
        }

        @Override
        public String toString() {
            return String.format(
                    "<%s serviceName=%s cost=%d>",
                    this.getClass().getSimpleName(),
                    this.serviceName,
                    this.cost
            );
        }
    }
}

