/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.scim.marshal.json;

import com.unboundid.scim.data.BaseResource;
import com.unboundid.scim.data.ResourceFactory;
import com.unboundid.scim.schema.AttributeDescriptor;
import com.unboundid.scim.schema.CoreSchema;
import com.unboundid.scim.schema.ResourceDescriptor;
import com.unboundid.scim.sdk.InvalidResourceException;
import com.unboundid.scim.sdk.SCIMAttribute;
import com.unboundid.scim.sdk.SCIMAttributeValue;
import com.unboundid.scim.sdk.SCIMObject;
import com.unboundid.scim.sdk.StaticUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JsonParser {
    protected <R extends BaseResource> R unmarshal(JSONObject jsonObject, ResourceDescriptor resourceDescriptor, ResourceFactory<R> resourceFactory, JSONArray defaultSchemas) throws JSONException, InvalidResourceException {
        try {
            JSONArray schemas;
            SCIMObject scimObject = new SCIMObject();
            boolean implicitSchemaChecking = Boolean.getBoolean("com.unboundid.scim.implicit-schema-checking");
            if (jsonObject.has("schemas")) {
                schemas = jsonObject.getJSONArray("schemas");
            } else if (defaultSchemas != null) {
                schemas = defaultSchemas;
            } else {
                String[] schemaArray = new String[]{resourceDescriptor.getSchema()};
                schemas = new JSONArray((Object)schemaArray);
            }
            HashSet<String> schemaSet = new HashSet<String>(schemas.length());
            if (implicitSchemaChecking) {
                schemaSet.addAll(resourceDescriptor.getAttributeSchemas());
            }
            for (int i = 0; i < schemas.length(); ++i) {
                schemaSet.add(StaticUtils.toLowerCase(schemas.getString(i)));
            }
            Iterator k = jsonObject.keys();
            while (k.hasNext()) {
                AttributeDescriptor attributeDescriptor;
                String attributeKey = (String)k.next();
                String attributeKeyLower = StaticUtils.toLowerCase(attributeKey);
                if ("schemas".equals(attributeKeyLower)) continue;
                if (schemaSet.contains(attributeKeyLower)) {
                    JSONObject schemaAttrs = jsonObject.getJSONObject(attributeKey);
                    Iterator keys = schemaAttrs.keys();
                    while (keys.hasNext()) {
                        Object jsonAttribute;
                        String attributeName = (String)keys.next();
                        attributeDescriptor = resourceDescriptor.getAttribute(attributeKey, attributeName);
                        SCIMAttribute a = this.create(attributeDescriptor, jsonAttribute = schemaAttrs.get(attributeName));
                        if (a == null) continue;
                        scimObject.addAttribute(a);
                    }
                    continue;
                }
                Object jsonAttribute = jsonObject.get(attributeKey);
                if (implicitSchemaChecking) {
                    SCIMAttribute a;
                    String attributeName = attributeKey;
                    String schema = resourceDescriptor.findAttributeSchema(attributeName, new String[0]);
                    attributeDescriptor = resourceDescriptor.getAttribute(schema, attributeName);
                    if (CoreSchema.META_DESCRIPTOR.equals(attributeDescriptor)) {
                        try {
                            JSONObject jsonMetaObj = (JSONObject)jsonAttribute;
                            JSONArray metaAttrs = null;
                            Iterator keys = jsonMetaObj.keys();
                            while (keys.hasNext()) {
                                String key = (String)keys.next();
                                if (!"attributes".equals(key.toLowerCase())) continue;
                                Object attrObj = jsonMetaObj.get(key);
                                if (!(attrObj instanceof JSONArray)) break;
                                metaAttrs = (JSONArray)attrObj;
                                break;
                            }
                            if (metaAttrs != null) {
                                JSONArray newMetaAttrs = new JSONArray();
                                for (int i = 0; i < metaAttrs.length(); ++i) {
                                    String metaAttr = (String)metaAttrs.get(i);
                                    String metaSchema = resourceDescriptor.findAttributeSchema(metaAttr, new String[0]);
                                    if (metaSchema != null) {
                                        metaAttr = metaSchema + ':' + metaAttr;
                                    }
                                    newMetaAttrs.put((Object)metaAttr);
                                }
                                jsonMetaObj.put("attributes", (Object)newMetaAttrs);
                            }
                        }
                        catch (Exception jsonMetaObj) {
                            // empty catch block
                        }
                    }
                    if ((a = this.create(attributeDescriptor, jsonAttribute)) == null) continue;
                    scimObject.addAttribute(a);
                    continue;
                }
                if (!schemaSet.contains("urn:scim:schemas:core:1.0")) {
                    throw new Exception("'urn:scim:schemas:core:1.0' must be declared in the schemas attribute.");
                }
                AttributeDescriptor attributeDescriptor2 = resourceDescriptor.getAttribute("urn:scim:schemas:core:1.0", attributeKey);
                SCIMAttribute a = this.create(attributeDescriptor2, jsonAttribute);
                if (a == null) continue;
                scimObject.addAttribute(a);
            }
            return resourceFactory.createResource(resourceDescriptor, scimObject);
        }
        catch (Exception e) {
            throw new InvalidResourceException("Resource '" + resourceDescriptor.getName() + "' is malformed: " + e.getMessage(), e);
        }
    }

    protected SCIMAttribute createSimpleAttribute(Object jsonAttribute, AttributeDescriptor attributeDescriptor) {
        return SCIMAttribute.create(attributeDescriptor, SCIMAttributeValue.createValue(attributeDescriptor.getDataType(), jsonAttribute.toString()));
    }

    protected SCIMAttribute createMultiValuedAttribute(JSONArray jsonAttribute, AttributeDescriptor attributeDescriptor) throws JSONException, InvalidResourceException {
        ArrayList<SCIMAttributeValue> values = new ArrayList<SCIMAttributeValue>(jsonAttribute.length());
        for (int i = 0; i < jsonAttribute.length(); ++i) {
            SCIMAttributeValue value;
            Object o = jsonAttribute.get(i);
            if (o.equals(JSONObject.NULL)) continue;
            if (o instanceof JSONObject) {
                value = this.createComplexAttribute((JSONObject)o, attributeDescriptor);
            } else {
                SCIMAttribute subAttr = SCIMAttribute.create(attributeDescriptor.getSubAttribute("value"), SCIMAttributeValue.createValue(attributeDescriptor.getDataType(), o.toString()));
                value = SCIMAttributeValue.createComplexValue(subAttr);
            }
            values.add(value);
        }
        if (values.isEmpty()) {
            return null;
        }
        SCIMAttributeValue[] vals = new SCIMAttributeValue[values.size()];
        vals = values.toArray(vals);
        return SCIMAttribute.create(attributeDescriptor, vals);
    }

    protected SCIMAttributeValue createComplexAttribute(JSONObject jsonAttribute, AttributeDescriptor attributeDescriptor) throws JSONException, InvalidResourceException {
        Iterator keys = jsonAttribute.keys();
        ArrayList<SCIMAttribute> complexAttrs = new ArrayList<SCIMAttribute>(jsonAttribute.length());
        while (keys.hasNext()) {
            Object o;
            String key = (String)keys.next();
            AttributeDescriptor subAttribute = attributeDescriptor.getSubAttribute(key);
            if (subAttribute == null) continue;
            SCIMAttribute childAttr = null;
            if (subAttribute.isMultiValued()) {
                o = jsonAttribute.getJSONArray(key);
                childAttr = this.createMultiValuedAttribute((JSONArray)o, subAttribute);
            } else {
                o = jsonAttribute.get(key);
                if (!o.equals(JSONObject.NULL)) {
                    childAttr = this.createSimpleAttribute(o, subAttribute);
                }
            }
            if (childAttr == null) continue;
            complexAttrs.add(childAttr);
        }
        return SCIMAttributeValue.createComplexValue(complexAttrs);
    }

    protected SCIMAttribute create(AttributeDescriptor descriptor, Object jsonAttribute) throws JSONException, InvalidResourceException {
        if (jsonAttribute.equals(JSONObject.NULL)) {
            return null;
        }
        if (descriptor.isMultiValued()) {
            JSONArray jsonArray;
            if (jsonAttribute instanceof JSONArray) {
                jsonArray = (JSONArray)jsonAttribute;
            } else {
                String[] s = new String[]{jsonAttribute.toString()};
                jsonArray = new JSONArray((Object)s);
            }
            return this.createMultiValuedAttribute(jsonArray, descriptor);
        }
        if (descriptor.getDataType() == AttributeDescriptor.DataType.COMPLEX) {
            if (!(jsonAttribute instanceof JSONObject)) {
                throw new InvalidResourceException("JSON object expected for complex attribute '" + descriptor.getName() + "'");
            }
            return SCIMAttribute.create(descriptor, this.createComplexAttribute((JSONObject)jsonAttribute, descriptor));
        }
        return this.createSimpleAttribute(jsonAttribute, descriptor);
    }

    static final JSONObject makeCaseInsensitive(JSONObject jsonObject) throws JSONException {
        if (jsonObject == null) {
            return null;
        }
        Iterator keys = jsonObject.keys();
        HashMap<String, Object> lowerCaseMap = new HashMap<String, Object>(jsonObject.length());
        while (keys.hasNext()) {
            String key = keys.next().toString();
            String lowerCaseKey = StaticUtils.toLowerCase(key);
            lowerCaseMap.put(lowerCaseKey, jsonObject.get(key));
        }
        return new JSONObject(lowerCaseMap);
    }
}

