/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.scim.marshal.json;

import com.unboundid.scim.data.BaseResource;
import com.unboundid.scim.data.BulkConfig;
import com.unboundid.scim.data.ResourceFactory;
import com.unboundid.scim.marshal.Unmarshaller;
import com.unboundid.scim.marshal.json.JsonBulkParser;
import com.unboundid.scim.marshal.json.JsonParser;
import com.unboundid.scim.schema.ResourceDescriptor;
import com.unboundid.scim.sdk.BulkContentHandler;
import com.unboundid.scim.sdk.Debug;
import com.unboundid.scim.sdk.InvalidResourceException;
import com.unboundid.scim.sdk.Resources;
import com.unboundid.scim.sdk.SCIMException;
import com.unboundid.scim.sdk.ServerErrorException;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JsonUnmarshaller
implements Unmarshaller {
    @Override
    public <R extends BaseResource> R unmarshal(InputStream inputStream, ResourceDescriptor resourceDescriptor, ResourceFactory<R> resourceFactory) throws InvalidResourceException {
        try {
            JSONObject jsonObject = JsonParser.makeCaseInsensitive(new JSONObject(new JSONTokener(inputStream)));
            JsonParser parser = new JsonParser();
            return parser.unmarshal(jsonObject, resourceDescriptor, resourceFactory, null);
        }
        catch (JSONException e) {
            throw new InvalidResourceException("Error while reading JSON: " + e.getMessage(), e);
        }
    }

    @Override
    public <R extends BaseResource> Resources<R> unmarshalResources(InputStream inputStream, ResourceDescriptor resourceDescriptor, ResourceFactory<R> resourceFactory) throws InvalidResourceException {
        try {
            JsonParser parser = new JsonParser();
            JSONObject jsonObject = JsonParser.makeCaseInsensitive(new JSONObject(new JSONTokener(inputStream)));
            int totalResults = 0;
            if (jsonObject.has("totalresults")) {
                totalResults = jsonObject.getInt("totalresults");
            }
            int startIndex = 1;
            if (jsonObject.has("startindex")) {
                startIndex = jsonObject.getInt("startindex");
            }
            JSONArray schemas = jsonObject.optJSONArray("schemas");
            List resources = Collections.emptyList();
            if (jsonObject.has("resources")) {
                JSONArray resourcesArray = jsonObject.getJSONArray("resources");
                resources = new ArrayList(resourcesArray.length());
                for (int i = 0; i < resourcesArray.length(); ++i) {
                    JSONObject subObject = JsonParser.makeCaseInsensitive(resourcesArray.getJSONObject(i));
                    R resource = parser.unmarshal(subObject, resourceDescriptor, resourceFactory, schemas);
                    resources.add(resource);
                }
            }
            return new Resources(resources, totalResults, startIndex);
        }
        catch (JSONException e) {
            throw new InvalidResourceException("Error while reading JSON: " + e.getMessage(), e);
        }
    }

    @Override
    public SCIMException unmarshalError(InputStream inputStream) throws InvalidResourceException {
        try {
            JSONArray errors;
            JSONObject jsonObject = JsonParser.makeCaseInsensitive(new JSONObject(new JSONTokener(inputStream)));
            if (jsonObject.has("errors") && (errors = jsonObject.getJSONArray("errors")).length() >= 1) {
                JSONObject error = errors.getJSONObject(0);
                int code = error.optInt("code");
                String description = error.optString("description");
                return SCIMException.createException(code, description);
            }
            return null;
        }
        catch (JSONException e) {
            throw new InvalidResourceException("Error while reading JSON: " + e.getMessage(), e);
        }
    }

    @Override
    public void bulkUnmarshal(InputStream inputStream, BulkConfig bulkConfig, BulkContentHandler handler) throws SCIMException {
        JsonBulkParser bulkUnmarshaller = new JsonBulkParser(inputStream, bulkConfig, handler);
        bulkUnmarshaller.unmarshal();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void bulkUnmarshal(File file, BulkConfig bulkConfig, BulkContentHandler handler) throws SCIMException {
        final AtomicInteger failOnErrorsValue = new AtomicInteger(-1);
        BulkContentHandler preProcessHandler = new BulkContentHandler(){

            public void handleFailOnErrors(int failOnErrors) {
                failOnErrorsValue.set(failOnErrors);
            }
        };
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            try {
                BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream);
                try {
                    JsonBulkParser jsonBulkParser = new JsonBulkParser(bufferedInputStream, bulkConfig, preProcessHandler);
                    jsonBulkParser.setSkipOperations(true);
                    jsonBulkParser.unmarshal();
                }
                finally {
                    bufferedInputStream.close();
                }
            }
            finally {
                fileInputStream.close();
            }
        }
        catch (IOException e) {
            Debug.debugException(e);
            throw new ServerErrorException("Error pre-processing bulk request: " + e.getMessage());
        }
        int failOnErrors = failOnErrorsValue.get();
        if (failOnErrors != -1) {
            handler.handleFailOnErrors(failOnErrors);
        }
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            try {
                BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream);
                try {
                    JsonBulkParser jsonBulkParser = new JsonBulkParser(bufferedInputStream, bulkConfig, handler);
                    jsonBulkParser.unmarshal();
                }
                finally {
                    bufferedInputStream.close();
                }
            }
            finally {
                fileInputStream.close();
            }
        }
        catch (IOException e) {
            Debug.debugException(e);
            throw new ServerErrorException("Error parsing bulk request: " + e.getMessage());
        }
    }
}

