/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.scim.sdk;

import com.unboundid.scim.data.BaseResource;
import com.unboundid.scim.data.Meta;
import com.unboundid.scim.data.ResourceFactory;
import com.unboundid.scim.marshal.Marshaller;
import com.unboundid.scim.marshal.Unmarshaller;
import com.unboundid.scim.marshal.json.JsonMarshaller;
import com.unboundid.scim.marshal.json.JsonUnmarshaller;
import com.unboundid.scim.marshal.xml.XmlMarshaller;
import com.unboundid.scim.marshal.xml.XmlUnmarshaller;
import com.unboundid.scim.schema.ResourceDescriptor;
import com.unboundid.scim.sdk.Debug;
import com.unboundid.scim.sdk.Diff;
import com.unboundid.scim.sdk.InvalidResourceException;
import com.unboundid.scim.sdk.NotModifiedException;
import com.unboundid.scim.sdk.PageParameters;
import com.unboundid.scim.sdk.PreconditionFailedException;
import com.unboundid.scim.sdk.Resources;
import com.unboundid.scim.sdk.SCIMAttribute;
import com.unboundid.scim.sdk.SCIMException;
import com.unboundid.scim.sdk.SCIMObject;
import com.unboundid.scim.sdk.SCIMService;
import com.unboundid.scim.sdk.SortParameters;
import com.unboundid.scim.sdk.StaticUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Map;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import javax.ws.rs.core.UriBuilder;
import org.apache.http.ConnectionClosedException;
import org.apache.http.HttpException;
import org.apache.http.MethodNotSupportedException;
import org.apache.http.NoHttpResponseException;
import org.apache.http.UnsupportedHttpVersionException;
import org.apache.http.auth.AuthenticationException;
import org.apache.http.client.HttpResponseException;
import org.apache.http.client.RedirectException;
import org.apache.wink.client.ClientAuthenticationException;
import org.apache.wink.client.ClientConfigException;
import org.apache.wink.client.ClientResponse;
import org.apache.wink.client.ClientRuntimeException;
import org.apache.wink.client.ClientWebException;
import org.apache.wink.client.Resource;
import org.apache.wink.client.RestClient;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SCIMEndpoint<R extends BaseResource> {
    private final SCIMService scimService;
    private final ResourceDescriptor resourceDescriptor;
    private final ResourceFactory<R> resourceFactory;
    private final Unmarshaller unmarshaller;
    private final Marshaller marshaller;
    private final MediaType contentType;
    private final MediaType acceptType;
    private final boolean[] overrides = new boolean[3];
    private final RestClient client;
    private final boolean useUrlSuffix;

    SCIMEndpoint(SCIMService scimService, RestClient restClient, ResourceDescriptor resourceDescriptor, ResourceFactory<R> resourceFactory) {
        this.scimService = scimService;
        this.client = restClient;
        this.resourceDescriptor = resourceDescriptor;
        this.resourceFactory = resourceFactory;
        this.contentType = scimService.getContentType();
        this.acceptType = scimService.getAcceptType();
        this.overrides[0] = scimService.isOverridePut();
        this.overrides[1] = scimService.isOverridePatch();
        this.overrides[2] = scimService.isOverrideDelete();
        this.useUrlSuffix = scimService.isUseUrlSuffix();
        this.marshaller = scimService.getContentType().equals((Object)MediaType.APPLICATION_JSON_TYPE) ? new JsonMarshaller() : new XmlMarshaller();
        this.unmarshaller = scimService.getAcceptType().equals((Object)MediaType.APPLICATION_JSON_TYPE) ? new JsonUnmarshaller() : new XmlUnmarshaller();
    }

    public R newResource() {
        return this.resourceFactory.createResource(this.resourceDescriptor, new SCIMObject());
    }

    public R get(String id) throws SCIMException {
        return this.get(id, null, null);
    }

    public R get(String id, String etag, String ... requestedAttributes) throws SCIMException {
        UriBuilder uriBuilder = UriBuilder.fromUri((URI)this.scimService.getBaseURL());
        uriBuilder.path(this.resourceDescriptor.getEndpoint());
        if (id != null) {
            uriBuilder.path(id);
        }
        URI uri = uriBuilder.build(new Object[0]);
        Resource clientResource = this.client.resource(this.completeUri(uri));
        if (!this.useUrlSuffix) {
            clientResource.accept(this.acceptType);
        }
        clientResource.contentType(this.contentType);
        this.addAttributesQuery(clientResource, requestedAttributes);
        if (this.scimService.getUserAgent() != null) {
            clientResource.header("User-Agent", this.scimService.getUserAgent());
        }
        if (etag != null && !etag.isEmpty()) {
            clientResource.header("If-None-Match", etag);
        }
        InputStream entity = null;
        try {
            ClientResponse response = clientResource.get();
            entity = response.getEntity(InputStream.class);
            if (response.getStatusType() == Response.Status.OK) {
                R resource = this.unmarshaller.unmarshal(entity, this.resourceDescriptor, this.resourceFactory);
                this.addMissingMetaData(response, resource);
                R r = resource;
                return r;
            }
            try {
                throw this.createErrorResponseException(response, entity);
            }
            catch (SCIMException e) {
                throw e;
            }
            catch (Exception e) {
                throw SCIMException.createException(SCIMEndpoint.getStatusCode(e), SCIMEndpoint.getExceptionMessage(e), e);
            }
        }
        finally {
            try {
                if (entity != null) {
                    entity.close();
                }
            }
            catch (IOException e) {
                Debug.debugException(e);
            }
        }
    }

    public Resources<R> query(String filter) throws SCIMException {
        return this.query(filter, null, null, new String[0]);
    }

    public Resources<R> query(String filter, SortParameters sortParameters, PageParameters pageParameters, String ... requestedAttributes) throws SCIMException {
        return this.query(filter, sortParameters, pageParameters, (Map<String, String>)null, requestedAttributes);
    }

    public Resources<R> query(String filter, SortParameters sortParameters, PageParameters pageParameters, Map<String, String> additionalQueryParams, String ... requestedAttributes) throws SCIMException {
        URI uri = UriBuilder.fromUri((URI)this.scimService.getBaseURL()).path(this.resourceDescriptor.getEndpoint()).build(new Object[0]);
        Resource clientResource = this.client.resource(this.completeUri(uri));
        if (!this.useUrlSuffix) {
            clientResource.accept(this.acceptType);
        }
        clientResource.contentType(this.contentType);
        this.addAttributesQuery(clientResource, requestedAttributes);
        if (this.scimService.getUserAgent() != null) {
            clientResource.header("User-Agent", this.scimService.getUserAgent());
        }
        if (filter != null) {
            clientResource.queryParam("filter", filter);
        }
        if (sortParameters != null) {
            clientResource.queryParam("sortBy", sortParameters.getSortBy().toString());
            if (!sortParameters.isAscendingOrder()) {
                clientResource.queryParam("sortOrder", sortParameters.getSortOrder());
            }
        }
        if (pageParameters != null) {
            clientResource.queryParam("startIndex", String.valueOf(pageParameters.getStartIndex()));
            if (pageParameters.getCount() > 0) {
                clientResource.queryParam("count", String.valueOf(pageParameters.getCount()));
            }
        }
        if (additionalQueryParams != null) {
            for (String key : additionalQueryParams.keySet()) {
                clientResource.queryParam(key, additionalQueryParams.get(key));
            }
        }
        InputStream entity = null;
        try {
            ClientResponse response = clientResource.get();
            entity = response.getEntity(InputStream.class);
            if (response.getStatusType() == Response.Status.OK) {
                Resources<R> resources = this.unmarshaller.unmarshalResources(entity, this.resourceDescriptor, this.resourceFactory);
                return resources;
            }
            try {
                throw this.createErrorResponseException(response, entity);
            }
            catch (SCIMException e) {
                throw e;
            }
            catch (Exception e) {
                throw SCIMException.createException(SCIMEndpoint.getStatusCode(e), SCIMEndpoint.getExceptionMessage(e), e);
            }
        }
        finally {
            try {
                if (entity != null) {
                    entity.close();
                }
            }
            catch (IOException e) {
                Debug.debugException(e);
            }
        }
    }

    public R create(R resource, String ... requestedAttributes) throws SCIMException {
        URI uri = UriBuilder.fromUri((URI)this.scimService.getBaseURL()).path(this.resourceDescriptor.getEndpoint()).build(new Object[0]);
        Resource clientResource = this.client.resource(this.completeUri(uri));
        if (!this.useUrlSuffix) {
            clientResource.accept(this.acceptType);
        }
        clientResource.contentType(this.contentType);
        this.addAttributesQuery(clientResource, requestedAttributes);
        if (this.scimService.getUserAgent() != null) {
            clientResource.header("User-Agent", this.scimService.getUserAgent());
        }
        StreamingOutput output = new StreamingOutput((BaseResource)resource){
            final /* synthetic */ BaseResource val$resource;
            {
                this.val$resource = baseResource;
            }

            public void write(OutputStream outputStream) throws IOException, WebApplicationException {
                try {
                    SCIMEndpoint.this.marshaller.marshal(this.val$resource, outputStream);
                }
                catch (Exception e) {
                    throw new WebApplicationException((Throwable)e, Response.Status.BAD_REQUEST);
                }
            }
        };
        InputStream entity = null;
        try {
            ClientResponse response = clientResource.post(output);
            entity = response.getEntity(InputStream.class);
            if (response.getStatusType() == Response.Status.CREATED) {
                R postedResource = this.unmarshaller.unmarshal(entity, this.resourceDescriptor, this.resourceFactory);
                this.addMissingMetaData(response, postedResource);
                R r = postedResource;
                return r;
            }
            try {
                throw this.createErrorResponseException(response, entity);
            }
            catch (SCIMException e) {
                throw e;
            }
            catch (Exception e) {
                throw SCIMException.createException(SCIMEndpoint.getStatusCode(e), SCIMEndpoint.getExceptionMessage(e), e);
            }
        }
        finally {
            try {
                if (entity != null) {
                    entity.close();
                }
            }
            catch (IOException e) {
                Debug.debugException(e);
            }
        }
    }

    public R update(R resource) throws SCIMException {
        if (((BaseResource)resource).getId() == null) {
            throw new InvalidResourceException("Resource must have a valid ID");
        }
        return this.update(((BaseResource)resource).getId(), ((BaseResource)resource).getMeta() == null ? null : ((BaseResource)resource).getMeta().getVersion(), resource, new String[0]);
    }

    @Deprecated
    public R update(R resource, String etag, String ... requestedAttributes) throws SCIMException {
        String id = ((BaseResource)resource).getId();
        if (id == null) {
            throw new InvalidResourceException("Resource must have a valid ID");
        }
        return this.update(id, etag, resource, requestedAttributes);
    }

    public R update(String id, String etag, R resource, String ... requestedAttributes) throws SCIMException {
        URI uri = UriBuilder.fromUri((URI)this.scimService.getBaseURL()).path(this.resourceDescriptor.getEndpoint()).path(id).build(new Object[0]);
        Resource clientResource = this.client.resource(this.completeUri(uri));
        if (!this.useUrlSuffix) {
            clientResource.accept(this.acceptType);
        }
        clientResource.contentType(this.contentType);
        this.addAttributesQuery(clientResource, requestedAttributes);
        if (this.scimService.getUserAgent() != null) {
            clientResource.header("User-Agent", this.scimService.getUserAgent());
        }
        if (etag != null && !etag.isEmpty()) {
            clientResource.header("If-Match", etag);
        }
        StreamingOutput output = new StreamingOutput((BaseResource)resource){
            final /* synthetic */ BaseResource val$resource;
            {
                this.val$resource = baseResource;
            }

            public void write(OutputStream outputStream) throws IOException, WebApplicationException {
                try {
                    SCIMEndpoint.this.marshaller.marshal(this.val$resource, outputStream);
                }
                catch (Exception e) {
                    throw new WebApplicationException((Throwable)e, Response.Status.BAD_REQUEST);
                }
            }
        };
        InputStream entity = null;
        try {
            ClientResponse response;
            if (this.overrides[0]) {
                clientResource.header("X-HTTP-Method-Override", "PUT");
                response = clientResource.post(output);
            } else {
                response = clientResource.put(output);
            }
            entity = response.getEntity(InputStream.class);
            if (response.getStatusType() == Response.Status.OK) {
                R postedResource = this.unmarshaller.unmarshal(entity, this.resourceDescriptor, this.resourceFactory);
                this.addMissingMetaData(response, postedResource);
                R r = postedResource;
                return r;
            }
            try {
                throw this.createErrorResponseException(response, entity);
            }
            catch (SCIMException e) {
                throw e;
            }
            catch (Exception e) {
                throw SCIMException.createException(SCIMEndpoint.getStatusCode(e), SCIMEndpoint.getExceptionMessage(e), e);
            }
        }
        finally {
            try {
                if (entity != null) {
                    entity.close();
                }
            }
            catch (IOException e) {
                Debug.debugException(e);
            }
        }
    }

    public R update(R resource, List<SCIMAttribute> attributesToUpdate, List<String> attributesToDelete) throws SCIMException {
        if (((BaseResource)resource).getId() == null) {
            throw new InvalidResourceException("Resource must have a valid ID");
        }
        return this.update(((BaseResource)resource).getId(), ((BaseResource)resource).getMeta() == null ? null : ((BaseResource)resource).getMeta().getVersion(), attributesToUpdate, attributesToDelete, new String[0]);
    }

    public R update(String id, String etag, List<SCIMAttribute> attributesToUpdate, List<String> attributesToDelete, String ... requestedAttributes) throws SCIMException {
        URI uri = UriBuilder.fromUri((URI)this.scimService.getBaseURL()).path(this.resourceDescriptor.getEndpoint()).path(id).build(new Object[0]);
        Resource clientResource = this.client.resource(this.completeUri(uri));
        if (!this.useUrlSuffix) {
            clientResource.accept(this.acceptType);
        }
        clientResource.contentType(this.contentType);
        this.addAttributesQuery(clientResource, requestedAttributes);
        if (this.scimService.getUserAgent() != null) {
            clientResource.header("User-Agent", this.scimService.getUserAgent());
        }
        if (etag != null && !etag.isEmpty()) {
            clientResource.header("If-Match", etag);
        }
        Diff<R> diff = new Diff<R>(this.resourceDescriptor, attributesToDelete, attributesToUpdate);
        Object resource = diff.toPartialResource(this.resourceFactory, true);
        StreamingOutput output = new StreamingOutput((BaseResource)resource){
            final /* synthetic */ BaseResource val$resource;
            {
                this.val$resource = baseResource;
            }

            public void write(OutputStream outputStream) throws IOException, WebApplicationException {
                try {
                    SCIMEndpoint.this.marshaller.marshal(this.val$resource, outputStream);
                }
                catch (Exception e) {
                    throw new WebApplicationException((Throwable)e, Response.Status.BAD_REQUEST);
                }
            }
        };
        InputStream entity = null;
        try {
            ClientResponse response;
            if (this.overrides[1]) {
                clientResource.header("X-HTTP-Method-Override", "PATCH");
                response = clientResource.post(output);
            } else {
                try {
                    response = clientResource.invoke("PATCH", ClientResponse.class, output);
                }
                catch (ClientWebException e) {
                    response = e.getResponse();
                }
            }
            entity = response.getEntity(InputStream.class);
            if (response.getStatusType() == Response.Status.OK) {
                R patchedResource = this.unmarshaller.unmarshal(entity, this.resourceDescriptor, this.resourceFactory);
                this.addMissingMetaData(response, patchedResource);
                R r = patchedResource;
                return r;
            }
            if (response.getStatusType() == Response.Status.NO_CONTENT) {
                R emptyResource = this.resourceFactory.createResource(this.resourceDescriptor, new SCIMObject());
                ((BaseResource)emptyResource).setId(id);
                this.addMissingMetaData(response, emptyResource);
                R r = emptyResource;
                return r;
            }
            try {
                throw this.createErrorResponseException(response, entity);
            }
            catch (SCIMException e) {
                throw e;
            }
            catch (Exception e) {
                throw SCIMException.createException(SCIMEndpoint.getStatusCode(e), SCIMEndpoint.getExceptionMessage(e), e);
            }
        }
        finally {
            try {
                if (entity != null) {
                    entity.close();
                }
            }
            catch (IOException e) {
                Debug.debugException(e);
            }
        }
    }

    @Deprecated
    public void update(String id, List<SCIMAttribute> attributesToUpdate, List<String> attributesToDelete) throws SCIMException {
        this.update(id, null, attributesToUpdate, attributesToDelete, new String[0]);
    }

    @Deprecated
    public void delete(String id) throws SCIMException {
        this.delete(id, null);
    }

    public void delete(R resource) throws SCIMException {
        this.delete(((BaseResource)resource).getId(), ((BaseResource)resource).getMeta() == null ? null : ((BaseResource)resource).getMeta().getVersion());
    }

    public void delete(String id, String etag) throws SCIMException {
        URI uri = UriBuilder.fromUri((URI)this.scimService.getBaseURL()).path(this.resourceDescriptor.getEndpoint()).path(id).build(new Object[0]);
        Resource clientResource = this.client.resource(this.completeUri(uri));
        if (!this.useUrlSuffix) {
            clientResource.accept(this.acceptType);
        }
        clientResource.contentType(this.contentType);
        if (this.scimService.getUserAgent() != null) {
            clientResource.header("User-Agent", this.scimService.getUserAgent());
        }
        if (etag != null && !etag.isEmpty()) {
            clientResource.header("If-Match", etag);
        }
        InputStream entity = null;
        try {
            ClientResponse response;
            if (this.overrides[2]) {
                clientResource.header("X-HTTP-Method-Override", "DELETE");
                response = clientResource.post(null);
            } else {
                response = clientResource.delete();
            }
            if (response.getStatusType() != Response.Status.OK) {
                entity = response.getEntity(InputStream.class);
                throw this.createErrorResponseException(response, entity);
            }
            response.consumeContent();
        }
        catch (SCIMException e) {
            throw e;
        }
        catch (ClientRuntimeException cre) {
            Throwable rootCause = StaticUtils.getRootCause(cre);
            if (rootCause == null || !(rootCause instanceof SocketTimeoutException)) {
                throw cre;
            }
        }
        catch (Exception e) {
            throw SCIMException.createException(SCIMEndpoint.getStatusCode(e), SCIMEndpoint.getExceptionMessage(e), e);
        }
        finally {
            try {
                if (entity != null) {
                    entity.close();
                }
            }
            catch (IOException e) {
                Debug.debugException(e);
            }
        }
    }

    private void addAttributesQuery(Resource clientResource, String ... requestedAttributes) {
        if (requestedAttributes != null && requestedAttributes.length > 0) {
            StringBuilder stringBuilder = new StringBuilder();
            for (int i = 0; i < requestedAttributes.length; ++i) {
                stringBuilder.append(requestedAttributes[i]);
                if (i >= requestedAttributes.length - 1) continue;
                stringBuilder.append(",");
            }
            clientResource.queryParam("attributes", stringBuilder.toString());
        }
    }

    private void addMissingMetaData(ClientResponse response, R resource) {
        Meta meta;
        List values;
        URI headerLocation = null;
        String headerEtag = null;
        if (response.getStatusType() == Response.Status.CREATED || response.getStatusType().getFamily() == Response.Status.Family.REDIRECTION) {
            values = (List)response.getHeaders().get((Object)"Location");
        } else {
            values = (List)response.getHeaders().get((Object)"Content-Location");
            if (values == null || values.isEmpty()) {
                values = (List)response.getHeaders().get((Object)"Location");
            }
        }
        if (values != null && !values.isEmpty()) {
            headerLocation = URI.create((String)values.get(0));
        }
        if ((values = (List)response.getHeaders().get((Object)"ETag")) != null && !values.isEmpty()) {
            headerEtag = (String)values.get(0);
        }
        if ((meta = ((BaseResource)resource).getMeta()) == null) {
            meta = new Meta(null, null, null, null);
        }
        boolean modified = false;
        if (headerLocation != null && meta.getLocation() == null) {
            meta.setLocation(headerLocation);
            modified = true;
        }
        if (headerEtag != null && meta.getVersion() == null) {
            meta.setVersion(headerEtag);
            modified = true;
        }
        if (modified) {
            ((BaseResource)resource).setMeta(meta);
        }
    }

    private SCIMException createErrorResponseException(ClientResponse response, InputStream entity) {
        SCIMException scimException = null;
        if (entity != null) {
            try {
                scimException = this.unmarshaller.unmarshalError(entity);
            }
            catch (InvalidResourceException e) {
                Debug.debugException(e);
            }
        }
        if (scimException == null) {
            scimException = SCIMException.createException(response.getStatusCode(), response.getMessage());
        }
        if (response.getStatusType() == Response.Status.PRECONDITION_FAILED) {
            scimException = new PreconditionFailedException(scimException.getMessage(), (String)response.getHeaders().getFirst((Object)"ETag"), scimException.getCause());
        } else if (response.getStatusType() == Response.Status.NOT_MODIFIED) {
            scimException = new NotModifiedException(scimException.getMessage(), (String)response.getHeaders().getFirst((Object)"ETag"), scimException.getCause());
        }
        return scimException;
    }

    private URI completeUri(URI uri) {
        URI completedUri = uri;
        if (this.useUrlSuffix) {
            try {
                if (this.acceptType == MediaType.APPLICATION_JSON_TYPE) {
                    completedUri = new URI(uri.toString() + ".json");
                } else if (this.acceptType == MediaType.APPLICATION_XML_TYPE) {
                    completedUri = new URI(uri.toString() + ".xml");
                }
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
        }
        return completedUri;
    }

    static int getStatusCode(Throwable t) {
        Throwable rootCause = t;
        if (rootCause instanceof ClientRuntimeException) {
            rootCause = StaticUtils.getRootCause(t);
        }
        if (rootCause instanceof HttpResponseException) {
            HttpResponseException hre = (HttpResponseException)rootCause;
            return hre.getStatusCode();
        }
        if (rootCause instanceof HttpException) {
            if (rootCause instanceof RedirectException) {
                return 300;
            }
            if (rootCause instanceof AuthenticationException) {
                return 401;
            }
            if (rootCause instanceof MethodNotSupportedException) {
                return 501;
            }
            if (rootCause instanceof UnsupportedHttpVersionException) {
                return 505;
            }
        } else if (rootCause instanceof IOException) {
            if (rootCause instanceof NoHttpResponseException) {
                return 503;
            }
            if (rootCause instanceof ConnectionClosedException) {
                return 503;
            }
            return -1;
        }
        if (t instanceof ClientWebException) {
            ClientWebException cwe = (ClientWebException)t;
            return cwe.getResponse().getStatusCode();
        }
        if (t instanceof ClientAuthenticationException) {
            return 401;
        }
        if (t instanceof ClientConfigException) {
            return 400;
        }
        return 500;
    }

    static String getExceptionMessage(Throwable t) {
        if (t == null) {
            return null;
        }
        Throwable rootCause = StaticUtils.getRootCause(t);
        return rootCause.getMessage();
    }
}

