/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.scim.tools;

import java.text.MessageFormat;
import java.util.ResourceBundle;
import java.util.concurrent.ConcurrentHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
enum ToolMessages {
    ERR_QUERY_TOOL_BAD_FILTER_PATTERN("Unable to parse the filter pattern: {0}"),
    ERR_QUERY_TOOL_BAD_RESOURCE_ID_PATTERN("Unable to parse the resource ID pattern: {0}"),
    ERR_QUERY_TOOL_CANNOT_CREATE_URL("Unable to create a valid URL from the provided hostname, port and contextPath values: {0}"),
    ERR_QUERY_TOOL_RETRIEVE_RESOURCE_SCHEMA("Error retrieving resource schema: {0}"),
    ERR_QUERY_TOOL_SET_BASIC_AUTH("Unable to set basic authentication: {0}"),
    ERR_SCIM_TOOL_CANNOT_CREATE_KEY_MANAGER("Unable to create the key manager for secure communication:  {0}"),
    ERR_SCIM_TOOL_CANNOT_CREATE_SSL_CONTEXT("Unable to create the SSL context to use for secure communication with the server:  {0}"),
    ERR_SCIM_TOOL_CANNOT_READ_KEY_STORE_PASSWORD("Unable to read the key store password:  {0}"),
    ERR_SCIM_TOOL_CANNOT_READ_TRUST_STORE_PASSWORD("Unable to read the trust store password:  {0}"),
    INFO_QUERY_TOOL_ARG_DESC_ATTRIBUTE("The name of an attribute to include in resources returned from the queries.  Multiple attributes may be requested by providing this argument multiple times.  If no request attributes are provided, then the resources returned will include all available attributes."),
    INFO_QUERY_TOOL_ARG_DESC_AUTHID("The ID to use to authenticate to the server when performing basic authentication."),
    INFO_QUERY_TOOL_ARG_DESC_AUTH_PASSWORD("The password to use to authenticate to the server when performing basic authentication or a password-based SASL mechanism."),
    INFO_QUERY_TOOL_ARG_DESC_AUTH_PASSWORD_FILE("The path to a file containing the password to use to authenticate to the server when performing basic authentication or a password-based SASL mechanism."),
    INFO_QUERY_TOOL_ARG_DESC_BEARER_TOKEN("The OAuth2 bearer token to use when authenticating to the server via OAuth"),
    INFO_QUERY_TOOL_ARG_DESC_CONTEXT_PATH("The context path of the SCIM server.  If no context path is specified, then the default value '/' is used."),
    INFO_QUERY_TOOL_ARG_DESC_CSV_FORMAT("Generate output in CSV format rather than a display-friendly format."),
    INFO_QUERY_TOOL_ARG_DESC_FILTER("The filter to use for the queries.  It may be a simple filter, or it may be a value pattern to express a range of filters (e.g., 'userName eq \"user.[1-1000]\"'). If this isn't specified, then no filtering is requested."),
    INFO_QUERY_TOOL_ARG_DESC_HOSTNAME("The IP address or resolvable name to use to connect to the server.  If this is not provided, then a default value of 'localhost' will be used."),
    INFO_QUERY_TOOL_ARG_DESC_INTERVAL_DURATION("The length of time in seconds between output lines.  If this is not provided, then a default interval of five seconds will be used."),
    INFO_QUERY_TOOL_ARG_DESC_NUM_INTERVALS("The maximum number of intervals for which to run.  If this is not provided, then the tool will run until it is interrupted."),
    INFO_QUERY_TOOL_ARG_DESC_NUM_THREADS("The number of threads to use to perform the queries.  If this is not provided, then a default of one thread will be used."),
    INFO_QUERY_TOOL_ARG_DESC_PORT("The port to use to connect to the server.  If this is not provided, then a default value of 80 will be used."),
    INFO_QUERY_TOOL_ARG_DESC_RANDOM_SEED("Specifies the seed to use for the random number generator."),
    INFO_QUERY_TOOL_ARG_DESC_RATE_PER_SECOND("The target number of queries to perform per second.  It is still necessary to specify a sufficient number of threads for achieving this rate.  If this option is not provided, then the tool will run at the maximum rate for the specified number of threads."),
    INFO_QUERY_TOOL_ARG_DESC_RESOURCE_ID("The ID of a SCIM resource. It may be a literal SCIM resource identifier, or it may be a value pattern to express a range of resource IDs (e.g., 'uid=user.[1-1000],ou=people,dc=example,dc=com'). This may not be used in conjunction with the \"--filter\" argument."),
    INFO_QUERY_TOOL_ARG_DESC_RESOURCE_NAME("The name of resources to be queried.  If this isn't specified, then a default of 'User' will be used."),
    INFO_QUERY_TOOL_ARG_DESC_TIMESTAMP_FORMAT("Indicates the format to use for timestamps included in the output.  A value of 'none' indicates that no timestamps should be included.  A value of 'with-date' indicates that both the date and the time should be included.  A value of 'without-date' indicates that only the time should be included."),
    INFO_QUERY_TOOL_ARG_DESC_WARM_UP_INTERVALS("The number of intervals to complete before beginning overall statistics collection.  Specifying a non-zero number of warm-up intervals gives the client and server a chance to warm up without skewing performance results."),
    INFO_QUERY_TOOL_ARG_DESC_XML_FORMAT("Use XML format in requests rather than JSON format."),
    INFO_QUERY_TOOL_ARG_PLACEHOLDER_ATTRIBUTE("{name}"),
    INFO_QUERY_TOOL_ARG_PLACEHOLDER_AUTHID("{userName}"),
    INFO_QUERY_TOOL_ARG_PLACEHOLDER_AUTH_PASSWORD("{password}"),
    INFO_QUERY_TOOL_ARG_PLACEHOLDER_AUTH_PASSWORD_FILE("{path}"),
    INFO_QUERY_TOOL_ARG_PLACEHOLDER_BEARER_TOKEN("{b64 token}"),
    INFO_QUERY_TOOL_ARG_PLACEHOLDER_CONTEXT_PATH("{path}"),
    INFO_QUERY_TOOL_ARG_PLACEHOLDER_FILTER("{filter}"),
    INFO_QUERY_TOOL_ARG_PLACEHOLDER_HOSTNAME("{host}"),
    INFO_QUERY_TOOL_ARG_PLACEHOLDER_INTERVAL_DURATION("{num}"),
    INFO_QUERY_TOOL_ARG_PLACEHOLDER_NUM_INTERVALS("{num}"),
    INFO_QUERY_TOOL_ARG_PLACEHOLDER_NUM_THREADS("{num}"),
    INFO_QUERY_TOOL_ARG_PLACEHOLDER_PORT("{port}"),
    INFO_QUERY_TOOL_ARG_PLACEHOLDER_RANDOM_SEED("{value}"),
    INFO_QUERY_TOOL_ARG_PLACEHOLDER_RATE_PER_SECOND("{queries-per-second}"),
    INFO_QUERY_TOOL_ARG_PLACEHOLDER_RESOURCE_ID("{resource}"),
    INFO_QUERY_TOOL_ARG_PLACEHOLDER_RESOURCE_NAME("{resource-name}"),
    INFO_QUERY_TOOL_ARG_PLACEHOLDER_TIMESTAMP_FORMAT("{format}"),
    INFO_QUERY_TOOL_ARG_PLACEHOLDER_WARM_UP_INTERVALS("{num}"),
    INFO_QUERY_TOOL_DESC("Perform repeated resource queries against a SCIM server."),
    INFO_QUERY_TOOL_EXAMPLE_1("Test query performance by querying randomly across a set of one million users with eight concurrent threads.  The user resources returned to the client will be in XML format and will include the userName and name attributes."),
    INFO_QUERY_TOOL_EXAMPLE_2("Test resource lookup performance by querying randomly across a set of one million user resource IDs with eight concurrent threads. The user resources returned to the client will be in JSON format and will include the userName and name attributes."),
    INFO_QUERY_TOOL_WARM_UP_COMPLETED("Warm-up completed.  Beginning overall statistics collection."),
    INFO_SCIM_TOOL_DESCRIPTION_CERT_NICKNAME("The nickname (alias) of the client certificate in the key store to present to the SCIM server for SSL client authentication."),
    INFO_SCIM_TOOL_DESCRIPTION_KEY_STORE_FORMAT("The format (e.g., jks, jceks, pkcs12, etc.) for the key store file."),
    INFO_SCIM_TOOL_DESCRIPTION_KEY_STORE_PASSWORD("The password to use to access the key store contents."),
    INFO_SCIM_TOOL_DESCRIPTION_KEY_STORE_PASSWORD_FILE("The path to the file containing the password to use to access the key store contents."),
    INFO_SCIM_TOOL_DESCRIPTION_KEY_STORE_PATH("The path to the file to use as the key store for obtaining client certificates when communicating securely with the SCIM server."),
    INFO_SCIM_TOOL_DESCRIPTION_TRUST_ALL("Trust any certificate presented by the SCIM server."),
    INFO_SCIM_TOOL_DESCRIPTION_TRUST_STORE_FORMAT("The format (e.g., jks, jceks, pkcs12, etc.) for the trust store file."),
    INFO_SCIM_TOOL_DESCRIPTION_TRUST_STORE_PASSWORD("The password to use to access the trust store contents."),
    INFO_SCIM_TOOL_DESCRIPTION_TRUST_STORE_PASSWORD_FILE("The path to the file containing the password to use to access the trust store contents."),
    INFO_SCIM_TOOL_DESCRIPTION_TRUST_STORE_PATH("The path to the file to use as trust store when determining whether to trust a certificate presented by the SCIM server."),
    INFO_SCIM_TOOL_DESCRIPTION_USE_SSL("Use SSL when communicating with the SCIM server."),
    INFO_SCIM_TOOL_PLACEHOLDER_CERT_NICKNAME("{nickname}"),
    INFO_SCIM_TOOL_PLACEHOLDER_FORMAT("{format}"),
    INFO_SCIM_TOOL_PLACEHOLDER_PASSWORD("{password}"),
    INFO_SCIM_TOOL_PLACEHOLDER_PATH("{path}");

    private static final ResourceBundle RESOURCE_BUNDLE;
    private static final ConcurrentHashMap<ToolMessages, String> MESSAGE_STRINGS;
    private static final ConcurrentHashMap<ToolMessages, MessageFormat> MESSAGES;
    private final String defaultText;

    private ToolMessages(String defaultText) {
        this.defaultText = defaultText;
    }

    public String get() {
        String s = MESSAGE_STRINGS.get((Object)this);
        if (s == null) {
            if (RESOURCE_BUNDLE == null) {
                return this.defaultText;
            }
            s = RESOURCE_BUNDLE.getString(this.name());
            MESSAGE_STRINGS.putIfAbsent(this, s);
        }
        return s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String get(Object ... args) {
        MessageFormat f = MESSAGES.get((Object)this);
        if (f == null) {
            f = RESOURCE_BUNDLE == null ? new MessageFormat(this.defaultText) : new MessageFormat(RESOURCE_BUNDLE.getString(this.name()));
            MESSAGES.putIfAbsent(this, f);
        }
        MessageFormat messageFormat = f;
        synchronized (messageFormat) {
            return f.format(args);
        }
    }

    public String toString() {
        return this.get();
    }

    static {
        ResourceBundle rb = null;
        try {
            rb = ResourceBundle.getBundle("scim.sdk");
        }
        catch (Exception exception) {
            // empty catch block
        }
        RESOURCE_BUNDLE = rb;
        MESSAGE_STRINGS = new ConcurrentHashMap();
        MESSAGES = new ConcurrentHashMap();
    }
}

