/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.scim.wink;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceStats {
    public static final String QUERY_OK = "query-successful";
    public static final String QUERY_BAD_REQUEST = "query-400";
    public static final String QUERY_UNAUTHORIZED = "query-401";
    public static final String QUERY_FORBIDDEN = "query-403";
    public static final String QUERY_NOT_FOUND = "query-404";
    public static final String QUERY_INTERNAL_SERVER_ERROR = "query-500";
    public static final String QUERY_NOT_IMPLEMENTED = "query-505";
    public static final String QUERY_RESPONSE_XML = "query-response-xml";
    public static final String QUERY_RESPONSE_JSON = "query-response-json";
    public static final String GET_OK = "get-successful";
    public static final String GET_NOT_MODIFIED = "get-304";
    public static final String GET_BAD_REQUEST = "get-400";
    public static final String GET_UNAUTHORIZED = "get-401";
    public static final String GET_FORBIDDEN = "get-403";
    public static final String GET_NOT_FOUND = "get-404";
    public static final String GET_INTERNAL_SERVER_ERROR = "get-500";
    public static final String GET_NOT_IMPLEMENTED = "get-505";
    public static final String GET_RESPONSE_XML = "get-response-xml";
    public static final String GET_RESPONSE_JSON = "get-response-json";
    public static final String PUT_OK = "put-successful";
    public static final String PUT_BAD_REQUEST = "put-400";
    public static final String PUT_UNAUTHORIZED = "put-401";
    public static final String PUT_FORBIDDEN = "put-403";
    public static final String PUT_NOT_FOUND = "put-404";
    public static final String PUT_CONFLICT = "put-409";
    public static final String PUT_PRECONDITION_FAILED = "put-412";
    public static final String PUT_INTERNAL_SERVER_ERROR = "put-500";
    public static final String PUT_NOT_IMPLEMENTED = "put-505";
    public static final String PUT_RESPONSE_XML = "put-response-xml";
    public static final String PUT_RESPONSE_JSON = "put-response-json";
    public static final String PUT_CONTENT_XML = "put-content-xml";
    public static final String PUT_CONTENT_JSON = "put-content-json";
    public static final String POST_OK = "post-successful";
    public static final String POST_BAD_REQUEST = "post-400";
    public static final String POST_UNAUTHORIZED = "post-401";
    public static final String POST_FORBIDDEN = "post-403";
    public static final String POST_CONFLICT = "post-409";
    public static final String POST_REQUEST_ENTITY_TOO_LARGE = "post-413";
    public static final String POST_INTERNAL_SERVER_ERROR = "post-500";
    public static final String POST_NOT_IMPLEMENTED = "post-505";
    public static final String POST_RESPONSE_XML = "post-response-xml";
    public static final String POST_RESPONSE_JSON = "post-response-json";
    public static final String POST_CONTENT_XML = "post-content-xml";
    public static final String POST_CONTENT_JSON = "post-content-json";
    public static final String PATCH_OK = "patch-successful";
    public static final String PATCH_BAD_REQUEST = "patch-400";
    public static final String PATCH_UNAUTHORIZED = "patch-401";
    public static final String PATCH_FORBIDDEN = "patch-403";
    public static final String PATCH_NOT_FOUND = "patch-404";
    public static final String PATCH_CONFLICT = "patch-409";
    public static final String PATCH_PRECONDITION_FAILED = "patch-412";
    public static final String PATCH_INTERNAL_SERVER_ERROR = "patch-500";
    public static final String PATCH_NOT_IMPLEMENTED = "patch-505";
    public static final String PATCH_RESPONSE_XML = "patch-response-xml";
    public static final String PATCH_RESPONSE_JSON = "patch-response-json";
    public static final String PATCH_CONTENT_XML = "patch-content-xml";
    public static final String PATCH_CONTENT_JSON = "patch-content-json";
    public static final String DELETE_OK = "delete-successful";
    public static final String DELETE_BAD_REQUEST = "delete-400";
    public static final String DELETE_UNAUTHORIZED = "delete-401";
    public static final String DELETE_FORBIDDEN = "delete-403";
    public static final String DELETE_NOT_FOUND = "delete-404";
    public static final String DELETE_CONFLICT = "delete-409";
    public static final String DELETE_PRECONDITION_FAILED = "delete-412";
    public static final String DELETE_INTERNAL_SERVER_ERROR = "delete-500";
    public static final String DELETE_NOT_IMPLEMENTED = "delete-505";
    private final String name;
    private final ConcurrentHashMap<String, AtomicLong> stats = new ConcurrentHashMap();

    public ResourceStats(String name) {
        this.name = name;
    }

    void incrementStat(String stat) {
        AtomicLong prev;
        AtomicLong num = this.stats.get(stat);
        if (num == null && (prev = this.stats.putIfAbsent(stat, num = new AtomicLong())) != null) {
            num = prev;
        }
        num.getAndIncrement();
    }

    public long getStat(String stat) {
        AtomicLong i = this.stats.get(stat);
        if (i != null) {
            return i.get();
        }
        return 0L;
    }

    public Map<String, Long> getStats() {
        HashMap<String, Long> map = new HashMap<String, Long>(this.stats.size());
        for (Map.Entry<String, AtomicLong> entry : this.stats.entrySet()) {
            map.put(entry.getKey(), entry.getValue().get());
        }
        return map;
    }

    public String getName() {
        return this.name;
    }
}

