/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.scim.marshal;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.atomic.AtomicLong;

public class BulkInputStreamWrapper
extends FilterInputStream {
    private final AtomicLong bytesRead = new AtomicLong(0L);

    public BulkInputStreamWrapper(InputStream s) {
        super(s);
    }

    public int read() throws IOException {
        int c = this.in.read();
        if (c != -1) {
            this.bytesRead.incrementAndGet();
        }
        return c;
    }

    public int read(byte[] b) throws IOException {
        int n = this.in.read(b);
        if (n != -1) {
            this.bytesRead.addAndGet(n);
        }
        return n;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        int n = this.in.read(b, off, len);
        if (n != -1) {
            this.bytesRead.addAndGet(n);
        }
        return n;
    }

    public long skip(long n) throws IOException {
        long skipped = this.in.skip(n);
        this.bytesRead.addAndGet(skipped);
        return n;
    }

    public long getBytesRead() {
        return this.bytesRead.get();
    }
}

