/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.scim.sdk;

import com.unboundid.scim.data.AttributeValueResolver;
import com.unboundid.scim.schema.AttributeDescriptor;
import com.unboundid.scim.sdk.ComplexSCIMAttributeValue;
import com.unboundid.scim.sdk.SCIMAttribute;
import com.unboundid.scim.sdk.SimpleSCIMAttributeValue;
import com.unboundid.scim.sdk.SimpleValue;
import com.unboundid.scim.sdk.StaticUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.xml.bind.DatatypeConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SCIMAttributeValue {
    public static SCIMAttributeValue createValue(AttributeDescriptor.DataType dataType, String value) {
        switch (dataType) {
            case BINARY: {
                return SCIMAttributeValue.createBinaryValue(DatatypeConverter.parseBase64Binary((String)value));
            }
        }
        return SCIMAttributeValue.createStringValue(value);
    }

    public static SCIMAttributeValue createStringValue(String value) {
        return new SimpleSCIMAttributeValue(new SimpleValue(value));
    }

    public static SCIMAttributeValue createBooleanValue(Boolean value) {
        return new SimpleSCIMAttributeValue(new SimpleValue(value));
    }

    public static SCIMAttributeValue createDateValue(Date value) {
        return new SimpleSCIMAttributeValue(new SimpleValue(value));
    }

    public static SCIMAttributeValue createBinaryValue(byte[] value) {
        return new SimpleSCIMAttributeValue(new SimpleValue(value));
    }

    public static SCIMAttributeValue createSimpleValue(SimpleValue simpleValue) {
        return new SimpleSCIMAttributeValue(simpleValue);
    }

    public <T> T getSubAttributeValue(String name, AttributeValueResolver<T> resolver) {
        SCIMAttributeValue v;
        SCIMAttribute attribute = this.getAttribute(name);
        if (attribute != null && (v = attribute.getValue()) != null) {
            return resolver.toInstance(v);
        }
        return null;
    }

    public <T> Collection<T> getSubAttributeValues(String name, AttributeValueResolver<T> resolver) {
        SCIMAttributeValue[] values;
        SCIMAttribute attribute = this.getAttribute(name);
        if (attribute != null && (values = attribute.getValues()) != null) {
            ArrayList<T> entries = new ArrayList<T>(values.length);
            for (SCIMAttributeValue v : values) {
                entries.add(resolver.toInstance(v));
            }
            return entries;
        }
        return null;
    }

    public static SCIMAttributeValue createComplexValue(SCIMAttribute ... attributes) {
        LinkedHashMap<String, SCIMAttribute> map = new LinkedHashMap<String, SCIMAttribute>();
        for (SCIMAttribute a : attributes) {
            String lowerCaseName = StaticUtils.toLowerCase(a.getName());
            if (map.containsKey(lowerCaseName)) {
                throw new RuntimeException("Duplicate attribute " + a.getName() + " in complex attribute value");
            }
            map.put(lowerCaseName, a);
        }
        return new ComplexSCIMAttributeValue(Collections.unmodifiableMap(map));
    }

    public static SCIMAttributeValue createComplexValue(Collection<SCIMAttribute> attributes) {
        LinkedHashMap<String, SCIMAttribute> map = new LinkedHashMap<String, SCIMAttribute>();
        for (SCIMAttribute a : attributes) {
            String lowerCaseName = StaticUtils.toLowerCase(a.getName());
            if (map.containsKey(lowerCaseName)) {
                throw new RuntimeException("Duplicate attribute " + a.getName() + " in complex attribute value");
            }
            map.put(lowerCaseName, a);
        }
        return new ComplexSCIMAttributeValue(Collections.unmodifiableMap(map));
    }

    public abstract boolean isComplex();

    public abstract SimpleValue getValue();

    public String getStringValue() {
        SimpleValue value = this.getValue();
        if (value == null) {
            return null;
        }
        return value.getStringValue();
    }

    public Boolean getBooleanValue() {
        SimpleValue value = this.getValue();
        if (value == null) {
            return null;
        }
        return value.getBooleanValue();
    }

    public Double getDecimalValue() {
        SimpleValue value = this.getValue();
        if (value == null) {
            return null;
        }
        return value.getDoubleValue();
    }

    public Long getIntegerValue() {
        SimpleValue value = this.getValue();
        if (value == null) {
            return null;
        }
        return value.getLongValue();
    }

    public Date getDateValue() {
        SimpleValue value = this.getValue();
        if (value == null) {
            return null;
        }
        return value.getDateValue();
    }

    public byte[] getBinaryValue() {
        SimpleValue value = this.getValue();
        if (value == null) {
            return null;
        }
        return value.getBinaryValue();
    }

    public abstract Map<String, SCIMAttribute> getAttributes();

    public SCIMAttribute getAttribute(String attributeName) {
        Map<String, SCIMAttribute> attributes = this.getAttributes();
        if (attributes != null) {
            return attributes.get(StaticUtils.toLowerCase(attributeName));
        }
        return null;
    }

    public boolean hasAttribute(String attributeName) {
        Map<String, SCIMAttribute> attributes = this.getAttributes();
        if (attributes != null) {
            return attributes.containsKey(StaticUtils.toLowerCase(attributeName));
        }
        return false;
    }
}

