/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.scim.wink;

import java.util.concurrent.Semaphore;

public final class AdjustableSemaphore
extends Semaphore {
    private static final long serialVersionUID = -2211345506986838529L;
    private int maxPermits;

    public AdjustableSemaphore(int maxPermits) {
        super(maxPermits);
        this.maxPermits = maxPermits;
    }

    public int getMaxPermits() {
        return this.maxPermits;
    }

    public int availablePermits() {
        int availablePermits = super.availablePermits();
        return availablePermits >= 0 ? availablePermits : 0;
    }

    public synchronized void setMaxPermits(int maxPermits) {
        if (maxPermits < 1) {
            throw new IllegalArgumentException();
        }
        int delta = maxPermits - this.maxPermits;
        if (delta == 0) {
            return;
        }
        if (delta > 0) {
            this.release(delta);
        } else {
            this.reducePermits(-delta);
        }
        this.maxPermits = maxPermits;
    }
}

