/*
 * Decompiled with CFR 0.152.
 */
package com.unfbx.chatgpt.interceptor;

import cn.hutool.json.JSONUtil;
import com.unfbx.chatgpt.entity.common.OpenAiResponse;
import com.unfbx.chatgpt.exception.BaseException;
import com.unfbx.chatgpt.exception.CommonError;
import com.unfbx.chatgpt.interceptor.OpenAiAuthInterceptor;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DynamicKeyOpenAiAuthInterceptor
extends OpenAiAuthInterceptor {
    private static final Logger log = LoggerFactory.getLogger(DynamicKeyOpenAiAuthInterceptor.class);
    private static final String ACCOUNT_DEACTIVATED = "account_deactivated";
    private static final String INVALID_API_KEY = "invalid_api_key";

    public DynamicKeyOpenAiAuthInterceptor() {
        this.setWarringConfig(null);
    }

    public DynamicKeyOpenAiAuthInterceptor(Map warringConfig) {
        this.setWarringConfig(warringConfig);
    }

    public Response intercept(Interceptor.Chain chain) throws IOException {
        Request original;
        String key = this.getKey();
        Request request = this.auth(key, original = chain.request());
        Response response = chain.proceed(request);
        if (!response.isSuccessful() && response.body() != null) {
            String errorMsg = response.body().string();
            if (response.code() == CommonError.OPENAI_AUTHENTICATION_ERROR.code() || response.code() == CommonError.OPENAI_LIMIT_ERROR.code() || response.code() == CommonError.OPENAI_SERVER_ERROR.code()) {
                OpenAiResponse openAiResponse = (OpenAiResponse)JSONUtil.toBean((String)errorMsg, OpenAiResponse.class);
                String errorCode = openAiResponse.getError().getCode();
                log.error("--------> \u8bf7\u6c42openai\u5f02\u5e38\uff0c\u9519\u8befcode\uff1a{}", (Object)errorCode);
                log.error("--------> \u8bf7\u6c42\u5f02\u5e38\uff1a{}", (Object)errorMsg);
                if (ACCOUNT_DEACTIVATED.equals(errorCode) || INVALID_API_KEY.equals(errorCode)) {
                    super.setApiKey(this.onErrorDealApiKeys(key));
                }
                throw new BaseException(openAiResponse.getError().getMessage());
            }
            log.error("--------> \u8bf7\u6c42\u5f02\u5e38\uff1a{}", (Object)errorMsg);
            OpenAiResponse openAiResponse = (OpenAiResponse)JSONUtil.toBean((String)errorMsg, OpenAiResponse.class);
            if (Objects.nonNull(openAiResponse.getError())) {
                log.error(openAiResponse.getError().getMessage());
                throw new BaseException(openAiResponse.getError().getMessage());
            }
            throw new BaseException(CommonError.RETRY_ERROR);
        }
        return response;
    }

    @Override
    protected List<String> onErrorDealApiKeys(String errorKey) {
        List<String> apiKey = super.getApiKey().stream().filter(e -> !errorKey.equals(e)).collect(Collectors.toList());
        log.error("--------> \u5f53\u524dApiKey\uff1a[{}] \u5931\u6548\u4e86\uff0c\u79fb\u9664\uff01", (Object)errorKey);
        return apiKey;
    }

    @Override
    protected void noHaveActiveKeyWarring() {
        log.error("--------> [\u544a\u8b66] \u6ca1\u6709\u53ef\u7528\u7684key\uff01\uff01\uff01");
    }

    @Override
    public Request auth(String key, Request original) {
        return super.auth(key, original);
    }
}

