/*
 * Decompiled with CFR 0.152.
 */
package com.universalmediaserver.crowdin;

import com.universalmediaserver.crowdin.tool.GitUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.NTCredentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.mime.MultipartEntity;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.entity.mime.content.StringBody;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.manager.WagonManager;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.wagon.authentication.AuthenticationInfo;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;

public abstract class AbstractCrowdinMojo
extends AbstractMojo {
    private static final String HTTP_AUTH_NTLM_DOMAIN = "http.auth.ntlm.domain";
    private static final String HTTP_PROXY_PASSWORD = "http.proxyPassword";
    private static final String HTTP_PROXY_USER = "http.proxyUser";
    private static final String HTTP_PROXY_PORT = "http.proxyPort";
    private static final String HTTP_PROXY_HOST = "http.proxyHost";
    protected static final SAXBuilder saxBuilder = new SAXBuilder();
    protected MavenProject project;
    protected File languageFilesFolder;
    protected File downloadFolder;
    protected File statusFile;
    protected String rootBranch;
    protected WagonManager wagonManager;
    protected String crowdinServerId;
    protected DefaultHttpClient client;
    protected AuthenticationInfo authenticationInfo;

    protected void setProject(MavenProject value) {
        this.project = value;
    }

    protected void setLanguageFilesFolder(File value) {
        this.languageFilesFolder = value;
    }

    protected void setDownloadFolder(File value) {
        this.downloadFolder = value;
    }

    protected void setStatusFile(File value) {
        this.statusFile = value;
    }

    protected void setRootBranch(String value) {
        this.rootBranch = value;
    }

    protected void setWagonManager(WagonManager value) {
        this.wagonManager = value;
    }

    protected void setCrowdinServerId(String value) {
        this.crowdinServerId = value;
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.authenticationInfo = this.wagonManager.getAuthenticationInfo(this.crowdinServerId);
        if (this.authenticationInfo == null || this.authenticationInfo.getUserName() == null || this.authenticationInfo.getPassword() == null) {
            throw new MojoExecutionException("Failed to find server with id " + this.crowdinServerId + " in Maven settings (~/.m2/settings.xml)");
        }
        this.client = new DefaultHttpClient();
        if (System.getProperty(HTTP_PROXY_HOST) != null) {
            String host = System.getProperty(HTTP_PROXY_HOST);
            String port = System.getProperty(HTTP_PROXY_PORT);
            if (port == null) {
                throw new MojoExecutionException("http.proxyHost without http.proxyPort");
            }
            HttpHost proxy = new HttpHost(host, Integer.parseInt(port));
            this.client.getParams().setParameter("http.route.default-proxy", (Object)proxy);
            UsernamePasswordCredentials credential = null;
            String user = System.getProperty(HTTP_PROXY_USER);
            String password = System.getProperty(HTTP_PROXY_PASSWORD);
            if (System.getProperty(HTTP_AUTH_NTLM_DOMAIN) != null) {
                String domain = System.getProperty(HTTP_AUTH_NTLM_DOMAIN);
                if (user == null || password == null) {
                    throw new MojoExecutionException("http.auth.ntlm.domain without http.proxyUser and http.proxyPassword");
                }
                credential = new NTCredentials(user, password, host, domain);
            } else if (user != null || password != null) {
                if (user == null || password == null) {
                    throw new MojoExecutionException("http.proxyUser and http.proxyPassword go together");
                }
                credential = new UsernamePasswordCredentials(user, password);
            }
            if (credential != null) {
                AuthScope authScope = new AuthScope(null, -1);
                this.client.getCredentialsProvider().setCredentials(authScope, (Credentials)credential);
            }
        }
    }

    protected boolean crowdinContainsFile(Element files, String fileName, boolean folder, boolean branch) throws MojoExecutionException {
        if (folder && branch) {
            throw new MojoExecutionException("fileitem can't be both folder and branch!");
        }
        this.getLog().debug((CharSequence)("Check that crowdin project contains " + fileName));
        List items = files.getChildren("item");
        int slash = fileName.indexOf(47);
        if (slash == -1) {
            if (folder) {
                Element folderElement = this.crowdinGetFolder(items, fileName);
                if (folderElement != null) {
                    this.getLog().debug((CharSequence)("Crowdin project contains folder " + fileName));
                    return true;
                }
            } else if (branch) {
                Element branchElement = this.crowdinGetBranch(items, fileName);
                if (branchElement != null) {
                    this.getLog().debug((CharSequence)("Crowdin project contains branch " + fileName));
                    return true;
                }
            } else {
                for (Element item : items) {
                    if (!fileName.equals(item.getChildTextNormalize("name"))) continue;
                    this.getLog().debug((CharSequence)("Crowdin project contains file " + fileName));
                    return true;
                }
            }
        } else {
            String folderName = fileName.substring(0, slash);
            String subPath = fileName.substring(slash + 1);
            Element folderElement = this.crowdinGetFolder(items, folderName);
            if (folderElement != null) {
                Element subFiles = folderElement.getChild("files");
                return this.crowdinContainsFile(subFiles, subPath, folder, branch);
            }
        }
        this.getLog().debug((CharSequence)("Crowdin project doesn't contain " + (folder ? "folder " : (branch ? "branch " : "file ")) + fileName));
        return false;
    }

    protected boolean crowdinContainsFile(Element files, String fileName) throws MojoExecutionException {
        return this.crowdinContainsFile(files, fileName, false, false);
    }

    protected boolean crowdinContainsFolder(Element files, String fileName) throws MojoExecutionException {
        return this.crowdinContainsFile(files, fileName, true, false);
    }

    protected boolean crowdinContainsBranch(Element files, String fileName) throws MojoExecutionException {
        return this.crowdinContainsFile(files, fileName, false, true);
    }

    protected Element crowdinGetFolder(List<Element> items, String fileName) {
        return this.crowdinGetFolder(items, fileName, false);
    }

    protected Element crowdinGetBranch(List<Element> items, String fileName) {
        return this.crowdinGetFolder(items, fileName, true);
    }

    protected Element crowdinGetFolder(List<Element> items, String fileName, boolean branch) {
        for (Element item : items) {
            if (!fileName.equals(item.getChildTextNormalize("name"))) continue;
            if (branch && this.crowdinIsBranch(item)) {
                return item;
            }
            if (branch || !this.crowdinIsFolder(item)) continue;
            return item;
        }
        return null;
    }

    protected boolean crowdinIsFolder(Element item) {
        return item.getChild("node_type") != null && item.getChildTextNormalize("node_type").equalsIgnoreCase("directory");
    }

    protected boolean crowdinIsBranch(Element item) {
        return item.getChild("node_type") != null && item.getChildTextNormalize("node_type").equalsIgnoreCase("branch");
    }

    protected void crowdinCreateFolder(String folderName) throws MojoExecutionException {
        this.getLog().info((CharSequence)("Creating " + folderName + " folder on crowdin"));
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("name", folderName);
        this.crowdinRequestAPI("add-directory", parameters, null, true);
    }

    protected void crowdinCreateBranch(String branchName) throws MojoExecutionException {
        this.getLog().info((CharSequence)("Creating " + branchName + " branch on crowdin"));
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("name", branchName);
        parameters.put("is_branch", "1");
        this.crowdinRequestAPI("add-directory", parameters, null, true);
    }

    protected Document crowdinRequestAPI(String method, Map<String, String> parameters, Map<String, File> files, boolean mustSucceed) throws MojoExecutionException {
        return this.crowdinRequestAPI(method, parameters, files, null, null, mustSucceed);
    }

    protected Document crowdinRequestAPI(String method, Map<String, String> parameters, Map<String, File> files, Map<String, String> titles, Map<String, String> patterns, boolean mustSucceed) throws MojoExecutionException {
        try {
            String uri = "http://api.crowdin.net/api/project/" + this.authenticationInfo.getUserName() + "/" + method + "?key=";
            this.getLog().debug((CharSequence)("Calling " + uri + "<API Key>"));
            uri = uri + this.authenticationInfo.getPassword();
            HttpPost postMethod = new HttpPost(uri);
            MultipartEntity reqEntity = new MultipartEntity();
            if (parameters != null) {
                Set<Map.Entry<String, String>> entrySetParameters = parameters.entrySet();
                for (Map.Entry<String, Object> entry : entrySetParameters) {
                    reqEntity.addPart(entry.getKey(), (ContentBody)new StringBody((String)entry.getValue()));
                }
            }
            if (files != null) {
                Set<Map.Entry<String, File>> entrySetFiles = files.entrySet();
                for (Map.Entry<String, Object> entry : entrySetFiles) {
                    String key = "files[" + entry.getKey() + "]";
                    reqEntity.addPart(key, (ContentBody)new FileBody((File)entry.getValue()));
                }
            }
            if (titles != null) {
                Set<Map.Entry<String, String>> entrySetTitles = titles.entrySet();
                for (Map.Entry<String, Object> entry : entrySetTitles) {
                    reqEntity.addPart("titles[" + entry.getKey() + "]", (ContentBody)new StringBody((String)entry.getValue()));
                }
            }
            if (patterns != null) {
                Set<Map.Entry<String, String>> entrySetPatterns = patterns.entrySet();
                for (Map.Entry<String, Object> entry : entrySetPatterns) {
                    reqEntity.addPart("export_patterns[" + entry.getKey() + "]", (ContentBody)new StringBody((String)entry.getValue()));
                }
            }
            postMethod.setEntity((HttpEntity)reqEntity);
            HttpResponse response = this.client.execute((HttpUriRequest)postMethod);
            int returnCode = response.getStatusLine().getStatusCode();
            this.getLog().debug((CharSequence)("Return code : " + returnCode));
            InputStream inputStream = response.getEntity().getContent();
            Document document = saxBuilder.build(inputStream);
            if (mustSucceed && document.getRootElement().getName().equals("error")) {
                String code = document.getRootElement().getChildTextNormalize("code");
                String message = document.getRootElement().getChildTextNormalize("message");
                throw new MojoExecutionException("Failed to call API - " + code + " - " + message);
            }
            return document;
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to call API", (Exception)e);
        }
        catch (JDOMException e) {
            throw new MojoExecutionException("Failed to call API", (Exception)((Object)e));
        }
    }

    protected Element getCrowdinFiles(String branch, Document projectDetails) throws MojoExecutionException {
        if (projectDetails == null) {
            this.getLog().info((CharSequence)"Retrieving crowdin project information");
            projectDetails = this.crowdinRequestAPI("info", null, null, true);
        }
        if (branch != null) {
            Element branchElement = this.crowdinGetBranch(projectDetails.getRootElement().getChild("files").getChildren(), branch);
            if (branchElement == null || !this.crowdinIsBranch(branchElement)) {
                throw new MojoExecutionException("Can't find branch \"" + branch + "\" in crowdin project information");
            }
            return branchElement.getChild("files");
        }
        return projectDetails.getRootElement().getChild("files");
    }

    protected String getMavenId(Artifact artifact) {
        return artifact.getGroupId() + "." + artifact.getArtifactId();
    }

    protected String getBranch() throws MojoExecutionException {
        return this.getBranch(false, null);
    }

    protected String getBranch(boolean create, Document projectDetails) throws MojoExecutionException {
        this.getLog().info((CharSequence)"Determining git branch");
        String branch = GitUtil.getBranch(this.project.getBasedir(), this.getLog());
        if (branch == null || branch.trim().equals("")) {
            throw new MojoExecutionException("Could not determine current git branch");
        }
        if (branch.equals(this.rootBranch)) {
            return null;
        }
        if (this.crowdinContainsBranch(this.getCrowdinFiles(null, projectDetails), branch)) {
            return branch;
        }
        if (create) {
            this.crowdinCreateBranch(branch);
            return branch;
        }
        throw new MojoExecutionException("Crowdin project doesn't contain branch \"" + branch + "\". Please push this branch first.");
    }
}

