/*
 * Decompiled with CFR 0.152.
 */
package com.universalmediaserver.crowdin;

import com.universalmediaserver.crowdin.AbstractCrowdinMojo;
import java.io.InputStream;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.jdom.Document;

public class BuildCrowdinMojo
extends AbstractCrowdinMojo {
    @Override
    public void execute() throws MojoExecutionException, MojoFailureException {
        Document document;
        super.execute();
        String branch = this.getBranch();
        this.getLog().info((CharSequence)"Asking crowdin to build translations");
        String uri = "http://api.crowdin.net/api/project/" + this.authenticationInfo.getUserName() + "/export?" + (branch != null ? "branch=" + branch + "&" : "") + "key=";
        this.getLog().debug((CharSequence)("Calling " + uri + "<API Key>"));
        uri = uri + this.authenticationInfo.getPassword();
        HttpGet getMethod = new HttpGet(uri);
        HttpResponse response = null;
        try {
            response = this.client.execute((HttpUriRequest)getMethod);
        }
        catch (Exception e) {
            throw new MojoExecutionException("Failed to call API", e);
        }
        try {
            InputStream responseBodyAsStream = response.getEntity().getContent();
            document = saxBuilder.build(responseBodyAsStream);
        }
        catch (Exception e) {
            throw new MojoExecutionException("Failed to call API", e);
        }
        if (!document.getRootElement().getName().equals("success")) {
            String code = document.getRootElement().getChildTextNormalize("code");
            String message = document.getRootElement().getChildTextNormalize("message");
            throw new MojoExecutionException("Failed to call API - " + code + " - " + message);
        }
        String status = document.getRootElement().getAttributeValue("status");
        if (status.equals("skipped")) {
            this.getLog().warn((CharSequence)"crowdin build skipped either because the files are up to date or because the last build was less than 30 minutes ago");
        } else if (status.equals("built")) {
            this.getLog().info((CharSequence)"crowdin translations successfully built");
        } else {
            this.getLog().warn((CharSequence)("crowdin replied to build request with unexpected status: " + status));
        }
        int returnCode = response.getStatusLine().getStatusCode();
        this.getLog().debug((CharSequence)("Return code : " + returnCode));
        if (returnCode != 200) {
            throw new MojoExecutionException("Failed to build translations at crowdin with return code " + returnCode);
        }
    }
}

