/*
 * Decompiled with CFR 0.152.
 */
package com.univocity.parsers.common;

import com.univocity.parsers.common.CommonParserSettings;
import com.univocity.parsers.common.CommonSettings;
import com.univocity.parsers.common.DefaultParsingContext;
import com.univocity.parsers.common.Format;
import com.univocity.parsers.common.ParserOutput;
import com.univocity.parsers.common.ParsingContext;
import com.univocity.parsers.common.TextParsingException;
import com.univocity.parsers.common.input.CharInputReader;
import com.univocity.parsers.common.processor.RowProcessor;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractParser<T extends CommonParserSettings<?>> {
    private final DefaultParsingContext context;
    private final RowProcessor processor;
    private final int recordsToRead;
    private final char comment;
    protected final CharInputReader input;
    protected final ParserOutput output;
    protected char ch;

    public AbstractParser(T settings) {
        this.input = ((CommonParserSettings)settings).newCharInputReader();
        this.output = new ParserOutput((CommonParserSettings<?>)settings);
        this.processor = ((CommonParserSettings)settings).getRowProcessor();
        this.context = new DefaultParsingContext(this.input, this.output);
        this.recordsToRead = ((CommonParserSettings)settings).getNumberOfRecordsToRead();
        this.comment = ((Format)((CommonSettings)settings).getFormat()).getComment();
    }

    protected abstract void parseRecord();

    public final void parse(Reader reader) {
        this.beginParsing(reader);
        try {
            while (!this.context.stopped && (this.ch = this.input.nextChar()) != '\u0000') {
                if (this.ch == this.comment) {
                    this.input.skipLines(1);
                    continue;
                }
                this.output.clear();
                this.parseRecord();
                String[] row = this.output.rowParsed();
                if (row == null) continue;
                this.processor.rowProcessed(row, this.context);
                if (this.recordsToRead <= 0 || this.context.currentRecord() < this.recordsToRead) continue;
                this.context.stop();
            }
        }
        catch (Exception ex) {
            throw new TextParsingException((ParsingContext)this.context, (Throwable)ex);
        }
        finally {
            this.stopParsing();
        }
    }

    public final void beginParsing(Reader reader) {
        this.context.stopped = false;
        this.input.start(reader);
        this.processor.processStarted(this.context);
    }

    public final String[] parseNext() {
        try {
            while (!this.context.stopped && (this.ch = this.input.nextChar()) != '\u0000') {
                if (this.ch == this.comment) {
                    this.input.skipLines(1);
                    continue;
                }
                this.output.clear();
                this.parseRecord();
                String[] row = this.output.rowParsed();
                if (row == null) continue;
                if (this.recordsToRead > 0 && this.context.currentRecord() >= this.recordsToRead) {
                    this.context.stop();
                }
                return row;
            }
            this.stopParsing();
            return null;
        }
        catch (Exception ex) {
            try {
                throw new TextParsingException((ParsingContext)this.context, (Throwable)ex);
            }
            catch (Throwable throwable) {
                this.stopParsing();
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void stopParsing() {
        try {
            this.context.stop();
        }
        finally {
            try {
                this.processor.processEnded(this.context);
            }
            finally {
                this.input.stop();
            }
        }
    }

    public final List<String[]> parseAll(Reader reader) {
        ArrayList<String[]> out = new ArrayList<String[]>(10000);
        this.beginParsing(reader);
        String[] row = null;
        while ((row = this.parseNext()) != null) {
            out.add(row);
        }
        return out;
    }
}

