/*
 * Decompiled with CFR 0.152.
 */
package com.univocity.parsers.common;

import com.univocity.parsers.common.CommonSettings;
import com.univocity.parsers.common.CommonWriterSettings;
import com.univocity.parsers.common.Format;
import com.univocity.parsers.common.TextWritingException;
import com.univocity.parsers.common.fields.FieldSelector;
import com.univocity.parsers.common.input.CharAppender;
import com.univocity.parsers.common.input.WriterCharAppender;
import com.univocity.parsers.common.processor.RowWriterProcessor;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Arrays;
import java.util.Collection;

public abstract class AbstractWriter<S extends CommonWriterSettings<?>> {
    private final RowWriterProcessor writerProcessor;
    private final BufferedWriter writer;
    private final boolean skipEmptyLines;
    private final char comment;
    private final StringBuilder freeText = new StringBuilder();
    private final WriterCharAppender rowAppender;
    private final Object[] outputRow;
    private final int[] indexesToWrite;
    private final char[] lineSeparator;
    private String[] headers;
    private int recordCount = 0;
    protected final String nullValue;
    protected final String emptyValue;
    protected final CharAppender appender;

    public AbstractWriter(Writer writer, S settings) {
        this.nullValue = ((CommonSettings)settings).getNullValue();
        this.emptyValue = ((CommonWriterSettings)settings).getEmptyValue();
        this.lineSeparator = ((Format)((CommonSettings)settings).getFormat()).getLineSeparator();
        this.comment = ((Format)((CommonSettings)settings).getFormat()).getComment();
        this.skipEmptyLines = ((CommonSettings)settings).getSkipEmptyLines();
        this.writerProcessor = ((CommonWriterSettings)settings).getRowWriterProcessor();
        this.appender = new WriterCharAppender(((CommonSettings)settings).getMaxCharsPerColumn(), "", (Format)((CommonSettings)settings).getFormat());
        this.rowAppender = new WriterCharAppender(((CommonSettings)settings).getMaxCharsPerColumn() * ((CommonSettings)settings).getMaxColumns(), "", (Format)((CommonSettings)settings).getFormat());
        this.writer = writer instanceof BufferedWriter ? (BufferedWriter)writer : new BufferedWriter(writer);
        this.headers = ((CommonSettings)settings).getHeaders();
        FieldSelector selector = ((CommonSettings)settings).getFieldSelector();
        if (this.headers != null && this.headers.length > 0 && selector != null) {
            this.outputRow = new Object[this.headers.length];
            this.indexesToWrite = selector.getFieldIndexes(this.headers);
        } else {
            this.outputRow = null;
            this.indexesToWrite = null;
        }
    }

    protected abstract void processRow(Object[] var1);

    protected final void appendValueToRow() {
        this.rowAppender.append((WriterCharAppender)this.appender);
    }

    protected final void appendToRow(char ch) {
        this.rowAppender.append(ch);
    }

    public final void writeHeaders() {
        this.writeHeaders(this.headers);
    }

    public final void writeHeaders(Collection<String> headers) {
        if (headers == null || headers.size() <= 0) {
            throw new TextWritingException("No headers defined", this.recordCount, (Object[])null);
        }
        this.writeHeaders(headers.toArray(new String[headers.size()]));
    }

    public final void writeHeaders(String ... headers) {
        if (this.recordCount > 0) {
            throw new TextWritingException("Cannot write headers after records have been written", this.recordCount, headers);
        }
        if (headers == null || headers.length <= 0) {
            throw new TextWritingException("No headers defined", this.recordCount, headers);
        }
        this.processRow(headers);
        this.writeRow();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void processRecordsAndClose(Iterable<?> allRecords) {
        try {
            this.processRecords(allRecords);
        }
        finally {
            this.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void processRecordsAndClose(Object[] allRecords) {
        try {
            this.processRecords(allRecords);
        }
        finally {
            this.close();
        }
    }

    public final void processRecords(Iterable<?> records) {
        for (Object record : records) {
            this.processRecord(record);
        }
    }

    public final void processRecords(Object[] records) {
        for (Object record : records) {
            this.processRecord(record);
        }
    }

    public final void processRecord(Object ... record) {
        this.processRecord((Object)record);
    }

    public final void processRecord(Object record) {
        if (this.writerProcessor == null) {
            throw new IllegalStateException("Cannot process record '" + record + "' without a writer processor. Please define a writer processor instance in the settings or use the 'writeRow' methods.");
        }
        Object[] row = this.writerProcessor.write(record, this.headers, this.indexesToWrite);
        this.writeRow(row);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <C extends Collection<Object[]>> void writeRowsAndClose(Iterable<C> allRows) {
        try {
            this.writeRows(allRows);
        }
        finally {
            this.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void writeRowsAndClose(Collection<Object[]> allRows) {
        try {
            this.writeRows(allRows);
        }
        finally {
            this.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void writeRowsAndClose(Object[][] allRows) {
        try {
            this.writeRows(allRows);
        }
        finally {
            this.close();
        }
    }

    public final void writeRows(Object[][] rows) {
        for (Object[] row : rows) {
            this.writeRow(row);
        }
    }

    public final <C extends Collection<Object[]>> void writeRows(Iterable<C> rows) {
        for (Collection row : rows) {
            this.writeRow(new Object[]{row});
        }
    }

    public final void writeRows(Collection<Object[]> rows) {
        for (Object[] row : rows) {
            this.writeRow(row);
        }
    }

    public final void writeRow(Collection<Object> row) {
        if (row == null) {
            return;
        }
        this.writeRow(row.toArray());
    }

    public final void writeRow(Object ... row) {
        try {
            if (row == null || row.length == 0) {
                if (this.skipEmptyLines) {
                    return;
                }
                this.writeEmptyRow();
                return;
            }
            if (this.outputRow != null) {
                this.fillOutputRow(row);
                row = this.outputRow;
            }
            this.processRow(row);
            this.writeRow();
        }
        catch (Exception ex) {
            try {
                throw new TextWritingException("Error writing row", this.recordCount, row, (Throwable)ex);
            }
            catch (Throwable throwable) {
                this.close();
                throw throwable;
            }
        }
    }

    public final void writeRow(String row) {
        this.freeText.setLength(0);
        this.freeText.append(row);
        this.writeToOutput(this.freeText.toString());
    }

    public final void writeEmptyRow() {
        try {
            this.writer.write(this.lineSeparator);
        }
        catch (IOException ex) {
            this.close();
            throw new TextWritingException("Error writing row", this.recordCount, Arrays.toString(this.lineSeparator), (Throwable)ex);
        }
    }

    public final void commentRow(String comment) {
        this.writeRow(this.comment + comment);
    }

    private final <T> void fillOutputRow(T[] row) {
        if (row.length > this.indexesToWrite.length) {
            String msg = "Cannot write row as it contains more elements than the number of selected fields (" + this.indexesToWrite.length + " fields selected)";
            throw new TextWritingException(msg, this.recordCount, row);
        }
        for (int i = 0; i < this.indexesToWrite.length && i < row.length; ++i) {
            this.outputRow[this.indexesToWrite[i]] = row[i];
        }
    }

    private final void writeRow() {
        try {
            this.rowAppender.appendNewLine();
            this.rowAppender.writeCharsAndReset(this.writer);
            ++this.recordCount;
        }
        catch (Exception ex) {
            try {
                throw new TextWritingException("Error writing row", this.recordCount, this.rowAppender.getAndReset(), (Throwable)ex);
            }
            catch (Throwable throwable) {
                this.close();
                throw throwable;
            }
        }
    }

    private final void writeToOutput(String row) {
        try {
            this.writer.write(row);
            this.writer.write(this.lineSeparator);
        }
        catch (IOException ex) {
            try {
                throw new TextWritingException("Error writing row", this.recordCount, row, (Throwable)ex);
            }
            catch (Throwable throwable) {
                this.close();
                throw throwable;
            }
        }
    }

    protected final int skipLeadingWhitespace(String element) {
        for (int i = 0; i < element.length(); ++i) {
            char nextChar = element.charAt(i);
            if (nextChar <= ' ') continue;
            return i;
        }
        return 0;
    }

    public final void flush() {
        try {
            this.writer.flush();
        }
        catch (Exception ex) {
            this.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void close() {
        try {
            try {
                this.writer.flush();
            }
            finally {
                this.writer.close();
            }
        }
        catch (Exception ex) {
            throw new IllegalStateException("Error closing the output.", ex);
        }
    }

    protected String getStringValue(Object element) {
        if (element == null && (element = this.nullValue) == null) {
            return null;
        }
        String string = String.valueOf(element);
        if (string.isEmpty()) {
            return this.emptyValue;
        }
        return string;
    }
}

