/*
 * Decompiled with CFR 0.152.
 */
package com.univocity.parsers.common;

import com.univocity.parsers.common.ArgumentUtils;
import com.univocity.parsers.common.CommonParserSettings;
import com.univocity.parsers.common.fields.FieldSelector;
import com.univocity.parsers.common.input.CharAppender;
import com.univocity.parsers.common.input.NoopCharAppender;
import java.util.Arrays;

public class ParserOutput {
    private int column = 0;
    private final String[] parsedValues;
    private CharAppender[] appenders;
    private final CommonParserSettings<?> settings;
    private final boolean skipEmptyLines;
    private final String nullValue;
    public CharAppender appender;
    private boolean columnsToExtractInitialized;
    private boolean columnsReordered;
    private String[] headers;
    private int[] selectedIndexes;
    private int currentRecord;

    public ParserOutput(CommonParserSettings<?> settings) {
        this.appender = settings.newCharAppender();
        this.parsedValues = new String[settings.getMaxColumns()];
        this.appenders = new CharAppender[settings.getMaxColumns()];
        Arrays.fill(this.appenders, this.appender);
        this.settings = settings;
        this.skipEmptyLines = settings.getSkipEmptyLines();
        this.nullValue = settings.getNullValue();
        this.columnsToExtractInitialized = false;
        this.currentRecord = 0;
    }

    private void initializeHeaders() {
        this.headers = this.settings.getHeaders();
        if (this.headers != null) {
            this.headers = (String[])this.headers.clone();
            this.initializeColumnsToExtract(this.headers);
        } else if (this.column > 0) {
            this.initializeColumnsToExtract(Arrays.copyOf(this.parsedValues, this.column));
            if (this.settings.isHeaderExtractionEnabled()) {
                this.headers = new String[this.column];
                System.arraycopy(this.parsedValues, 0, this.headers, 0, this.column);
            }
        }
    }

    String[] rowParsed() {
        if (this.column > 0) {
            if (!this.columnsToExtractInitialized) {
                this.initializeHeaders();
                if (this.settings.isHeaderExtractionEnabled()) {
                    Arrays.fill(this.parsedValues, null);
                    return null;
                }
            }
            ++this.currentRecord;
            if (this.columnsReordered) {
                String[] reorderedValues = new String[this.selectedIndexes.length];
                for (int i = 0; i < this.selectedIndexes.length; ++i) {
                    int index = this.selectedIndexes[i];
                    reorderedValues[i] = index >= this.column ? this.nullValue : this.parsedValues[index];
                }
                return reorderedValues;
            }
            String[] out = new String[this.column];
            System.arraycopy(this.parsedValues, 0, out, 0, this.column);
            return out;
        }
        if (!this.skipEmptyLines) {
            if (!this.columnsToExtractInitialized) {
                this.initializeHeaders();
            }
            ++this.currentRecord;
            if (this.columnsReordered) {
                Object[] out = new String[this.selectedIndexes.length];
                Arrays.fill(out, this.nullValue);
                return out;
            }
            return ArgumentUtils.EMPTY_STRING_ARRAY;
        }
        return null;
    }

    private void initializeColumnsToExtract(String[] values) {
        this.columnsToExtractInitialized = true;
        this.columnsReordered = false;
        this.selectedIndexes = null;
        FieldSelector selector = this.settings.getFieldSelector();
        if (selector != null) {
            this.selectedIndexes = selector.getFieldIndexes(values);
            if (this.selectedIndexes != null) {
                Arrays.fill(this.appenders, NoopCharAppender.getInstance());
                for (int i = 0; i < this.selectedIndexes.length; ++i) {
                    this.appenders[this.selectedIndexes[i]] = this.appender;
                }
                this.columnsReordered = this.settings.isColumnReorderingEnabled();
            }
        }
    }

    public String[] getHeaders() {
        return this.headers;
    }

    public int[] getSelectedIndexes() {
        return this.selectedIndexes;
    }

    public boolean isColumnReorderingEnabled() {
        return this.columnsReordered;
    }

    public int getCurrentColumn() {
        return this.column;
    }

    public void emptyParsed() {
        this.parsedValues[this.column++] = this.nullValue;
        this.appender = this.appenders[this.column];
    }

    public void valueParsed() {
        this.parsedValues[this.column++] = this.appender.getAndReset();
        this.appender = this.appenders[this.column];
    }

    void clear() {
        this.column = 0;
        this.appender = this.appenders[this.column];
    }

    public int getCurrentRecord() {
        return this.currentRecord;
    }
}

