/*
 * Decompiled with CFR 0.152.
 */
package com.univocity.parsers.common.input;

import com.univocity.parsers.common.input.CharInputReader;
import java.io.Reader;

public abstract class AbstractCharInputReader
implements CharInputReader {
    private final char lineSeparator1;
    private final char lineSeparator2;
    private final char normalizedLineSeparator;
    private char current = '\u0000';
    private char next = '\u0000';
    private int lineCount;
    private int charCount;
    private int i;
    public char[] buffer;
    public int length = -1;

    public AbstractCharInputReader(char[] lineSeparator, char normalizedLineSeparator) {
        if (lineSeparator == null || lineSeparator.length == 0) {
            throw new IllegalArgumentException("Invalid line separator. Expected 1 to 2 characters");
        }
        if (lineSeparator.length > 2) {
            throw new IllegalArgumentException("Invalid line separator. Up to 2 characters are expected. Got " + lineSeparator.length + " characters.");
        }
        this.lineSeparator1 = lineSeparator[0];
        this.lineSeparator2 = lineSeparator.length == 2 ? lineSeparator[1] : (char)'\u0000';
        this.normalizedLineSeparator = normalizedLineSeparator;
    }

    protected abstract void setReader(Reader var1);

    protected abstract void reloadBuffer();

    @Override
    public void start(Reader reader) {
        this.stop();
        this.setReader(reader);
        this.lineCount = 0;
        this.updateBuffer();
        if (this.length > 0) {
            this.next = this.buffer[this.i++];
        }
    }

    private void updateBuffer() {
        this.reloadBuffer();
        this.charCount += this.i;
        this.i = 0;
        if (this.length == -1) {
            this.stop();
        }
    }

    @Override
    public char nextChar() {
        this.current = this.next;
        if (this.i >= this.length) {
            if (this.length != -1) {
                this.updateBuffer();
            } else {
                return '\u0000';
            }
        }
        this.next = this.buffer[this.i++];
        if (this.lineSeparator1 == this.current && (this.lineSeparator2 == '\u0000' || this.lineSeparator2 == this.next)) {
            ++this.lineCount;
            if (this.lineSeparator2 != '\u0000') {
                this.current = this.normalizedLineSeparator;
                if (this.i >= this.length && this.length != -1) {
                    this.updateBuffer();
                }
                if (this.i < this.length) {
                    this.next = this.buffer[this.i++];
                }
            }
        }
        return this.current;
    }

    @Override
    public int lineCount() {
        return this.lineCount;
    }

    @Override
    public void skipLines(int lines) {
        if (lines < 1) {
            return;
        }
        int expectedLineCount = this.lineCount + lines;
        char ch = '\u0000';
        do {
            ch = this.nextChar();
        } while (this.lineCount < expectedLineCount && ch != '\u0000');
        if (ch == '\u0000' && this.lineCount < lines) {
            throw new IllegalArgumentException("Unable to skip " + lines + " lines from line " + (expectedLineCount - lines) + ". End of input reached");
        }
    }

    @Override
    public int charCount() {
        return this.charCount + this.i;
    }
}

