/*
 * Decompiled with CFR 0.152.
 */
package com.univocity.parsers.csv;

import com.univocity.parsers.common.AbstractParser;
import com.univocity.parsers.csv.CsvFormat;
import com.univocity.parsers.csv.CsvParserSettings;

public class CsvParser
extends AbstractParser<CsvParserSettings> {
    private final boolean ignoreTrailingWhitespace;
    private final boolean ignoreLeadingWhitespace;
    private final char delimiter;
    private final char quote;
    private final char quoteEscape;
    private final char newLine;

    public CsvParser(CsvParserSettings settings) {
        super(settings);
        this.ignoreTrailingWhitespace = settings.getIgnoreTrailingWhitespaces();
        this.ignoreLeadingWhitespace = settings.getIgnoreLeadingWhitespaces();
        CsvFormat format = (CsvFormat)settings.getFormat();
        this.delimiter = format.getDelimiter();
        this.quote = format.getQuote();
        this.quoteEscape = format.getQuoteEscape();
        this.newLine = format.getNormalizedNewline();
    }

    @Override
    protected void parseRecord() {
        if (this.ch <= ' ' && this.ignoreLeadingWhitespace) {
            this.skipWhitespace();
        }
        while (this.ch != this.newLine && this.ch != '\u0000') {
            this.parseField();
            if (this.ch == this.newLine) continue;
            this.ch = this.input.nextChar();
            if (this.ch != this.newLine) continue;
            this.output.emptyParsed();
        }
    }

    private void parseValue() {
        if (this.ignoreTrailingWhitespace) {
            while (this.ch != this.delimiter && this.ch != this.newLine && this.ch != '\u0000') {
                this.output.appender.appendIgnoringWhitespace(this.ch);
                this.ch = this.input.nextChar();
            }
        } else {
            while (this.ch != this.delimiter && this.ch != this.newLine && this.ch != '\u0000') {
                this.output.appender.append(this.ch);
                this.ch = this.input.nextChar();
            }
        }
    }

    private void parseQuotedValue() {
        char prev = '\u0000';
        this.ch = this.input.nextChar();
        while ((prev != this.quote || this.ch != this.delimiter && this.ch > ' ') && this.ch != '\u0000') {
            if (this.ch != this.quote) {
                this.output.appender.append(this.ch);
                prev = this.ch;
            } else if (prev == this.quoteEscape) {
                this.output.appender.append(this.quote);
                prev = '\u0000';
            } else {
                prev = this.ch;
            }
            this.ch = this.input.nextChar();
        }
        if (this.ch <= ' ') {
            this.skipWhitespace();
        }
    }

    private void parseField() {
        if (this.ch <= ' ' && this.ignoreLeadingWhitespace) {
            this.skipWhitespace();
        }
        if (this.ch == this.delimiter) {
            this.output.emptyParsed();
        } else {
            if (this.ch == this.quote) {
                this.parseQuotedValue();
            } else {
                this.parseValue();
            }
            this.output.valueParsed();
        }
    }

    private void skipWhitespace() {
        while (this.ch <= ' ' && this.ch != this.delimiter && this.ch != this.newLine && this.ch != '\u0000') {
            this.ch = this.input.nextChar();
        }
    }
}

