/*
 * Decompiled with CFR 0.152.
 */
package com.univocity.parsers.common.fields;

import com.univocity.parsers.common.ArgumentUtils;
import com.univocity.parsers.common.fields.FieldSelector;
import com.univocity.parsers.common.fields.FieldSet;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;

public class FieldNameSelector
extends FieldSet<String>
implements FieldSelector {
    public int getFieldIndex(String header) {
        return this.getFieldIndexes(new String[]{header})[0];
    }

    @Override
    public int[] getFieldIndexes(String[] headers) {
        if (headers == null) {
            return null;
        }
        headers = ArgumentUtils.normalize(headers);
        List<String> selection = this.get();
        ArgumentUtils.normalize(selection);
        Object[] chosenFields = selection.toArray(new String[selection.size()]);
        Object[] unknownFields = ArgumentUtils.findMissingElements((Object[])headers, chosenFields);
        if (unknownFields.length > 0 && !selection.containsAll(Arrays.asList(headers)) && unknownFields.length == chosenFields.length) {
            return new int[0];
        }
        int[] out = new int[chosenFields.length];
        int i = 0;
        HashSet<Integer> indexesTaken = new HashSet<Integer>();
        for (Object chosenField : chosenFields) {
            int index = ArgumentUtils.indexOf(headers, chosenField);
            if (index != -1) {
                indexesTaken.add(index);
            }
            out[i++] = index;
        }
        int generatedIndex = 0;
        for (i = 0; i < out.length; ++i) {
            if (out[i] != -1) continue;
            while (indexesTaken.contains(generatedIndex)) {
                ++generatedIndex;
            }
            indexesTaken.add(generatedIndex);
            out[i] = generatedIndex;
        }
        return out;
    }
}

