/*
 * Decompiled with CFR 0.152.
 */
package com.univocity.parsers.common.input;

import com.univocity.parsers.common.Format;
import com.univocity.parsers.common.input.CharInputReader;
import com.univocity.parsers.common.input.EOFException;
import com.univocity.parsers.common.input.InputAnalysisProcess;
import com.univocity.parsers.common.input.LineSeparatorDetector;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractCharInputReader
implements CharInputReader {
    private final StringBuilder commentBuilder = new StringBuilder(50);
    private boolean lineSeparatorDetected = false;
    private final boolean detectLineSeparator;
    private List<InputAnalysisProcess> inputAnalysisProcesses = null;
    private char lineSeparator1;
    private char lineSeparator2;
    private final char normalizedLineSeparator;
    private long lineCount;
    private long charCount;
    public int i;
    public char[] buffer;
    public int length = -1;
    private boolean incrementLineCount = false;
    private boolean normalizeLineEndings = true;

    public AbstractCharInputReader(char normalizedLineSeparator) {
        this.detectLineSeparator = true;
        this.submitLineSeparatorDetector();
        this.lineSeparator1 = '\u0000';
        this.lineSeparator2 = '\u0000';
        this.normalizedLineSeparator = normalizedLineSeparator;
    }

    private void submitLineSeparatorDetector() {
        if (this.detectLineSeparator && !this.lineSeparatorDetected) {
            this.addInputAnalysisProcess(new LineSeparatorDetector(){

                @Override
                protected void apply(char separator1, char separator2) {
                    if (separator1 != '\u0000') {
                        AbstractCharInputReader.this.lineSeparatorDetected = true;
                        AbstractCharInputReader.this.lineSeparator1 = separator1;
                        AbstractCharInputReader.this.lineSeparator2 = separator2;
                    } else {
                        AbstractCharInputReader.this.setLineSeparator(Format.getSystemLineSeparator());
                    }
                }
            });
        }
    }

    public AbstractCharInputReader(char[] lineSeparator, char normalizedLineSeparator) {
        this.detectLineSeparator = false;
        this.normalizedLineSeparator = normalizedLineSeparator;
        this.setLineSeparator(lineSeparator);
    }

    private void setLineSeparator(char[] lineSeparator) {
        if (lineSeparator == null || lineSeparator.length == 0) {
            throw new IllegalArgumentException("Invalid line separator. Expected 1 to 2 characters");
        }
        if (lineSeparator.length > 2) {
            throw new IllegalArgumentException("Invalid line separator. Up to 2 characters are expected. Got " + lineSeparator.length + " characters.");
        }
        this.lineSeparator1 = lineSeparator[0];
        this.lineSeparator2 = lineSeparator.length == 2 ? lineSeparator[1] : (char)'\u0000';
    }

    protected abstract void setReader(Reader var1);

    protected abstract void reloadBuffer();

    @Override
    public final void start(Reader reader) {
        this.stop();
        this.setReader(reader);
        this.lineCount = 0L;
        this.lineSeparatorDetected = false;
        this.submitLineSeparatorDetector();
        this.updateBuffer();
        if (this.length > 0) {
            ++this.i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateBuffer() {
        this.reloadBuffer();
        this.charCount += (long)this.i;
        this.i = 0;
        if (this.length == -1) {
            this.stop();
            this.incrementLineCount = true;
        }
        if (this.inputAnalysisProcesses != null) {
            try {
                for (InputAnalysisProcess process : this.inputAnalysisProcesses) {
                    process.execute(this.buffer, this.length);
                }
            }
            finally {
                this.inputAnalysisProcesses = null;
            }
        }
    }

    public final void addInputAnalysisProcess(InputAnalysisProcess inputAnalysisProcess) {
        if (inputAnalysisProcess == null) {
            return;
        }
        if (this.inputAnalysisProcesses == null) {
            this.inputAnalysisProcesses = new ArrayList<InputAnalysisProcess>();
        }
        this.inputAnalysisProcesses.add(inputAnalysisProcess);
    }

    private void throwEOFException() {
        if (this.incrementLineCount) {
            ++this.lineCount;
        }
        throw new EOFException();
    }

    @Override
    public final char nextChar() {
        if (this.length == -1) {
            this.throwEOFException();
        }
        char ch = this.buffer[this.i - 1];
        if (this.i >= this.length) {
            this.updateBuffer();
        }
        ++this.i;
        if (this.lineSeparator1 == ch && (this.lineSeparator2 == '\u0000' || this.length != -1 && this.lineSeparator2 == this.buffer[this.i - 1])) {
            ++this.lineCount;
            if (this.normalizeLineEndings) {
                if (this.lineSeparator2 != '\u0000') {
                    ch = this.normalizedLineSeparator;
                    if (this.i >= this.length) {
                        if (this.length != -1) {
                            this.updateBuffer();
                        } else {
                            this.throwEOFException();
                        }
                    }
                    ++this.i;
                } else {
                    return this.normalizedLineSeparator;
                }
            }
        }
        return ch;
    }

    @Override
    public final long lineCount() {
        return this.lineCount;
    }

    @Override
    public final void skipLines(long lines) {
        if (lines < 1L) {
            return;
        }
        long expectedLineCount = this.lineCount + lines;
        try {
            do {
                this.nextChar();
            } while (this.lineCount < expectedLineCount);
            if (this.lineCount < lines) {
                throw new IllegalArgumentException("Unable to skip " + lines + " lines from line " + (expectedLineCount - lines) + ". End of input reached");
            }
        }
        catch (EOFException ex) {
            throw new IllegalArgumentException("Unable to skip " + lines + " lines from line " + (expectedLineCount - lines) + ". End of input reached");
        }
    }

    @Override
    public String readComment() {
        this.commentBuilder.setLength(0);
        long expectedLineCount = this.lineCount + 1L;
        try {
            while (true) {
                char ch = this.nextChar();
                if (this.lineCount >= expectedLineCount) break;
                this.commentBuilder.append(ch);
            }
            return this.commentBuilder.toString();
        }
        catch (EOFException ex) {
            return this.commentBuilder.toString();
        }
    }

    @Override
    public final long charCount() {
        return this.charCount + (long)this.i;
    }

    @Override
    public final void enableNormalizeLineEndings(boolean normalizeLineEndings) {
        this.normalizeLineEndings = normalizeLineEndings;
    }

    @Override
    public char[] getLineSeparator() {
        if (this.lineSeparator2 != '\u0000') {
            return new char[]{this.lineSeparator1, this.lineSeparator2};
        }
        return new char[]{this.lineSeparator1};
    }
}

