/*
 * Decompiled with CFR 0.152.
 */
package com.univocity.parsers.common;

import com.univocity.parsers.common.AbstractParser;
import com.univocity.parsers.common.ArgumentUtils;
import com.univocity.parsers.common.ParserOutput;
import com.univocity.parsers.common.ParsingContext;
import com.univocity.parsers.common.input.CharInputReader;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

class DefaultParsingContext
implements ParsingContext {
    private final CharInputReader input;
    private final ParserOutput output;
    protected boolean stopped = false;
    private int[] extractedIndexes = null;
    private Map<String, Integer> columnMap;
    private Map<String, Integer> normalizedColumnMap;
    private int[] enumMap;
    private final AbstractParser<?> parser;

    public DefaultParsingContext(AbstractParser<?> parser) {
        this.parser = parser;
        this.input = parser.input;
        this.output = parser.output;
    }

    @Override
    public void stop() {
        this.stopped = true;
    }

    @Override
    public boolean isStopped() {
        return this.stopped;
    }

    @Override
    public long currentLine() {
        return this.input.lineCount();
    }

    @Override
    public long currentChar() {
        return this.input.charCount();
    }

    @Override
    public int currentColumn() {
        return this.output.getCurrentColumn();
    }

    @Override
    public String[] headers() {
        return this.output.getHeaders();
    }

    @Override
    public int[] extractedFieldIndexes() {
        if (this.extractedIndexes == null) {
            this.extractedIndexes = this.output.getSelectedIndexes();
        }
        return this.extractedIndexes;
    }

    @Override
    public boolean columnsReordered() {
        return this.output.isColumnReorderingEnabled();
    }

    @Override
    public void skipLines(long lines) {
        this.input.skipLines(lines);
    }

    @Override
    public long currentRecord() {
        return this.output.getCurrentRecord();
    }

    @Override
    public String currentParsedContent() {
        char[] chars = this.output.appender.getChars();
        if (chars != null) {
            int length = this.output.appender.length();
            if (length > chars.length) {
                length = chars.length;
            }
            if (length > 0) {
                return new String(chars, 0, length);
            }
        }
        return null;
    }

    @Override
    public int indexOf(String header) {
        Integer index;
        if (this.columnMap != null && this.columnMap.isEmpty()) {
            return -1;
        }
        if (header == null) {
            if (this.headers() == null) {
                throw new IllegalArgumentException("Header name cannot be null.");
            }
            throw new IllegalArgumentException("Header name cannot be null. Use one of the available column names: " + Arrays.asList(this.headers()));
        }
        if (this.columnMap == null) {
            int i;
            String[] headers = this.headers();
            if (headers == null) {
                this.columnMap = Collections.emptyMap();
                this.normalizedColumnMap = Collections.emptyMap();
                return -1;
            }
            this.columnMap = new HashMap<String, Integer>(headers.length);
            int[] extractedIndexes = this.extractedFieldIndexes();
            boolean columnsReordered = this.columnsReordered();
            if (extractedIndexes != null) {
                if (columnsReordered) {
                    for (i = 0; i < extractedIndexes.length; ++i) {
                        int originalIndex = extractedIndexes[i];
                        String h = headers[originalIndex];
                        this.columnMap.put(h, i);
                    }
                } else {
                    for (i = 0; i < extractedIndexes.length; ++i) {
                        this.columnMap.put(headers[i], i);
                    }
                }
            } else {
                for (i = 0; i < headers.length; ++i) {
                    this.columnMap.put(headers[i], i);
                }
            }
            this.normalizedColumnMap = new HashMap<String, Integer>(headers.length);
            for (Map.Entry<String, Integer> e : this.columnMap.entrySet()) {
                this.normalizedColumnMap.put(e.getKey().trim().toLowerCase(), e.getValue());
            }
        }
        if ((index = this.columnMap.get(header)) == null && (index = this.normalizedColumnMap.get(header.trim().toLowerCase())) == null) {
            return -1;
        }
        return index;
    }

    @Override
    public int indexOf(Enum<?> header) {
        if (this.enumMap != null && this.enumMap.length == 0) {
            return -1;
        }
        if (header == null) {
            if (this.headers() == null) {
                throw new IllegalArgumentException("Header name cannot be null.");
            }
            throw new IllegalArgumentException("Header name cannot be null. Use one of the available column names: " + Arrays.asList(this.headers()));
        }
        if (this.enumMap == null) {
            int i;
            Object[] headers = this.headers();
            if (headers == null) {
                this.enumMap = new int[0];
                return -1;
            }
            Enum[] constants = (Enum[])header.getClass().getEnumConstants();
            int lastOrdinal = Integer.MIN_VALUE;
            for (i = 0; i < constants.length; ++i) {
                if (lastOrdinal >= constants[i].ordinal()) continue;
                lastOrdinal = constants[i].ordinal();
            }
            this.enumMap = new int[lastOrdinal + 1];
            for (i = 0; i < constants.length; ++i) {
                int index;
                Enum constant = constants[i];
                String name = constant.toString();
                this.enumMap[constant.ordinal()] = index = ArgumentUtils.indexOf(headers, name);
            }
        }
        return this.enumMap[header.ordinal()];
    }

    @Override
    public Map<Long, String> comments() {
        return this.parser.getComments();
    }

    @Override
    public String lastComment() {
        return this.parser.getLastComment();
    }

    @Override
    public String[] parsedHeaders() {
        return this.parser.getParsedHeaders();
    }

    @Override
    public char[] lineSeparator() {
        return this.input.getLineSeparator();
    }
}

