/*
 * Decompiled with CFR 0.152.
 */
package com.univocity.parsers.common.input;

import com.univocity.parsers.common.Format;
import com.univocity.parsers.common.input.DefaultCharAppender;
import java.io.IOException;
import java.io.Writer;
import java.util.Arrays;

public class WriterCharAppender
extends DefaultCharAppender {
    private final char lineSeparator1;
    private final char lineSeparator2;
    private final char newLine;
    private boolean denormalizeLineEndings = true;

    public WriterCharAppender(int maxLength, String emptyValue, Format format) {
        super(maxLength, emptyValue);
        char[] lineSeparator = format.getLineSeparator();
        this.lineSeparator1 = lineSeparator[0];
        this.lineSeparator2 = lineSeparator.length > 1 ? lineSeparator[1] : (char)'\u0000';
        this.newLine = format.getNormalizedNewline();
    }

    @Override
    public void appendIgnoringWhitespace(char ch) {
        try {
            if (ch == this.newLine && this.denormalizeLineEndings) {
                super.appendIgnoringWhitespace(this.lineSeparator1);
                if (this.lineSeparator2 != '\u0000') {
                    super.appendIgnoringWhitespace(this.lineSeparator2);
                }
            } else {
                super.appendIgnoringWhitespace(ch);
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            this.expandAndRetry();
            this.appendIgnoringWhitespace(ch);
        }
    }

    @Override
    public void appendIgnoringPadding(char ch, char padding) {
        try {
            if (ch == this.newLine && this.denormalizeLineEndings) {
                super.appendIgnoringPadding(this.lineSeparator1, padding);
                if (this.lineSeparator2 != '\u0000') {
                    super.appendIgnoringPadding(this.lineSeparator2, padding);
                }
            } else {
                super.appendIgnoringPadding(ch, padding);
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            this.expandAndRetry();
            this.appendIgnoringPadding(ch, padding);
        }
    }

    @Override
    public void appendIgnoringWhitespaceAndPadding(char ch, char padding) {
        try {
            if (ch == this.newLine && this.denormalizeLineEndings) {
                super.appendIgnoringWhitespaceAndPadding(this.lineSeparator1, padding);
                if (this.lineSeparator2 != '\u0000') {
                    super.appendIgnoringWhitespaceAndPadding(this.lineSeparator2, padding);
                }
            } else {
                super.appendIgnoringWhitespaceAndPadding(ch, padding);
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            this.expandAndRetry();
            this.appendIgnoringPadding(ch, padding);
        }
    }

    @Override
    public void append(char ch) {
        if (ch == this.newLine && this.denormalizeLineEndings) {
            this.appendNewLine();
        } else {
            this.appendAndExpand(ch);
        }
    }

    public void writeCharsAndReset(Writer writer) throws IOException {
        if (this.index - this.whitespaceCount > 0) {
            writer.write(this.chars, 0, this.index - this.whitespaceCount);
        } else if (this.emptyChars != null) {
            writer.write(this.emptyChars, 0, this.emptyChars.length);
        }
        this.index = 0;
        this.whitespaceCount = 0;
    }

    public void appendNewLine() {
        if (this.index + 2 >= this.chars.length) {
            this.expand();
        }
        this.chars[this.index++] = this.lineSeparator1;
        if (this.lineSeparator2 != '\u0000') {
            this.chars[this.index++] = this.lineSeparator2;
        }
    }

    @Override
    public void fill(char ch, int length) {
        while (this.index + length > this.chars.length) {
            this.expand(length);
        }
        for (int i = 0; i < length; ++i) {
            this.chars[this.index++] = ch;
        }
    }

    private void appendAndExpand(char ch) {
        try {
            this.chars[this.index++] = ch;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            this.expandAndRetry();
            this.appendAndExpand(ch);
        }
    }

    private void expandAndRetry() {
        this.expand();
        --this.index;
    }

    private void expand() {
        this.chars = Arrays.copyOf(this.chars, (int)((double)this.chars.length * 1.5));
    }

    private void expand(int additionalLength) {
        this.chars = Arrays.copyOf(this.chars, (int)((double)(this.index + additionalLength) * 1.5));
    }

    @Override
    public void append(DefaultCharAppender appender) {
        try {
            super.append(appender);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            this.expand(appender.index);
            super.append(appender);
        }
    }

    public void enableDenormalizedLineEndings(boolean enableDenormalizedLineEndings) {
        this.denormalizeLineEndings = enableDenormalizedLineEndings;
    }

    public void append(String string, int from, int to) {
        try {
            string.getChars(from, to, this.chars, this.index);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            this.expand(to - from);
            string.getChars(from, to, this.chars, this.index);
        }
        this.index += to - from;
    }
}

