/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component;

import com.vaadin.flow.component.AttachEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEvent;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.Composite;
import com.vaadin.flow.component.DetachEvent;
import com.vaadin.flow.component.HasEnabled;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.internal.ComponentMetaData;
import com.vaadin.flow.di.Instantiator;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.function.SerializableTriConsumer;
import com.vaadin.flow.i18n.LocaleChangeEvent;
import com.vaadin.flow.i18n.LocaleChangeObserver;
import com.vaadin.flow.internal.ReflectionCache;
import com.vaadin.flow.internal.StateNode;
import com.vaadin.flow.internal.nodefeature.VirtualChildrenList;
import com.vaadin.flow.server.Attributes;
import com.vaadin.flow.server.VaadinService;
import com.vaadin.flow.shared.Registration;
import java.util.Collection;
import java.util.Iterator;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.stream.Stream;

public class ComponentUtil {
    static ReflectionCache<Component, ComponentMetaData> componentMetaDataCache = new ReflectionCache(ComponentMetaData::new);

    private ComponentUtil() {
    }

    public static void findComponents(Element element, Consumer<Component> componentConsumer) {
        assert (element != null);
        assert (componentConsumer != null);
        Optional<Component> maybeComponent = element.getComponent();
        if (maybeComponent.isPresent()) {
            Component component = maybeComponent.get();
            componentConsumer.accept(component);
            return;
        }
        element.getChildren().forEach(childElement -> ComponentUtil.findComponents(childElement, componentConsumer));
    }

    public static Component getParentUsingComposite(Composite<?> composite, Component component) {
        Composite compositeAncestor = composite;
        Object compositeChild;
        while ((compositeChild = compositeAncestor.getContent()) != component) {
            compositeAncestor = (Composite)compositeAncestor.getContent();
        }
        return compositeAncestor;
    }

    public static Component getInnermostComponent(Composite<?> composite) {
        Object content = composite.getContent();
        while (content instanceof Composite) {
            content = ((Composite)content).getContent();
        }
        return content;
    }

    public static boolean isCompositeContent(Composite<?> composite, Component component) {
        Object compositeContent = composite.getContent();
        if (compositeContent == component) {
            return true;
        }
        if (compositeContent instanceof Composite) {
            return ComponentUtil.isCompositeContent((Composite)compositeContent, component);
        }
        return false;
    }

    public static Optional<Component> findParentComponent(Element element) {
        Element mappedElement;
        for (mappedElement = element; mappedElement != null && !mappedElement.getComponent().isPresent(); mappedElement = mappedElement.getParent()) {
        }
        if (mappedElement == null) {
            return Optional.empty();
        }
        return Optional.of(ComponentUtil.getInnermostComponent(mappedElement));
    }

    public static Component getInnermostComponent(Element element) {
        assert (element.getComponent().isPresent());
        Component component = element.getComponent().get();
        if (component instanceof Composite) {
            return ComponentUtil.getInnermostComponent((Composite)component);
        }
        return component;
    }

    public static void onComponentAttach(Component component, boolean initialAttach) {
        Optional<Component> parent;
        Optional<UI> ui;
        if (component instanceof Composite) {
            ComponentUtil.onComponentAttach(((Composite)component).getContent(), initialAttach);
        }
        if ((ui = component.getUI()).isPresent() && component instanceof LocaleChangeObserver) {
            LocaleChangeEvent localeChangeEvent = new LocaleChangeEvent(ui.get(), ui.get().getLocale());
            ((LocaleChangeObserver)((Object)component)).localeChange(localeChangeEvent);
        }
        AttachEvent attachEvent = new AttachEvent(component, initialAttach);
        component.onAttach(attachEvent);
        ComponentUtil.fireEvent(component, attachEvent);
        if (component instanceof HasEnabled && component.getElement().isEnabled() != component.getElement().getNode().isEnabledSelf() && (parent = component.getParent()).isPresent() && ComponentUtil.isAttachedToParent(component, parent.get())) {
            component.onEnabledStateChanged(component.getElement().isEnabled());
        }
    }

    public static void onComponentDetach(Component component) {
        if (component instanceof Composite) {
            ComponentUtil.onComponentDetach(((Composite)component).getContent());
        }
        DetachEvent detachEvent = new DetachEvent(component);
        component.onDetach(detachEvent);
        ComponentUtil.fireEvent(component, detachEvent);
        if (component instanceof HasEnabled && component.getElement().isEnabled() != component.getElement().getNode().isEnabledSelf()) {
            Optional<Component> parent = component.getParent();
            if (parent.isPresent()) {
                Component parentComponent = parent.get();
                boolean state = ComponentUtil.isAttachedToParent(component, parentComponent) ? ComponentUtil.checkParentChainState(parentComponent) : component.getElement().getNode().isEnabledSelf();
                component.onEnabledStateChanged(state);
            } else {
                component.onEnabledStateChanged(component.getElement().isEnabled());
            }
        }
    }

    private static boolean isAttachedToParent(Component component, Component parentComponent) {
        return parentComponent.getChildren().anyMatch(child -> child.equals(component)) || ComponentUtil.isVirtualChild(component, parentComponent);
    }

    private static boolean isVirtualChild(Component component, Component parentComponent) {
        Iterator<StateNode> iterator = parentComponent.getElement().getNode().getFeature(VirtualChildrenList.class).iterator();
        while (iterator.hasNext()) {
            if (!iterator.next().equals(component.getElement().getNode())) continue;
            return true;
        }
        return false;
    }

    private static boolean checkParentChainState(Component component) {
        Component parentComponent;
        if (!component.getElement().getNode().isEnabledSelf()) {
            return false;
        }
        Optional<Component> parent = component.getParent();
        if (parent.isPresent() && ComponentUtil.isAttachedToParent(component, parentComponent = parent.get())) {
            return ComponentUtil.checkParentChainState(parentComponent);
        }
        return true;
    }

    public static <T extends ComponentEvent<?>> Registration addListener(Component component, Class<T> eventType, ComponentEventListener<T> listener) {
        return component.addListener(eventType, listener);
    }

    public static <T extends Component> void fireEvent(T component, ComponentEvent<? extends T> componentEvent) {
        component.fireEvent(componentEvent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T extends Component> T componentFromElement(Element element, Class<T> componentType, boolean mapComponent) {
        if (element == null) {
            throw new IllegalArgumentException("Element to use cannot be null");
        }
        if (componentType == null) {
            throw new IllegalArgumentException("Component type cannot be null");
        }
        Component.MapToExistingElement wrapData = new Component.MapToExistingElement(element, mapComponent);
        try {
            Component.elementToMapTo.set(wrapData);
            UI ui = UI.getCurrent();
            if (ui == null) {
                throw new IllegalStateException("UI instance is not available. It looks like you are trying to execute UI code outside the UI/Servlet dispatching thread");
            }
            Instantiator instantiator = Instantiator.get(ui);
            T t = instantiator.createComponent(componentType);
            return t;
        }
        finally {
            Component.elementToMapTo.remove();
        }
    }

    public static Collection<ComponentMetaData.SynchronizedPropertyInfo> getSynchronizedProperties(Class<? extends Component> componentClass) {
        return componentMetaDataCache.get(componentClass).getSynchronizedProperties();
    }

    public static Stream<String> getSynchronizedPropertyEvents(Class<? extends Component> componentClass) {
        Collection<ComponentMetaData.SynchronizedPropertyInfo> infos = componentMetaDataCache.get(componentClass).getSynchronizedProperties();
        return infos.stream().flatMap(ComponentMetaData.SynchronizedPropertyInfo::getEventNames).distinct();
    }

    public static ComponentMetaData.DependencyInfo getDependencies(VaadinService service, Class<? extends Component> componentClass) {
        return componentMetaDataCache.get(componentClass).getDependencyInfo(service);
    }

    private static <T, U> void setData(Component component, SerializableTriConsumer<Attributes, T, U> setter, T key, U value) {
        Attributes attributes = component.attributes;
        if (attributes == null) {
            if (value == null) {
                return;
            }
            component.attributes = attributes = new Attributes();
        }
        setter.accept(attributes, (Attributes)key, (T)value);
        if (attributes.isEmpty()) {
            component.attributes = null;
        }
    }

    public static void setData(Component component, String key, Object value) {
        ComponentUtil.setData(component, Attributes::setAttribute, key, value);
    }

    public static <T> void setData(Component component, Class<T> type, T value) {
        ComponentUtil.setData(component, Attributes::setAttribute, type, value);
    }

    private static <T, U> U getData(Component component, BiFunction<Attributes, T, U> getter, T key) {
        Attributes attributes = component.attributes;
        if (attributes == null) {
            return null;
        }
        return getter.apply(attributes, (Attributes)key);
    }

    public static Object getData(Component component, String key) {
        return ComponentUtil.getData(component, Attributes::getAttribute, key);
    }

    public static <T> T getData(Component component, Class<T> type) {
        return (T)ComponentUtil.getData(component, (attributes, ignore) -> attributes.getAttribute(type), type);
    }
}

