/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.internal;

import com.vaadin.flow.server.VaadinService;
import com.vaadin.flow.server.startup.FakeBrowser;
import com.vaadin.flow.shared.util.SharedUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Stream;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HtmlDependencyParser
implements Serializable {
    private final String root;

    public HtmlDependencyParser(String uri) {
        this.root = uri;
    }

    Collection<String> parseDependencies(VaadinService service) {
        HashSet<String> dependencies = new HashSet<String>();
        String rooUri = SharedUtil.prefixIfRelative(this.root, "frontend://");
        this.parseDependencies(rooUri, dependencies, service);
        return dependencies;
    }

    private void parseDependencies(String path, Set<String> dependencies, VaadinService service) {
        if (dependencies.contains(path)) {
            return;
        }
        dependencies.add(path);
        FakeBrowser browser = FakeBrowser.getEs6();
        try (InputStream content = service.getResourceAsStream(path, browser, null);){
            if (content == null) {
                this.getLogger().trace("Can't find resource '{}' to parse for imports via the servlet context", (Object)path);
            } else {
                String resolvedPath = service.resolveResource(path, browser);
                this.parseHtmlImports(content, resolvedPath).map(uri -> this.resolveUri((String)uri, path)).forEach(uri -> this.parseDependencies((String)uri, dependencies, service));
            }
        }
        catch (IOException exception) {
            this.getLogger().debug("Couldn't close template input stream", (Throwable)exception);
        }
    }

    private String resolveUri(String relative, String base) {
        if (relative.startsWith("/")) {
            return relative;
        }
        try {
            URI uri = new URI(base);
            return this.relativize(relative, uri);
        }
        catch (URISyntaxException exception) {
            this.getLogger().debug("Couldn't make URI for {}. The path {} will be used as is.", new Object[]{base, relative, exception});
            return relative;
        }
    }

    private String relativize(String relative, URI base) throws URISyntaxException {
        URI newUri;
        if (base.getPath().isEmpty()) {
            String uriString = base.toString();
            int index = uriString.lastIndexOf(47);
            newUri = new URI(uriString.substring(0, index + 1) + relative);
        } else {
            newUri = base.resolve(relative);
        }
        return HtmlDependencyParser.toNormalizedURI(newUri);
    }

    static String toNormalizedURI(URI uri) {
        URI normalized = uri.normalize();
        if ("frontend".equals(normalized.getScheme()) || "base".equals(normalized.getScheme()) || "context".equals(normalized.getScheme())) {
            if (".".equals(normalized.getAuthority()) && normalized.getHost() == null) {
                return normalized.toString().replace("//./", "//");
            }
            if (normalized.getPath().startsWith("/../")) {
                return normalized.toString().replace(normalized.getHost() + "/../", "");
            }
        }
        return normalized.toString();
    }

    private Stream<String> parseHtmlImports(InputStream content, String path) {
        assert (content != null);
        try {
            Document parsedDocument = Jsoup.parse((InputStream)content, (String)StandardCharsets.UTF_8.name(), (String)"");
            return parsedDocument.getElementsByTag("link").stream().filter(link -> link.hasAttr("rel") && link.hasAttr("href")).filter(link -> link.attr("rel").equals("import")).map(link -> link.attr("href"));
        }
        catch (IOException exception) {
            this.getLogger().info("Can't parse the template declared using '{}' path", (Object)path, (Object)exception);
            return Stream.empty();
        }
    }

    private Logger getLogger() {
        return LoggerFactory.getLogger(HtmlDependencyParser.class);
    }
}

