/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.internal;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEvent;
import com.vaadin.flow.component.Key;
import com.vaadin.flow.component.KeyLocation;
import com.vaadin.flow.component.KeyModifier;
import java.util.EnumSet;
import java.util.Set;

public abstract class KeyboardEvent
extends ComponentEvent<Component> {
    private final Key key;
    private final KeyLocation location;
    private final boolean repeat;
    private final boolean composing;
    private final Set<KeyModifier> modifiers;

    public KeyboardEvent(Component source, boolean fromClient, String key, int location, boolean ctrlKey, boolean shiftKey, boolean altKey, boolean metaKey, boolean repeat, boolean composing) {
        super(source, fromClient);
        this.key = Key.of(key, new String[0]);
        this.location = KeyLocation.of(location);
        this.repeat = repeat;
        this.composing = composing;
        this.modifiers = EnumSet.noneOf(KeyModifier.class);
        if (ctrlKey) {
            this.modifiers.add(KeyModifier.CONTROL);
        }
        if (shiftKey) {
            this.modifiers.add(KeyModifier.SHIFT);
        }
        if (altKey) {
            this.modifiers.add(KeyModifier.ALT);
        }
        if (metaKey) {
            this.modifiers.add(KeyModifier.META);
        }
    }

    public KeyboardEvent(Component source, String key) {
        this(source, false, key, 0, false, false, false, false, false, false);
    }

    public Key getKey() {
        return this.key;
    }

    public KeyLocation getLocation() {
        return this.location;
    }

    public boolean isRepeat() {
        return this.repeat;
    }

    public boolean isComposing() {
        return this.composing;
    }

    public Set<KeyModifier> getModifiers() {
        return this.modifiers;
    }
}

