/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.internal;

import com.vaadin.flow.function.SerializableFunction;
import com.vaadin.flow.internal.CurrentInstance;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;

public class ReflectionCache<C, T> {
    private static final Set<ReflectionCache<?, ?>> caches = Collections.synchronizedSet(Collections.newSetFromMap(new WeakHashMap()));
    private final ConcurrentHashMap<Class<? extends C>, T> values = new ConcurrentHashMap();
    private final SerializableFunction<Class<? extends C>, T> valueProvider;

    public ReflectionCache(SerializableFunction<Class<C>, T> valueProvider) {
        if (valueProvider == null) {
            throw new IllegalArgumentException("value provider cannot be null");
        }
        this.valueProvider = ReflectionCache.wrapValueProvider(valueProvider);
        caches.add(this);
    }

    private static <C, T> SerializableFunction<Class<? extends C>, T> wrapValueProvider(SerializableFunction<Class<C>, T> valueProvider) {
        return type -> {
            Map<Class<?>, CurrentInstance> instances = CurrentInstance.getInstances();
            try {
                CurrentInstance.clearAll();
                Object r = valueProvider.apply((Class)type);
                return r;
            }
            finally {
                CurrentInstance.restoreInstances(instances);
            }
        };
    }

    public T get(Class<? extends C> type) {
        return this.values.computeIfAbsent(type, this.valueProvider);
    }

    public boolean contains(Class<? extends C> type) {
        return this.values.containsKey(type);
    }

    public void clear() {
        this.values.clear();
    }

    public static void clearAll() {
        caches.forEach(ReflectionCache::clear);
    }
}

