/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.router;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.internal.ReflectTools;
import com.vaadin.flow.router.ErrorParameter;
import com.vaadin.flow.router.HasUrlParameter;
import com.vaadin.flow.router.Location;
import com.vaadin.flow.router.NavigationEvent;
import com.vaadin.flow.router.NavigationHandler;
import com.vaadin.flow.router.NavigationState;
import com.vaadin.flow.router.NavigationStateBuilder;
import com.vaadin.flow.router.NavigationTrigger;
import com.vaadin.flow.router.Router;
import com.vaadin.flow.router.internal.ErrorStateRenderer;
import com.vaadin.flow.router.internal.NavigationStateRenderer;
import com.vaadin.flow.server.startup.RouteRegistry;
import java.util.Collections;
import java.util.EventObject;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

public abstract class BeforeEvent
extends EventObject {
    private final Location location;
    private final NavigationTrigger trigger;
    private final UI ui;
    private NavigationHandler rerouteTarget;
    private final Class<?> navigationTarget;
    private NavigationState rerouteTargetState;
    private ErrorParameter<?> errorParameter;

    public BeforeEvent(NavigationEvent event, Class<?> navigationTarget) {
        this(event.getSource(), event.getTrigger(), event.getLocation(), navigationTarget, event.getUI());
    }

    public BeforeEvent(Router router, NavigationTrigger trigger, Location location, Class<?> navigationTarget, UI ui) {
        super(router);
        assert (trigger != null);
        assert (location != null);
        assert (navigationTarget != null);
        assert (ui != null);
        this.trigger = trigger;
        this.location = location;
        this.navigationTarget = navigationTarget;
        this.ui = ui;
    }

    public Location getLocation() {
        return this.location;
    }

    public NavigationTrigger getTrigger() {
        return this.trigger;
    }

    @Override
    public Router getSource() {
        return (Router)super.getSource();
    }

    public boolean hasRerouteTarget() {
        return this.rerouteTarget != null;
    }

    public NavigationHandler getRerouteTarget() {
        return this.rerouteTarget;
    }

    public void rerouteTo(NavigationHandler rerouteTarget, NavigationState targetState) {
        this.rerouteTargetState = targetState;
        this.rerouteTarget = rerouteTarget;
    }

    public void rerouteTo(NavigationState targetState) {
        Objects.requireNonNull(targetState, "targetState cannot be null");
        this.rerouteTo(new NavigationStateRenderer(targetState), targetState);
    }

    public void rerouteTo(Class<? extends Component> routeTargetType) {
        Objects.requireNonNull(routeTargetType, "routeTargetType cannot be null");
        this.rerouteTo(new NavigationStateBuilder().withTarget(routeTargetType).build());
    }

    public void rerouteTo(String route) {
        this.getSource().getRegistry().getNavigationTarget(route).ifPresent(this::rerouteTo);
    }

    public <T> void rerouteTo(String route, T routeParam) {
        this.rerouteTo(route, Collections.singletonList(routeParam));
    }

    public <T> void rerouteTo(String route, List<T> routeParams) {
        List<String> segments = routeParams.stream().map(Object::toString).collect(Collectors.toList());
        Class<? extends Component> target = this.getTargetOrThrow(route, segments);
        if (!routeParams.isEmpty()) {
            this.checkUrlParameterType(routeParams.get(0), target);
        }
        this.rerouteTo(new NavigationStateBuilder().withTarget(target, segments).build());
    }

    private Class<? extends Component> getTargetOrThrow(String route, List<String> segments) {
        if (!this.getSource().getRegistry().hasRouteTo(route)) {
            throw new IllegalArgumentException(String.format("No navigation target found for route '%s'", route));
        }
        return this.getSource().getRegistry().getNavigationTarget(route, segments).orElseThrow(() -> new IllegalArgumentException(String.format("The navigation target for route '%s' doesn't accept the parameters %s.", route, segments)));
    }

    private <T> void checkUrlParameterType(T routeParam, Class<? extends Component> target) {
        Class<?> genericInterfaceType = ReflectTools.getGenericInterfaceType(target, HasUrlParameter.class);
        if (!genericInterfaceType.isAssignableFrom(routeParam.getClass())) {
            throw new IllegalArgumentException(String.format("Given route parameter '%s' is of the wrong type. Required '%s'.", routeParam.getClass(), genericInterfaceType));
        }
    }

    public Class<?> getRouteTargetType() {
        return this.rerouteTargetState.getNavigationTarget();
    }

    public Class<?> getNavigationTarget() {
        return this.navigationTarget;
    }

    public void rerouteToError(Class<? extends Exception> exception) {
        this.rerouteToError(exception, "");
    }

    public void rerouteToError(Class<? extends Exception> exception, String customMessage) {
        Exception instance = ReflectTools.createInstance(exception);
        this.rerouteToError(instance, customMessage);
    }

    public void rerouteToError(Exception exception, String customMessage) {
        Optional<RouteRegistry.ErrorTargetEntry> maybeLookupResult = this.getSource().getRegistry().getErrorNavigationTarget(exception);
        if (!maybeLookupResult.isPresent()) {
            throw new RuntimeException(customMessage, exception);
        }
        RouteRegistry.ErrorTargetEntry lookupResult = maybeLookupResult.get();
        this.rerouteTargetState = new NavigationStateBuilder().withTarget(lookupResult.getNavigationTarget()).build();
        this.rerouteTarget = new ErrorStateRenderer(this.rerouteTargetState);
        this.errorParameter = new ErrorParameter<Exception>(lookupResult.getHandledExceptionType(), exception, customMessage);
    }

    public boolean hasErrorParameter() {
        return this.errorParameter != null;
    }

    public ErrorParameter<?> getErrorParameter() {
        return this.errorParameter;
    }

    public UI getUI() {
        return this.ui;
    }
}

