/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component;

import com.vaadin.flow.component.BlurNotifier;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.FocusNotifier;
import com.vaadin.flow.component.HasElement;
import com.vaadin.flow.component.HasEnabled;
import java.io.Serializable;

public interface Focusable<T extends Component>
extends HasElement,
BlurNotifier<T>,
FocusNotifier<T>,
HasEnabled {
    default public void setTabIndex(int tabIndex) {
        this.getElement().setAttribute("tabindex", String.valueOf(tabIndex));
    }

    default public int getTabIndex() {
        String attribute = this.getElement().getAttribute("tabindex");
        if (attribute == null || attribute.isEmpty()) {
            throw new IllegalStateException("tabindex attribute is empty on element " + this.getElement().getTag());
        }
        try {
            return Integer.parseInt(attribute);
        }
        catch (Exception e) {
            throw new IllegalStateException("tabindex attribute could not be parsed on element " + this.getElement().getTag() + ": " + attribute);
        }
    }

    default public void focus() {
        this.getElement().callFunction("focus", new Serializable[0]);
    }

    default public void blur() {
        this.getElement().callFunction("blur", new Serializable[0]);
    }
}

