/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.HasElement;
import com.vaadin.flow.component.HasEnabled;
import com.vaadin.flow.dom.Element;
import java.util.Objects;
import org.slf4j.LoggerFactory;

public interface HasComponents
extends HasElement,
HasEnabled {
    default public void add(Component ... components) {
        Objects.requireNonNull(components, "Components should not be null");
        for (Component component : components) {
            Objects.requireNonNull(component, "Component to add cannot be null");
            this.getElement().appendChild(component.getElement());
        }
    }

    default public void remove(Component ... components) {
        Objects.requireNonNull(components, "Components should not be null");
        for (Component component : components) {
            Objects.requireNonNull(component, "Component to remove cannot be null");
            Element parent = component.getElement().getParent();
            if (parent == null) {
                LoggerFactory.getLogger(HasComponents.class).debug("Remove of a component with no parent does nothing.");
                return;
            }
            if (!this.getElement().equals(parent)) {
                throw new IllegalArgumentException("The given component (" + component + ") is not a child of this component");
            }
            this.getElement().removeChild(component.getElement());
        }
    }

    default public void removeAll() {
        this.getElement().removeAllChildren();
    }

    default public void addComponentAtIndex(int index, Component component) {
        Objects.requireNonNull(component, "Component should not be null");
        if (index < 0) {
            throw new IllegalArgumentException("Cannot add a component with a negative index");
        }
        this.getElement().insertChild(index, component.getElement());
    }

    default public void addComponentAsFirst(Component component) {
        this.addComponentAtIndex(0, component);
    }
}

