/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.polymertemplate;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.polymertemplate.AbstractTemplate;
import com.vaadin.flow.component.polymertemplate.DefaultTemplateParser;
import com.vaadin.flow.component.polymertemplate.TemplateInitializer;
import com.vaadin.flow.component.polymertemplate.TemplateParser;
import com.vaadin.flow.internal.StateNode;
import com.vaadin.flow.internal.UsageStatistics;
import com.vaadin.flow.internal.nodefeature.ElementPropertyMap;
import com.vaadin.flow.server.VaadinService;
import com.vaadin.flow.templatemodel.BeanModelType;
import com.vaadin.flow.templatemodel.ComplexModelType;
import com.vaadin.flow.templatemodel.ListModelType;
import com.vaadin.flow.templatemodel.ModelDescriptor;
import com.vaadin.flow.templatemodel.ModelType;
import com.vaadin.flow.templatemodel.TemplateModel;
import com.vaadin.flow.templatemodel.TemplateModelProxyHandler;
import elemental.json.Json;
import elemental.json.JsonArray;
import java.io.Serializable;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public abstract class PolymerTemplate<M extends TemplateModel>
extends AbstractTemplate<M> {
    private transient M model;

    public PolymerTemplate(TemplateParser parser) {
        this(parser, VaadinService.getCurrent());
    }

    protected PolymerTemplate(TemplateParser parser, VaadinService service) {
        if (service == null) {
            throw new IllegalStateException(VaadinService.class.getSimpleName() + " instance is null. It means that you are trying to create a component instance outside of servlet request thread which is not thread safe. Any component instantiation logic should be protected by a session lock.Call your logic inside the UI::access method.");
        }
        TemplateInitializer templateInitializer = new TemplateInitializer(this, parser, service);
        templateInitializer.initChildElements();
        Set<String> twoWayBindingPaths = templateInitializer.getTwoWayBindingPaths();
        this.initModel(twoWayBindingPaths);
    }

    public PolymerTemplate() {
        this(DefaultTemplateParser.getInstance(), VaadinService.getCurrent());
    }

    public boolean isSupportedClass(Class<?> type) {
        List modelTypes = ModelDescriptor.get(this.getModelType()).getPropertyNames().map(this::getModelType).collect(Collectors.toList());
        boolean result = false;
        for (ModelType modelType : modelTypes) {
            if (type.equals(modelType.getJavaType())) {
                result = true;
            } else if (modelType instanceof ListModelType) {
                result = PolymerTemplate.checkListType(type, modelType);
            }
            if (!result) continue;
            break;
        }
        return result;
    }

    private static boolean checkListType(Class<?> type, ModelType modelType) {
        if (type.isAssignableFrom(List.class)) {
            return true;
        }
        ComplexModelType model = modelType;
        while (model instanceof ListModelType) {
            model = ((ListModelType)model).getItemType();
        }
        return type.equals(model.getJavaType());
    }

    private ModelType getModelType(String type) {
        return ModelDescriptor.get(this.getModelType()).getPropertyType(type);
    }

    public ModelType getModelType(Type type) {
        List modelTypes = ModelDescriptor.get(this.getModelType()).getPropertyNames().map(this::getModelType).collect(Collectors.toList());
        for (ModelType mtype : modelTypes) {
            ModelType modelType;
            if (type.equals(mtype.getJavaType())) {
                return mtype;
            }
            if (!(mtype instanceof ListModelType) || (modelType = PolymerTemplate.getModelTypeForListModel(type, mtype)) == null) continue;
            return modelType;
        }
        String msg = String.format("Couldn't find ModelType for requested class %s", type.getTypeName());
        throw new IllegalArgumentException(msg);
    }

    @Override
    protected M getModel() {
        if (this.model == null) {
            this.model = this.createTemplateModelInstance();
        }
        return this.model;
    }

    private M createTemplateModelInstance() {
        ModelDescriptor descriptor = ModelDescriptor.get(this.getModelType());
        return (M)((TemplateModel)TemplateModelProxyHandler.createModelProxy(this.getStateNode(), descriptor));
    }

    private static ModelType getModelTypeForListModel(Type type, ModelType mtype) {
        ComplexModelType modelType = mtype;
        while (modelType instanceof ListModelType) {
            if (type.equals(modelType.getJavaType())) {
                return modelType;
            }
            modelType = ((ListModelType)modelType).getItemType();
        }
        if (type.equals(modelType.getJavaType())) {
            return modelType;
        }
        return null;
    }

    private void initModel(Set<String> twoWayBindingPaths) {
        this.getModel();
        BeanModelType<?> modelType = TemplateModelProxyHandler.getModelTypeForProxy(this.model);
        Map<String, Boolean> allowedProperties = modelType.getClientUpdateAllowedProperties(twoWayBindingPaths);
        Set allowedPropertyName = Collections.emptySet();
        if (!allowedProperties.isEmpty()) {
            allowedPropertyName = new HashSet<String>(allowedProperties.keySet());
        }
        ElementPropertyMap.getModel(this.getStateNode()).setUpdateFromClientFilter(allowedPropertyName::contains);
        List<String> propertyNames = this.removeSimpleProperties();
        this.getStateNode().runWhenAttached(ui -> ui.getInternals().getStateTree().beforeClientResponse(this.getStateNode(), context -> context.getUI().getPage().executeJavaScript("this.registerUpdatableModelProperties($0, $1)", new Serializable[]{this.getElement(), this.filterUpdatableProperties(allowedProperties)})));
        this.getStateNode().runWhenAttached(ui -> ui.getInternals().getStateTree().beforeClientResponse(this.getStateNode(), context -> context.getUI().getPage().executeJavaScript("this.populateModelProperties($0, $1)", new Serializable[]{this.getElement(), this.filterUnsetProperties(propertyNames)})));
    }

    private JsonArray filterUnsetProperties(List<String> properties) {
        JsonArray array = Json.createArray();
        ElementPropertyMap map = this.getStateNode().getFeature(ElementPropertyMap.class);
        int i = 0;
        for (String property : properties) {
            if (map.hasProperty(property)) continue;
            array.set(i, property);
            ++i;
        }
        return array;
    }

    private JsonArray filterUpdatableProperties(Map<String, Boolean> allowedProperties) {
        JsonArray array = Json.createArray();
        int i = 0;
        for (Map.Entry<String, Boolean> entry : allowedProperties.entrySet()) {
            if (!entry.getValue().booleanValue()) continue;
            array.set(i, entry.getKey());
            ++i;
        }
        return array;
    }

    private List<String> removeSimpleProperties() {
        ElementPropertyMap map = this.getStateNode().getFeature(ElementPropertyMap.class);
        List<String> props = map.getPropertyNames().filter(name -> !(map.getProperty((String)name) instanceof StateNode)).collect(Collectors.toList());
        props.forEach(map::removeProperty);
        return props;
    }

    @Override
    public Stream<Component> getChildren() {
        return super.getChildren();
    }

    static {
        UsageStatistics.markAsUsed("flow/PolymerTemplate", null);
    }
}

