/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.internal.nodefeature;

import com.vaadin.flow.dom.Element;
import com.vaadin.flow.dom.PropertyChangeEvent;
import com.vaadin.flow.dom.PropertyChangeListener;
import com.vaadin.flow.function.SerializablePredicate;
import com.vaadin.flow.internal.StateNode;
import com.vaadin.flow.internal.nodefeature.AbstractPropertyMap;
import com.vaadin.flow.internal.nodefeature.ElementData;
import com.vaadin.flow.internal.nodefeature.ModelList;
import com.vaadin.flow.internal.nodefeature.NodeFeature;
import com.vaadin.flow.internal.nodefeature.SynchronizedPropertiesList;
import com.vaadin.flow.shared.Registration;
import com.vaadin.flow.templatemodel.AllowClientUpdates;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ElementPropertyMap
extends AbstractPropertyMap {
    private static final Set<String> forbiddenProperties = Stream.of("textContent", "classList", "className").collect(Collectors.toSet());
    private Map<String, List<PropertyChangeListener>> listeners;
    private SerializablePredicate<String> updateFromClientFilter = null;

    public ElementPropertyMap(StateNode node) {
        super(node);
    }

    public Runnable deferredUpdateFromClient(String key, Serializable value) {
        if (!this.mayUpdateFromClient(key, value) && this.updateFromClientFilter != null && !this.updateFromClientFilter.test(key)) {
            ElementPropertyMap.getLogger().warn("Ignoring model update for {}. For security reasons, the property must have a two-way binding in the template, be annotated with @{} in the model, or be defined as synchronized.", (Object)key, (Object)AllowClientUpdates.class.getSimpleName());
            return () -> {};
        }
        return this.putWithDeferredChangeEvent(key, value, false);
    }

    @Override
    public void setProperty(String name, Serializable value, boolean emitChange) {
        assert (!forbiddenProperties.contains(name)) : "Forbidden property name: " + name;
        super.setProperty(name, value, emitChange);
    }

    public void setProperty(String name, Serializable value) {
        this.setProperty(name, value, true);
    }

    public Registration addPropertyChangeListener(String name, PropertyChangeListener listener) {
        List<PropertyChangeListener> propertyListeners;
        assert (this.hasElement());
        if (this.listeners == null) {
            propertyListeners = new ArrayList<PropertyChangeListener>(1);
            this.listeners = Collections.singletonMap(name, propertyListeners);
        } else {
            if (this.listeners.size() == 1 && !(this.listeners instanceof HashMap)) {
                this.listeners = new HashMap<String, List<PropertyChangeListener>>(this.listeners);
            }
            propertyListeners = this.listeners.computeIfAbsent(name, key -> new ArrayList(1));
        }
        propertyListeners.add(listener);
        return () -> propertyListeners.remove(listener);
    }

    @Override
    protected Serializable put(String key, Serializable value, boolean emitChange) {
        PutResult result = this.putWithDeferredChangeEvent(key, value, emitChange);
        result.run();
        return result.oldValue;
    }

    private PutResult putWithDeferredChangeEvent(String key, Serializable value, boolean emitChange) {
        boolean valueChanged;
        Serializable oldValue = super.put(key, value, emitChange);
        boolean bl = valueChanged = !Objects.equals(oldValue, value);
        if (valueChanged) {
            ElementPropertyMap.setFilterIfMapNode(oldValue, () -> null);
            ElementPropertyMap.setFilterIfMapNode(value, () -> this.createChildFilter(key));
        }
        PropertyChangeEvent event = this.hasElement() && valueChanged ? new PropertyChangeEvent(Element.get(this.getNode()), key, oldValue, !emitChange) : null;
        return new PutResult(oldValue, event);
    }

    @Override
    protected Serializable remove(String key) {
        Serializable oldValue = super.remove(key);
        this.fireEvent(new PropertyChangeEvent(Element.get(this.getNode()), key, oldValue, true));
        ElementPropertyMap.setFilterIfMapNode(oldValue, () -> null);
        return oldValue;
    }

    private SerializablePredicate<String> createChildFilter(String prefix) {
        return name -> {
            if (this.updateFromClientFilter == null) {
                return false;
            }
            return this.updateFromClientFilter.test(prefix + "." + name);
        };
    }

    private static void setFilterIfMapNode(Object maybeNode, Supplier<SerializablePredicate<String>> filterFactory) {
        StateNode node;
        if (maybeNode instanceof StateNode && (node = (StateNode)maybeNode).hasFeature(ElementPropertyMap.class)) {
            ElementPropertyMap.getModel(node).setUpdateFromClientFilter(filterFactory.get());
        }
    }

    @Override
    protected boolean mayUpdateFromClient(String key, Serializable value) {
        if (forbiddenProperties.contains(key)) {
            return false;
        }
        if (this.getNode().hasFeature(SynchronizedPropertiesList.class) && this.getNode().getFeature(SynchronizedPropertiesList.class).getSynchronizedProperties().contains(key)) {
            return true;
        }
        if (this.updateFromClientFilter != null) {
            return this.updateFromClientFilter.test(key);
        }
        return false;
    }

    public void setUpdateFromClientFilter(SerializablePredicate<String> updateFromClientFilter) {
        this.updateFromClientFilter = updateFromClientFilter;
    }

    private ElementPropertyMap getOrCreateModelMap(String key) {
        Serializable value = this.getProperty(key);
        if (value == null) {
            value = new StateNode(Collections.singletonList(ElementPropertyMap.class), new Class[0]);
            this.setProperty(key, value);
        }
        assert (value instanceof StateNode);
        assert (((StateNode)value).hasFeature(ElementPropertyMap.class));
        return ((StateNode)value).getFeature(ElementPropertyMap.class);
    }

    private ModelList getOrCreateModelList(String key) {
        Serializable value = this.getProperty(key);
        if (value == null) {
            value = new StateNode(Collections.singletonList(ModelList.class), new Class[0]);
            this.setProperty(key, value);
        }
        assert (value instanceof StateNode);
        assert (((StateNode)value).hasFeature(ModelList.class));
        return ((StateNode)value).getFeature(ModelList.class);
    }

    public ElementPropertyMap resolveModelMap(String modelPath) {
        if ("".equals(modelPath)) {
            return this;
        }
        return this.resolve(modelPath, ElementPropertyMap.class);
    }

    public ModelList resolveModelList(String modelPath) {
        return this.resolve(modelPath, ModelList.class);
    }

    private <T extends NodeFeature> T resolve(String modelPath, Class<T> leafType) {
        assert (modelPath != null);
        assert (!"".equals(modelPath));
        assert (!modelPath.startsWith("."));
        assert (!modelPath.endsWith("."));
        assert (leafType == ElementPropertyMap.class || leafType == ModelList.class);
        int dotLocation = modelPath.indexOf(46);
        if (dotLocation == -1) {
            if (leafType == ElementPropertyMap.class) {
                return (T)this.getOrCreateModelMap(modelPath);
            }
            return (T)this.getOrCreateModelList(modelPath);
        }
        String firstKey = modelPath.substring(0, dotLocation);
        String remainingPath = modelPath.substring(dotLocation + 1);
        ElementPropertyMap subMap = this.getOrCreateModelMap(firstKey);
        return subMap.resolve(remainingPath, leafType);
    }

    public static ElementPropertyMap getModel(StateNode node) {
        assert (node != null);
        return node.getFeature(ElementPropertyMap.class);
    }

    private void fireEvent(PropertyChangeEvent event) {
        if (this.listeners == null) {
            return;
        }
        List<PropertyChangeListener> propertyListeners = this.listeners.get(event.getPropertyName());
        if (propertyListeners != null && !propertyListeners.isEmpty()) {
            new ArrayList<PropertyChangeListener>(propertyListeners).forEach(listener -> listener.propertyChange(event));
        }
    }

    private boolean hasElement() {
        return this.getNode().hasFeature(ElementData.class);
    }

    private static Logger getLogger() {
        return LoggerFactory.getLogger(ElementPropertyMap.class);
    }

    private class PutResult
    implements Runnable {
        private final Serializable oldValue;
        private final PropertyChangeEvent eventToFire;

        public PutResult(Serializable oldValue, PropertyChangeEvent eventToFire) {
            this.oldValue = oldValue;
            this.eventToFire = eventToFire;
        }

        @Override
        public void run() {
            if (this.eventToFire != null) {
                ElementPropertyMap.this.fireEvent(this.eventToFire);
            }
        }
    }
}

