/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.osgi;

import com.vaadin.flow.server.osgi.OSGiAccess;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.servlet.ServletContainerInitializer;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.wiring.BundleWiring;
import org.osgi.util.tracker.BundleTracker;
import org.slf4j.LoggerFactory;

public class VaadinBundleTracker
extends BundleTracker<Bundle> {
    private final Bundle flowServerBundle;
    private Executor executor = Executors.newSingleThreadExecutor();

    public VaadinBundleTracker(BundleContext context) {
        super(context, 36, null);
        this.flowServerBundle = context.getBundle();
    }

    public Bundle addingBundle(Bundle bundle, BundleEvent event) {
        if ((bundle.getState() & 0x20) != 0) {
            if (this.flowServerBundle.equals(bundle)) {
                this.executor.execute(this::scanContextInitializers);
                this.executor.execute(this::scanActiveBundles);
            } else if ((this.flowServerBundle.getState() & 0x20) != 0) {
                this.executor.execute(() -> this.scanActivatedBundle(bundle));
            }
        } else if (event != null && (event.getType() & 4) > 0 && this.isVaadinExtender(bundle)) {
            OSGiAccess.getInstance().removeScannedClasses(bundle.getBundleId());
        }
        return bundle;
    }

    private void scanContextInitializers() {
        HashMap map = new HashMap();
        this.scanClasses(this.flowServerBundle, map, this::handleFlowServerClassError);
        Collection classes = (Collection)map.get(this.flowServerBundle.getBundleId());
        Predicate<Class> isInterface = Class::isInterface;
        Collection initializers = classes.stream().filter(ServletContainerInitializer.class::isAssignableFrom).filter(isInterface.negate()).map(clazz -> clazz).collect(Collectors.toList());
        OSGiAccess.getInstance().setServletContainerInitializers(initializers);
    }

    private void scanActivatedBundle(Bundle bundle) {
        if (!this.isActive(bundle) || !this.isVaadinExtender(bundle)) {
            return;
        }
        if (OSGiAccess.getInstance().hasInitializers()) {
            HashMap map = new HashMap();
            this.scanClasses(bundle, map, this::handleBundleClassError);
            OSGiAccess.getInstance().addScannedClasses(map);
        } else {
            this.executor.execute(() -> this.scanActivatedBundle(bundle));
        }
    }

    private void scanActiveBundles() {
        HashMap map = new HashMap();
        Stream.of(this.flowServerBundle.getBundleContext().getBundles()).filter(this::isActive).filter(this::isVaadinExtender).forEach(activeBundle -> this.scanClasses((Bundle)activeBundle, map, this::handleBundleClassError));
        OSGiAccess.getInstance().addScannedClasses(map);
    }

    private boolean isActive(Bundle bundle) {
        return (bundle.getState() & 0x20) > 0;
    }

    private boolean isVaadinExtender(Bundle bundle) {
        return !this.flowServerBundle.equals(bundle) && Boolean.TRUE.toString().equals(bundle.getHeaders().get("Vaadin-OSGi-Extender"));
    }

    private void handleFlowServerClassError(String className, Throwable throwable) {
        LoggerFactory.getLogger(VaadinBundleTracker.class).trace("Couldn't load class '{}'", (Object)className, (Object)throwable);
    }

    private void handleBundleClassError(String className, Throwable throwable) {
        LoggerFactory.getLogger(VaadinBundleTracker.class).warn("Couldn't load class '{}'", (Object)className, (Object)throwable);
    }

    private void scanClasses(Bundle bundle, Map<Long, Collection<Class<?>>> map, BiConsumer<String, Throwable> throwableHandler) {
        BundleWiring wiring = (BundleWiring)bundle.adapt(BundleWiring.class);
        Collection classes = wiring.listResources("/", "*.class", 1);
        ArrayList<Class> bundleClasses = new ArrayList<Class>();
        for (String clazz : classes) {
            String className = clazz.replaceAll("\\.class$", "").replace('/', '.');
            if ("module-info".equals(className)) continue;
            try {
                bundleClasses.add(bundle.loadClass(className));
            }
            catch (ClassNotFoundException | NoClassDefFoundError exception) {
                throwableHandler.accept(className, exception);
            }
        }
        map.put(bundle.getBundleId(), bundleClasses);
    }
}

