/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.startup;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.router.HasDynamicTitle;
import com.vaadin.flow.router.PageTitle;
import com.vaadin.flow.router.Route;
import com.vaadin.flow.router.RouteAlias;
import com.vaadin.flow.router.Router;
import com.vaadin.flow.router.RouterLayout;
import com.vaadin.flow.router.internal.RouterUtil;
import com.vaadin.flow.server.InvalidRouteLayoutConfigurationException;
import com.vaadin.flow.server.PWA;
import com.vaadin.flow.server.PageConfigurator;
import com.vaadin.flow.server.startup.AnnotationValidator;
import com.vaadin.flow.server.startup.DuplicateNavigationTitleException;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.servlet.annotation.HandlesTypes;

public abstract class AbstractRouteRegistryInitializer
implements Serializable {
    private Class<?> pwaClass = null;

    protected Set<Class<? extends Component>> validateRouteClasses(Stream<Class<?>> routeClasses) {
        return routeClasses.peek(this::checkForConflictingAnnotations).filter(this::isApplicableClass).map(clazz -> clazz).collect(Collectors.toSet());
    }

    private boolean isApplicableClass(Class<?> clazz) {
        return clazz.isAnnotationPresent(Route.class) && Component.class.isAssignableFrom(clazz);
    }

    private void checkForConflictingAnnotations(Class<?> route) {
        if (route.isAnnotationPresent(RouteAlias.class) && !route.isAnnotationPresent(Route.class)) {
            throw new InvalidRouteLayoutConfigurationException(String.format("'%s' declares '@%s' but doesn't declare '@%s'. The '%s' may not be used without '%s'", route.getCanonicalName(), RouteAlias.class.getSimpleName(), Route.class.getSimpleName(), RouteAlias.class.getSimpleName(), Route.class.getSimpleName()));
        }
        if (route.isAnnotationPresent(PageTitle.class) && HasDynamicTitle.class.isAssignableFrom(route)) {
            throw new DuplicateNavigationTitleException(String.format("'%s' has a PageTitle annotation, but also implements HasDynamicTitle.", route.getName()));
        }
        Stream.of(AnnotationValidator.class.getAnnotation(HandlesTypes.class).value()).forEach(type -> {
            Class<Annotation> annotation = type.asSubclass(Annotation.class);
            this.validateRouteAnnotation(route, annotation);
            for (RouteAlias alias : (RouteAlias[])route.getAnnotationsByType(RouteAlias.class)) {
                this.validateRouteAliasAnnotation(route, alias, annotation);
            }
        });
        this.validateRouteImplementation(route, PageConfigurator.class);
        for (RouteAlias alias : (RouteAlias[])route.getAnnotationsByType(RouteAlias.class)) {
            this.validateRouteAliasImplementation(route, alias, PageConfigurator.class);
        }
    }

    private void validateRouteImplementation(Class<?> route, Class<?> implementation) {
        Route annotation = route.getAnnotation(Route.class);
        if (!UI.class.equals(annotation.layout())) {
            if (implementation.isAssignableFrom(route)) {
                throw new InvalidRouteLayoutConfigurationException(String.format("%s needs to be the top parent layout '%s' not '%s'", implementation.getSimpleName(), RouterUtil.getTopParentLayout(route, Router.resolve(route, annotation)).getName(), route.getName()));
            }
            List<Class<? extends RouterLayout>> parentLayouts = RouterUtil.getParentLayouts(route, Router.resolve(route, annotation));
            Class<? extends RouterLayout> topParentLayout = RouterUtil.getTopParentLayout(route, Router.resolve(route, annotation));
            this.validateParentImplementation(parentLayouts, topParentLayout, implementation);
        }
    }

    private void validateRouteAliasImplementation(Class<?> route, RouteAlias alias, Class<?> implementation) {
        if (!UI.class.equals(alias.layout())) {
            if (PageConfigurator.class.isAssignableFrom(route)) {
                throw new InvalidRouteLayoutConfigurationException(String.format("%s needs to be the top parent layout '%s' not '%s'", implementation.getSimpleName(), RouterUtil.getTopParentLayout(route, alias.value()).getName(), route.getName()));
            }
            List<Class<? extends RouterLayout>> parentLayouts = RouterUtil.getParentLayouts(route, alias.value());
            Class<? extends RouterLayout> topParentLayout = RouterUtil.getTopParentLayout(route, alias.value());
            this.validateParentImplementation(parentLayouts, topParentLayout, implementation);
        }
    }

    private void validateParentImplementation(List<Class<? extends RouterLayout>> parentLayouts, Class<? extends RouterLayout> topParentLayout, Class<?> implementation) {
        Supplier<Stream> streamSupplier = () -> parentLayouts.stream().filter(implementation::isAssignableFrom);
        if (streamSupplier.get().count() > 1L) {
            throw new InvalidRouteLayoutConfigurationException("Only one " + implementation.getSimpleName() + " implementation is supported for navigation chain and should be on the top most level. Offending classes in chain: " + streamSupplier.get().map(Class::getName).collect(Collectors.joining(", ")));
        }
        streamSupplier.get().findFirst().ifPresent(layout -> {
            if (!layout.equals(topParentLayout)) {
                throw new InvalidRouteLayoutConfigurationException(String.format("%s implementation should be the top most route layout '%s'. Offending class: '%s'", implementation.getSimpleName(), topParentLayout.getName(), layout.getName()));
            }
        });
    }

    private void validateRouteAnnotation(Class<?> route, Class<? extends Annotation> annotation) {
        Route routeAnnotation = route.getAnnotation(Route.class);
        if (!UI.class.equals(routeAnnotation.layout())) {
            if (route.isAnnotationPresent(annotation)) {
                throw new InvalidRouteLayoutConfigurationException(String.format("%s annotation needs to be on the top parent layout '%s' not on '%s'", annotation.getSimpleName(), RouterUtil.getTopParentLayout(route, Router.resolve(route, routeAnnotation)).getName(), route.getName()));
            }
            List<Class<? extends RouterLayout>> parentLayouts = RouterUtil.getParentLayouts(route, Router.resolve(route, routeAnnotation));
            Class<? extends RouterLayout> topParentLayout = RouterUtil.getTopParentLayout(route, Router.resolve(route, routeAnnotation));
            this.validateParentAnnotation(parentLayouts, topParentLayout, annotation);
        }
    }

    private void validateRouteAliasAnnotation(Class<?> route, RouteAlias alias, Class<? extends Annotation> annotation) {
        if (!UI.class.equals(alias.layout())) {
            if (route.isAnnotationPresent(annotation)) {
                throw new InvalidRouteLayoutConfigurationException(String.format("%s annotation needs to be on the top parent layout '%s' not on '%s'", annotation.getSimpleName(), RouterUtil.getTopParentLayout(route, alias.value()).getName(), route.getName()));
            }
            List<Class<? extends RouterLayout>> parentLayouts = RouterUtil.getParentLayouts(route, alias.value());
            Class<? extends RouterLayout> topParentLayout = RouterUtil.getTopParentLayout(route, alias.value());
            this.validateParentAnnotation(parentLayouts, topParentLayout, annotation);
        }
    }

    private void validateParentAnnotation(List<Class<? extends RouterLayout>> parentLayouts, Class<? extends RouterLayout> topParentLayout, Class<? extends Annotation> annotation) {
        Supplier<Stream> streamSupplier = () -> parentLayouts.stream().filter(layout -> layout.isAnnotationPresent(annotation));
        if (streamSupplier.get().count() > 1L) {
            throw new InvalidRouteLayoutConfigurationException("Only one " + annotation.getSimpleName() + " annotation is supported for navigation chain and should be on the top most level. Offending classes in chain: " + streamSupplier.get().map(Class::getName).collect(Collectors.joining(", ")));
        }
        streamSupplier.get().findFirst().ifPresent(layout -> {
            if (!layout.equals(topParentLayout)) {
                throw new InvalidRouteLayoutConfigurationException(String.format("%s annotation should be on the top most route layout '%s'. Offending class: '%s'", annotation.getSimpleName(), topParentLayout.getName(), layout.getName()));
            }
        });
    }

    protected Class<?> validatePwaClass(Stream<Class<?>> routeClasses) {
        this.pwaClass = null;
        routeClasses.forEach(route -> {
            this.validatePwa((Class<?>)route);
            Route routeAnnotation = route.getAnnotation(Route.class);
            if (!UI.class.equals(routeAnnotation.layout())) {
                Class<? extends RouterLayout> topParentLayout = RouterUtil.getTopParentLayout(route, Router.resolve(route, routeAnnotation));
                this.validatePwa(topParentLayout);
            }
        });
        return this.pwaClass;
    }

    private void validatePwa(Class<?> pwaClassCandidate) {
        if (pwaClassCandidate == null || !pwaClassCandidate.isAnnotationPresent(PWA.class)) {
            return;
        }
        if (this.pwaClass != null && this.pwaClass != pwaClassCandidate) {
            throw new InvalidRouteLayoutConfigurationException(String.format("Expected only one '%s' annotation that is placed on the main layout of the application. Got multiple annotations in '%s' and '%s'", PWA.class.getSimpleName(), this.pwaClass.getSimpleName(), pwaClassCandidate.getSimpleName()));
        }
        this.pwaClass = pwaClassCandidate;
    }
}

