/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.router;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.router.ErrorNavigationEvent;
import com.vaadin.flow.router.ErrorParameter;
import com.vaadin.flow.router.HasUrlParameter;
import com.vaadin.flow.router.Location;
import com.vaadin.flow.router.NavigationEvent;
import com.vaadin.flow.router.NavigationState;
import com.vaadin.flow.router.NavigationStateBuilder;
import com.vaadin.flow.router.NavigationTrigger;
import com.vaadin.flow.router.NotFoundException;
import com.vaadin.flow.router.OptionalParameter;
import com.vaadin.flow.router.ParameterDeserializer;
import com.vaadin.flow.router.QueryParameters;
import com.vaadin.flow.router.Route;
import com.vaadin.flow.router.RouteData;
import com.vaadin.flow.router.RouteResolver;
import com.vaadin.flow.router.RouterLayout;
import com.vaadin.flow.router.WildcardParameter;
import com.vaadin.flow.router.internal.DefaultRouteResolver;
import com.vaadin.flow.router.internal.ErrorStateRenderer;
import com.vaadin.flow.router.internal.InternalRedirectHandler;
import com.vaadin.flow.router.internal.NavigationStateRenderer;
import com.vaadin.flow.router.internal.ResolveRequest;
import com.vaadin.flow.server.VaadinRequest;
import com.vaadin.flow.server.VaadinResponse;
import com.vaadin.flow.server.VaadinService;
import com.vaadin.flow.server.startup.RouteRegistry;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.lang.annotation.Annotation;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.slf4j.LoggerFactory;

public class Router
implements Serializable {
    private static final Pattern PARAMETER_PATTERN = Pattern.compile("/\\{[\\s\\S]*}");
    private RouteResolver routeResolver;
    private final RouteRegistry registry;

    public Router(RouteRegistry registry) {
        assert (registry != null);
        this.registry = registry;
        this.routeResolver = new DefaultRouteResolver();
    }

    public void initializeUI(UI ui, VaadinRequest initRequest) {
        Location location = this.getLocationForRequest(initRequest.getPathInfo(), initRequest.getParameterMap());
        ui.getPage().getHistory().setHistoryStateChangeHandler(e -> this.navigate(ui, e.getLocation(), e.getTrigger()));
        int statusCode = this.navigate(ui, location, NavigationTrigger.PAGE_LOAD);
        VaadinResponse response = VaadinService.getCurrentResponse();
        if (response != null) {
            response.setStatus(statusCode);
        }
    }

    private Location getLocationForRequest(String pathInfo, Map<String, String[]> parameterMap) {
        String path;
        if (pathInfo == null) {
            path = "";
        } else {
            assert (pathInfo.startsWith("/"));
            path = pathInfo.substring(1);
        }
        QueryParameters queryParameters = QueryParameters.full(parameterMap);
        try {
            return new Location(path, queryParameters);
        }
        catch (IllegalArgumentException iae) {
            LoggerFactory.getLogger((String)Router.class.getName()).warn("Exception when parsing location path {}", (Object)path, (Object)iae);
            String encodedPath = path.substring(0, path.indexOf(63));
            try {
                encodedPath = path.startsWith("/") ? URLEncoder.encode(path.substring(1), StandardCharsets.UTF_8.name()) : URLEncoder.encode(path, StandardCharsets.UTF_8.name());
            }
            catch (UnsupportedEncodingException e) {
                LoggerFactory.getLogger((String)Router.class.getName()).warn("Exception when encoding path {}", (Object)path, (Object)e);
            }
            return new Location(encodedPath);
        }
    }

    public Optional<NavigationState> resolveNavigationTarget(String pathInfo, Map<String, String[]> parameterMap) {
        Location location = this.getLocationForRequest(pathInfo, parameterMap);
        NavigationState resolve = null;
        try {
            resolve = this.getRouteResolver().resolve(new ResolveRequest(this, location));
        }
        catch (NotFoundException nfe) {
            LoggerFactory.getLogger((String)Router.class.getName()).warn("Failed to resolve navigation target for path: {}", (Object)pathInfo, (Object)nfe);
        }
        return Optional.ofNullable(resolve);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int navigate(UI ui, Location location, NavigationTrigger trigger) {
        assert (ui != null);
        assert (location != null);
        assert (trigger != null);
        ui.getSession().checkHasLock();
        if (this.handleNavigationForLocation(ui, location)) {
            ui.getInternals().setLastHandledNavigation(location);
            try {
                int n = this.handleNavigation(ui, location, trigger);
                return n;
            }
            catch (Exception exception) {
                int n = this.handleExceptionNavigation(ui, location, exception, trigger);
                return n;
            }
            finally {
                ui.getInternals().clearLastHandledNavigation();
            }
        }
        return 304;
    }

    private boolean handleNavigationForLocation(UI ui, Location location) {
        if (ui.getInternals().hasLastHandledLocation()) {
            return !location.getPathWithQueryParameters().equals(ui.getInternals().getLastHandledLocation().getPathWithQueryParameters());
        }
        return true;
    }

    private int handleNavigation(UI ui, Location location, NavigationTrigger trigger) {
        NavigationState newState = this.getRouteResolver().resolve(new ResolveRequest(this, location));
        if (newState != null) {
            NavigationEvent navigationEvent = new NavigationEvent(this, location, ui, trigger);
            NavigationStateRenderer handler = new NavigationStateRenderer(newState);
            return handler.handle(navigationEvent);
        }
        if (!location.getPath().isEmpty()) {
            Location slashToggledLocation = location.toggleTrailingSlash();
            NavigationState slashToggledState = this.getRouteResolver().resolve(new ResolveRequest(this, slashToggledLocation));
            if (slashToggledState != null) {
                NavigationEvent navigationEvent = new NavigationEvent(this, slashToggledLocation, ui, trigger);
                InternalRedirectHandler handler = new InternalRedirectHandler(slashToggledLocation);
                return handler.handle(navigationEvent);
            }
        }
        throw new NotFoundException("Couldn't find route for '" + location.getPath() + "'");
    }

    private int handleExceptionNavigation(UI ui, Location location, Exception exception, NavigationTrigger trigger) {
        Optional<RouteRegistry.ErrorTargetEntry> maybeLookupResult = this.getRegistry().getErrorNavigationTarget(exception);
        if (maybeLookupResult.isPresent()) {
            RouteRegistry.ErrorTargetEntry lookupResult = maybeLookupResult.get();
            ErrorParameter<? extends Exception> errorParameter = new ErrorParameter<Exception>(lookupResult.getHandledExceptionType(), exception, exception.getMessage());
            ErrorStateRenderer handler = new ErrorStateRenderer(new NavigationStateBuilder().withTarget(lookupResult.getNavigationTarget()).build());
            ErrorNavigationEvent navigationEvent = new ErrorNavigationEvent(this, location, ui, trigger, errorParameter);
            return handler.handle(navigationEvent);
        }
        throw new RuntimeException(exception);
    }

    private RouteResolver getRouteResolver() {
        return this.routeResolver;
    }

    public String getUrl(Class<? extends Component> navigationTarget) {
        String routeString = this.getUrlForTarget(navigationTarget);
        if (this.isAnnotatedParameter(navigationTarget, OptionalParameter.class, WildcardParameter.class)) {
            routeString = PARAMETER_PATTERN.matcher(routeString).replaceAll("");
        } else if (HasUrlParameter.class.isAssignableFrom(navigationTarget)) {
            String message = String.format("Navigation target '%s' requires a parameter and can not be resolved. Use 'public <T, C extends Component & HasUrlParameter<T>> String getUrl(Class<? extends C> navigationTarget, T parameter)' instead", navigationTarget.getName());
            throw new IllegalArgumentException(message);
        }
        return this.trimRouteString(routeString);
    }

    public String getUrlBase(Class<? extends Component> navigationTarget) {
        String routeString = this.getUrlForTarget(navigationTarget);
        return this.trimRouteString(PARAMETER_PATTERN.matcher(routeString).replaceAll(""));
    }

    private String trimRouteString(String routeString) {
        if (routeString.startsWith("/")) {
            routeString = routeString.substring(1);
        }
        return routeString;
    }

    @SafeVarargs
    private final boolean isAnnotatedParameter(Class<? extends Component> navigationTarget, Class<? extends Annotation> ... parameterAnnotations) {
        for (Class<? extends Annotation> annotation : parameterAnnotations) {
            if (!ParameterDeserializer.isAnnotatedParameter(navigationTarget, annotation)) continue;
            return true;
        }
        return false;
    }

    public <T, C extends Component> String getUrl(Class<? extends C> navigationTarget, T parameter) {
        if (parameter == null) {
            return this.getUrl(navigationTarget);
        }
        return this.getUrl(navigationTarget, Collections.singletonList(parameter));
    }

    public <T, C extends Component> String getUrl(Class<? extends C> navigationTarget, List<T> parameters) {
        List<String> serializedParameters = this.serializeUrlParameters(Objects.requireNonNull(parameters));
        String routeString = this.getUrlForTarget(navigationTarget);
        if (!parameters.isEmpty()) {
            routeString = routeString.replace("{" + parameters.get(0).getClass().getSimpleName() + "}", serializedParameters.stream().collect(Collectors.joining("/")));
        } else if (ParameterDeserializer.isAnnotatedParameter(navigationTarget, OptionalParameter.class) || ParameterDeserializer.isAnnotatedParameter(navigationTarget, WildcardParameter.class)) {
            routeString = PARAMETER_PATTERN.matcher(routeString).replaceAll("");
        } else {
            throw new NotFoundException(String.format("The navigation target '%s' has a non optional parameter that needs to be given.", navigationTarget.getName()));
        }
        Optional<Class<? extends Component>> registryTarget = this.getRegistry().getNavigationTarget(routeString, serializedParameters);
        if (registryTarget.isPresent() && !this.hasUrlParameters(registryTarget.get()) && !registryTarget.get().equals(navigationTarget)) {
            throw new NotFoundException(String.format("Url matches existing navigation target '%s' with higher priority.", registryTarget.get().getName()));
        }
        return this.trimRouteString(routeString);
    }

    private String getUrlForTarget(Class<? extends Component> navigationTarget) throws NotFoundException {
        Optional<String> targetUrl = this.getRegistry().getTargetUrl(navigationTarget);
        if (!targetUrl.isPresent()) {
            throw new NotFoundException("No route found for given navigation target!");
        }
        return targetUrl.get();
    }

    private boolean hasUrlParameters(Class<? extends Component> navigationTarget) {
        return HasUrlParameter.class.isAssignableFrom(navigationTarget);
    }

    private <T> List<String> serializeUrlParameters(List<T> urlParameters) {
        return urlParameters.stream().filter(Objects::nonNull).map(Object::toString).collect(Collectors.toList());
    }

    public RouteRegistry getRegistry() {
        return this.registry;
    }

    public List<RouteData> getRoutes() {
        return Collections.unmodifiableList(this.getRegistry().getRegisteredRoutes());
    }

    public Map<Class<? extends RouterLayout>, List<RouteData>> getRoutesByParent() {
        HashMap<Class<? extends RouterLayout>, List<RouteData>> grouped = new HashMap<Class<? extends RouterLayout>, List<RouteData>>();
        for (RouteData route : this.getRoutes()) {
            List routeDataList = grouped.computeIfAbsent(route.getParentLayout(), key -> new ArrayList());
            routeDataList.add(route);
        }
        return grouped;
    }

    public static String resolve(Class<?> component, Route route) {
        if (route.value().equals("___NAMING_CONVENTION___")) {
            String simpleName = component.getSimpleName();
            if ("MainView".equals(simpleName) || "Main".equals(simpleName)) {
                return "";
            }
            if (simpleName.endsWith("View")) {
                return simpleName.substring(0, simpleName.length() - "View".length()).toLowerCase();
            }
            return simpleName.toLowerCase();
        }
        return route.value();
    }
}

