/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.router.internal;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.HasElement;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.di.Instantiator;
import com.vaadin.flow.internal.ReflectTools;
import com.vaadin.flow.router.AfterNavigationEvent;
import com.vaadin.flow.router.BeforeEnterEvent;
import com.vaadin.flow.router.BeforeEvent;
import com.vaadin.flow.router.BeforeLeaveEvent;
import com.vaadin.flow.router.ErrorNavigationEvent;
import com.vaadin.flow.router.ErrorParameter;
import com.vaadin.flow.router.EventUtil;
import com.vaadin.flow.router.Location;
import com.vaadin.flow.router.LocationChangeEvent;
import com.vaadin.flow.router.NavigationEvent;
import com.vaadin.flow.router.NavigationHandler;
import com.vaadin.flow.router.NavigationState;
import com.vaadin.flow.router.NavigationTrigger;
import com.vaadin.flow.router.Route;
import com.vaadin.flow.router.Router;
import com.vaadin.flow.router.RouterLayout;
import com.vaadin.flow.router.internal.AfterNavigationHandler;
import com.vaadin.flow.router.internal.BeforeEnterHandler;
import com.vaadin.flow.router.internal.BeforeLeaveHandler;
import com.vaadin.flow.router.internal.Postpone;
import com.vaadin.flow.router.internal.RouterUtil;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import java.util.Optional;
import javax.servlet.http.HttpServletResponse;

public abstract class AbstractNavigationStateRenderer
implements NavigationHandler {
    private static List<Integer> statusCodes = ReflectTools.getConstantIntValues(HttpServletResponse.class);
    private final NavigationState navigationState;
    private Postpone postponed = null;

    public AbstractNavigationStateRenderer(NavigationState navigationState) {
        this.navigationState = navigationState;
    }

    public NavigationState getNavigationState() {
        return this.navigationState;
    }

    static <T extends HasElement> T getRouteTarget(Class<T> routeTargetType, NavigationEvent event) {
        UI ui = event.getUI();
        Optional<HasElement> currentInstance = ui.getInternals().getActiveRouterTargetsChain().stream().filter(component -> component.getClass().equals(routeTargetType)).findAny();
        return (T)currentInstance.orElseGet(() -> Instantiator.get(ui).createRouteTarget(routeTargetType, event));
    }

    @Override
    public int handle(NavigationEvent event) {
        UI ui = event.getUI();
        Class<? extends Component> routeTargetType = this.navigationState.getNavigationTarget();
        List<Class<? extends RouterLayout>> routeLayoutTypes = this.getRouterLayoutTypes(routeTargetType);
        assert (routeTargetType != null);
        assert (routeLayoutTypes != null);
        this.clearContinueNavigationAction(ui);
        RouterUtil.checkForDuplicates(routeTargetType, routeLayoutTypes);
        if (this.eventActionsSupported()) {
            Object transitionOutcome;
            Deque<BeforeLeaveHandler> leaveHandlers;
            BeforeLeaveEvent beforeNavigationDeactivating = new BeforeLeaveEvent(event, routeTargetType);
            if (this.postponed != null) {
                leaveHandlers = this.postponed.getLeaveObservers();
                if (!leaveHandlers.isEmpty()) {
                    this.postponed = null;
                }
            } else {
                ArrayList<BeforeLeaveHandler> beforeLeaveHandlers = new ArrayList<BeforeLeaveHandler>(ui.getNavigationListeners(BeforeLeaveHandler.class));
                beforeLeaveHandlers.addAll(EventUtil.collectBeforeLeaveObservers(ui));
                leaveHandlers = new ArrayDeque<BeforeLeaveHandler>(beforeLeaveHandlers);
            }
            if ((transitionOutcome = this.executeBeforeLeaveNavigation(beforeNavigationDeactivating, leaveHandlers)) == TransitionOutcome.REROUTED) {
                return this.reroute(event, beforeNavigationDeactivating);
            }
            if (transitionOutcome == TransitionOutcome.POSTPONED) {
                BeforeLeaveEvent.ContinueNavigationAction currentAction = beforeNavigationDeactivating.getContinueNavigationAction();
                currentAction.setReferences(this, event);
                this.storeContinueNavigationAction(ui, currentAction);
                return 200;
            }
        }
        Component componentInstance = AbstractNavigationStateRenderer.getRouteTarget(routeTargetType, event);
        ArrayList<HasElement> chain = new ArrayList<HasElement>();
        chain.add(componentInstance);
        for (Class<? extends RouterLayout> parentType : routeLayoutTypes) {
            chain.add(AbstractNavigationStateRenderer.getRouteTarget(parentType, event));
        }
        BeforeEnterEvent beforeNavigationActivating = new BeforeEnterEvent(event, routeTargetType);
        LocationChangeEvent locationChangeEvent = RouterUtil.createEvent(event, chain);
        this.notifyNavigationTarget(componentInstance, event, beforeNavigationActivating, locationChangeEvent);
        if (beforeNavigationActivating.hasRerouteTarget()) {
            return this.reroute(event, beforeNavigationActivating);
        }
        List<RouterLayout> routerLayouts = chain.subList(1, chain.size());
        ArrayList<BeforeEnterHandler> enterHandlers = new ArrayList<BeforeEnterHandler>(ui.getNavigationListeners(BeforeEnterHandler.class));
        enterHandlers.addAll(EventUtil.collectBeforeEnterObservers(ui.getInternals().getActiveRouterTargetsChain(), chain));
        TransitionOutcome transitionOutcome = this.executeBeforeEnterNavigation(beforeNavigationActivating, enterHandlers);
        if (this.eventActionsSupported() && TransitionOutcome.REROUTED.equals((Object)transitionOutcome)) {
            return this.reroute(event, beforeNavigationActivating);
        }
        ui.getInternals().showRouteTarget(event.getLocation(), this.navigationState.getResolvedPath(), componentInstance, routerLayouts);
        RouterUtil.updatePageTitle(event, componentInstance);
        int statusCode = locationChangeEvent.getStatusCode();
        AbstractNavigationStateRenderer.validateStatusCode(statusCode, routeTargetType);
        ArrayList<AfterNavigationHandler> afterNavigationHandlers = new ArrayList<AfterNavigationHandler>(ui.getNavigationListeners(AfterNavigationHandler.class));
        afterNavigationHandlers.addAll(EventUtil.collectAfterNavigationObservers(ui));
        this.fireAfterNavigationListeners(new AfterNavigationEvent(locationChangeEvent), afterNavigationHandlers);
        return statusCode;
    }

    protected abstract void notifyNavigationTarget(Component var1, NavigationEvent var2, BeforeEnterEvent var3, LocationChangeEvent var4);

    protected abstract List<Class<? extends RouterLayout>> getRouterLayoutTypes(Class<? extends Component> var1);

    protected abstract boolean eventActionsSupported();

    private void clearContinueNavigationAction(UI ui) {
        this.storeContinueNavigationAction(ui, null);
    }

    private void storeContinueNavigationAction(UI ui, BeforeLeaveEvent.ContinueNavigationAction currentAction) {
        BeforeLeaveEvent.ContinueNavigationAction previousAction = ui.getInternals().getContinueNavigationAction();
        if (previousAction != null && previousAction != currentAction) {
            previousAction.setReferences(null, null);
        }
        ui.getInternals().setContinueNavigationAction(currentAction);
    }

    private void fireAfterNavigationListeners(AfterNavigationEvent event, List<AfterNavigationHandler> afterNavigationHandlers) {
        afterNavigationHandlers.forEach(listener -> listener.afterNavigation(event));
    }

    private TransitionOutcome executeBeforeLeaveNavigation(BeforeLeaveEvent beforeNavigation, Deque<BeforeLeaveHandler> leaveHandlers) {
        while (!leaveHandlers.isEmpty()) {
            BeforeLeaveHandler listener = leaveHandlers.remove();
            listener.beforeLeave(beforeNavigation);
            if (beforeNavigation.hasRerouteTarget()) {
                return TransitionOutcome.REROUTED;
            }
            if (!beforeNavigation.isPostponed()) continue;
            this.postponed = Postpone.withLeaveObservers(leaveHandlers);
            return TransitionOutcome.POSTPONED;
        }
        return TransitionOutcome.FINISHED;
    }

    private TransitionOutcome executeBeforeEnterNavigation(BeforeEnterEvent beforeNavigation, List<BeforeEnterHandler> enterHandlers) {
        for (BeforeEnterHandler eventHandler : enterHandlers) {
            eventHandler.beforeEnter(beforeNavigation);
            if (!beforeNavigation.hasRerouteTarget()) continue;
            return TransitionOutcome.REROUTED;
        }
        return TransitionOutcome.FINISHED;
    }

    private int reroute(NavigationEvent event, BeforeEvent beforeNavigation) {
        NavigationHandler handler = beforeNavigation.getRerouteTarget();
        NavigationEvent newNavigationEvent = this.getNavigationEvent(event, beforeNavigation);
        return handler.handle(newNavigationEvent);
    }

    private NavigationEvent getNavigationEvent(NavigationEvent event, BeforeEvent beforeNavigation) {
        if (beforeNavigation.hasErrorParameter()) {
            ErrorParameter<?> errorParameter = beforeNavigation.getErrorParameter();
            return new ErrorNavigationEvent(event.getSource(), event.getLocation(), event.getUI(), NavigationTrigger.PROGRAMMATIC, errorParameter);
        }
        Class<?> routeTargetType = beforeNavigation.getRouteTargetType();
        Location location = new Location(Router.resolve(routeTargetType, routeTargetType.getAnnotation(Route.class)));
        return new NavigationEvent(event.getSource(), location, event.getUI(), NavigationTrigger.PROGRAMMATIC);
    }

    private static void validateStatusCode(int statusCode, Class<? extends Component> targetClass) {
        if (!statusCodes.contains(statusCode)) {
            String msg = String.format("Error state code must be a valid HttpServletResponse value. Received invalid value of '%s' for '%s'", statusCode, targetClass.getName());
            throw new IllegalStateException(msg);
        }
    }

    private static enum TransitionOutcome {
        FINISHED,
        REROUTED,
        POSTPONED;

    }
}

