/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.communication;

import com.vaadin.flow.component.UI;
import com.vaadin.flow.internal.StateNode;
import com.vaadin.flow.server.ErrorEvent;
import com.vaadin.flow.server.NoInputStreamException;
import com.vaadin.flow.server.NoOutputStreamException;
import com.vaadin.flow.server.StreamReceiver;
import com.vaadin.flow.server.StreamVariable;
import com.vaadin.flow.server.UploadException;
import com.vaadin.flow.server.VaadinRequest;
import com.vaadin.flow.server.VaadinResponse;
import com.vaadin.flow.server.VaadinSession;
import com.vaadin.flow.server.communication.streaming.StreamingEndEventImpl;
import com.vaadin.flow.server.communication.streaming.StreamingErrorEventImpl;
import com.vaadin.flow.server.communication.streaming.StreamingProgressEventImpl;
import com.vaadin.flow.server.communication.streaming.StreamingStartEventImpl;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.fileupload.FileItemIterator;
import org.apache.commons.fileupload.FileItemStream;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamReceiverHandler
implements Serializable {
    private static final int MAX_UPLOAD_BUFFER_SIZE = 4096;
    public static final int DEFAULT_STREAMING_PROGRESS_EVENT_INTERVAL_MS = 500;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleRequest(VaadinSession session, VaadinRequest request, VaadinResponse response, StreamReceiver streamReceiver, String uiId, String securityKey) throws IOException {
        StateNode source;
        session.lock();
        try {
            String secKey = streamReceiver.getId();
            if (secKey == null || !secKey.equals(securityKey)) {
                StreamReceiverHandler.getLogger().warn("Received incoming stream with faulty security key.");
                return;
            }
            UI ui = session.getUIById(Integer.parseInt(uiId));
            UI.setCurrent(ui);
            source = streamReceiver.getNode();
        }
        finally {
            session.unlock();
        }
        try {
            if (ServletFileUpload.isMultipartContent((HttpServletRequest)((HttpServletRequest)request))) {
                this.doHandleMultipartFileUpload(session, request, response, streamReceiver, source);
            } else {
                this.doHandleXhrFilePost(session, request, response, streamReceiver, source, this.getContentLength(request));
            }
        }
        finally {
            UI.setCurrent(null);
        }
    }

    protected void doHandleMultipartFileUpload(VaadinSession session, VaadinRequest request, VaadinResponse response, StreamReceiver streamReceiver, StateNode owner) throws IOException {
        ServletFileUpload upload = new ServletFileUpload();
        long contentLength = this.getContentLength(request);
        try {
            FileItemIterator iter = upload.getItemIterator((HttpServletRequest)request);
            while (iter.hasNext()) {
                FileItemStream item = iter.next();
                this.handleStream(session, streamReceiver, owner, contentLength, item);
            }
        }
        catch (FileUploadException e) {
            StreamReceiverHandler.getLogger().warn("File upload failed.", (Throwable)e);
        }
        this.sendUploadResponse(response);
    }

    private void handleStream(VaadinSession session, StreamReceiver streamReceiver, StateNode owner, long contentLength, FileItemStream item) throws IOException {
        String name = item.getName();
        InputStream stream = item.openStream();
        try {
            this.handleFileUploadValidationAndData(session, stream, streamReceiver, name, item.getContentType(), contentLength, owner);
        }
        catch (UploadException e) {
            session.getErrorHandler().error(new ErrorEvent(e));
        }
    }

    protected void doHandleXhrFilePost(VaadinSession session, VaadinRequest request, VaadinResponse response, StreamReceiver streamReceiver, StateNode owner, long contentLength) throws IOException {
        String filename = "unknown";
        String mimeType = "unknown";
        InputStream stream = request.getInputStream();
        try {
            this.handleFileUploadValidationAndData(session, stream, streamReceiver, "unknown", "unknown", contentLength, owner);
        }
        catch (UploadException e) {
            session.getErrorHandler().error(new ErrorEvent(e));
        }
        this.sendUploadResponse(response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleFileUploadValidationAndData(VaadinSession session, InputStream inputStream, StreamReceiver streamReceiver, String filename, String mimeType, long contentLength, StateNode node) throws UploadException {
        session.lock();
        try {
            if (node == null) {
                throw new UploadException("File upload ignored because the node for the stream variable was not found");
            }
            if (!node.isAttached()) {
                throw new UploadException("Warning: file upload ignored for " + node.getId() + " because the component was disabled");
            }
        }
        finally {
            session.unlock();
        }
        try {
            boolean forgetVariable = this.streamToReceiver(session, inputStream, streamReceiver, filename, mimeType, contentLength);
            if (forgetVariable) {
                this.cleanStreamVariable(session, streamReceiver);
            }
        }
        catch (Exception e) {
            session.lock();
            try {
                session.getErrorHandler().error(new ErrorEvent(e));
            }
            finally {
                session.unlock();
            }
        }
    }

    protected int getProgressEventInterval() {
        return 500;
    }

    static void tryToCloseStream(OutputStream out) {
        try {
            if (out != null) {
                out.close();
            }
        }
        catch (IOException ioe) {
            StreamReceiverHandler.getLogger().debug("Exception closing stream", (Throwable)ioe);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendUploadResponse(VaadinResponse response) throws IOException {
        response.setContentType("text/html; charset=utf-8");
        try (OutputStream out = response.getOutputStream();){
            PrintWriter outWriter = new PrintWriter(new BufferedWriter(new OutputStreamWriter(out, StandardCharsets.UTF_8)));
            try {
                outWriter.print("<html><body>download handled</body></html>");
            }
            finally {
                outWriter.flush();
            }
        }
    }

    private void cleanStreamVariable(VaadinSession session, StreamReceiver streamReceiver) {
        session.lock();
        try {
            session.getResourceRegistry().unregisterResource(streamReceiver);
        }
        finally {
            session.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean streamToReceiver(VaadinSession session, InputStream in, StreamReceiver streamReceiver, String filename, String type, long contentLength) throws UploadException {
        StreamVariable streamVariable = streamReceiver.getStreamVariable();
        if (streamVariable == null) {
            throw new IllegalStateException("StreamVariable for the post not found");
        }
        OutputStream out = null;
        long totalBytes = 0L;
        StreamingStartEventImpl startedEvent = new StreamingStartEventImpl(filename, type, contentLength);
        try {
            int bytesReadToBuffer;
            boolean listenProgress;
            session.lock();
            try {
                streamVariable.streamingStarted(startedEvent);
                out = streamVariable.getOutputStream();
                listenProgress = streamVariable.listenProgress();
            }
            finally {
                session.unlock();
            }
            if (out == null) {
                throw new NoOutputStreamException();
            }
            if (null == in) {
                throw new NoInputStreamException();
            }
            byte[] buffer = new byte[4096];
            long lastStreamingEvent = 0L;
            do {
                if ((bytesReadToBuffer = in.read(buffer)) > 0) {
                    out.write(buffer, 0, bytesReadToBuffer);
                    totalBytes += (long)bytesReadToBuffer;
                }
                if (listenProgress) {
                    StreamingProgressEventImpl progressEvent = new StreamingProgressEventImpl(filename, type, contentLength, totalBytes);
                    lastStreamingEvent = this.updateProgress(session, streamVariable, progressEvent, lastStreamingEvent, bytesReadToBuffer);
                }
                if (!streamVariable.isInterrupted()) continue;
                throw new UploadInterruptedException();
            } while (bytesReadToBuffer > 0);
            out.close();
            StreamingEndEventImpl event = new StreamingEndEventImpl(filename, type, totalBytes);
            session.lock();
            try {
                streamVariable.streamingFinished(event);
            }
            finally {
                session.unlock();
            }
        }
        catch (UploadInterruptedException e) {
            StreamReceiverHandler.tryToCloseStream(out);
            StreamingErrorEventImpl event = new StreamingErrorEventImpl(filename, type, contentLength, totalBytes, e);
            session.lock();
            try {
                streamVariable.streamingFailed(event);
            }
            finally {
                session.unlock();
            }
        }
        catch (Exception e) {
            StreamReceiverHandler.tryToCloseStream(out);
            session.lock();
            try {
                StreamingErrorEventImpl event = new StreamingErrorEventImpl(filename, type, contentLength, totalBytes, e);
                streamVariable.streamingFailed(event);
                throw new UploadException(e);
            }
            catch (Throwable throwable) {
                session.unlock();
                throw throwable;
            }
        }
        return startedEvent.isDisposed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long updateProgress(VaadinSession session, StreamVariable streamVariable, StreamingProgressEventImpl progressEvent, long lastStreamingEvent, int bytesReadToBuffer) {
        long now = System.currentTimeMillis();
        if (lastStreamingEvent + (long)this.getProgressEventInterval() <= now || bytesReadToBuffer <= 0) {
            session.lock();
            try {
                streamVariable.onProgress(progressEvent);
            }
            finally {
                session.unlock();
            }
        }
        return now;
    }

    private long getContentLength(VaadinRequest request) {
        try {
            return Long.parseLong(request.getHeader("Content-Length"));
        }
        catch (NumberFormatException e) {
            return -1L;
        }
    }

    private static Logger getLogger() {
        return LoggerFactory.getLogger((String)StreamReceiverHandler.class.getName());
    }

    public static class UploadInterruptedException
    extends Exception {
        public UploadInterruptedException() {
            super("Upload interrupted by other thread");
        }
    }
}

