/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.communication.rpc;

import com.vaadin.flow.internal.StateNode;
import com.vaadin.flow.internal.StateTree;
import com.vaadin.flow.internal.nodefeature.ElementData;
import com.vaadin.flow.server.communication.rpc.AbstractRpcInvocationHandler;
import elemental.json.JsonNull;
import elemental.json.JsonObject;
import elemental.json.JsonValue;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AttachTemplateChildRpcHandler
extends AbstractRpcInvocationHandler {
    @Override
    public String getRpcType() {
        return "attachExistingElementById";
    }

    @Override
    protected Optional<Runnable> handleNode(StateNode node, JsonObject invocationJson) {
        assert (invocationJson.hasKey("attachReqId"));
        assert (invocationJson.hasKey("attachAssignedId"));
        assert (invocationJson.hasKey("attachId"));
        int requestedId = (int)invocationJson.getNumber("attachReqId");
        int assignedId = (int)invocationJson.getNumber("attachAssignedId");
        StateTree tree = (StateTree)node.getOwner();
        StateNode requestedNode = tree.getNodeById(requestedId);
        StateNode parent = tree.getNodeById(requestedId).getParent();
        JsonValue id = invocationJson.get("attachId");
        String tag = requestedNode.getFeature(ElementData.class).getTag();
        Logger logger = LoggerFactory.getLogger((String)AttachTemplateChildRpcHandler.class.getName());
        if (assignedId == -1) {
            logger.error("Attach existing element has failed because the client-side element is not found");
            if (id instanceof JsonNull) {
                throw new IllegalStateException(String.format("The element with the tag name '%s' was not found in the parent with id='%d'", tag, parent.getId()));
            }
            throw new IllegalStateException(String.format("The element with the tag name '%s' and id '%s' was not found in the parent with id='%d'", tag, id.asString(), parent.getId()));
        }
        if (requestedId != assignedId) {
            logger.error("Attach existing element has failed because the element has been already attached from the server side");
            if (id instanceof JsonNull) {
                throw new IllegalStateException(String.format("The element with the tag name '%s' is already attached to the parent with id='%d'", tag, parent.getId()));
            }
            throw new IllegalStateException(String.format("The element with the tag name '%s' and id '%s' is already attached to the parent with id='%d'", tag, id.asString(), parent.getId()));
        }
        logger.error("Attach existing element request succeded. But the response about this is unexpected");
        throw new IllegalArgumentException("Unexpected successful attachment response is received from the client-side. Client side should not respond if everything is fine");
    }
}

