/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.startup;

import com.vaadin.flow.component.UI;
import com.vaadin.flow.router.ParentLayout;
import com.vaadin.flow.router.Route;
import com.vaadin.flow.router.RouteAlias;
import com.vaadin.flow.router.RouterLayout;
import com.vaadin.flow.server.InvalidApplicationConfigurationException;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public abstract class AbstractAnnotationValidator
implements Serializable {
    public static final String ERROR_MESSAGE_BEGINNING = "Found configuration annotations that will not be used in the application. \nMove the following annotations to a single route or the top RouterLayout of the application: \n";
    public static final String NON_PARENT = "Non parent Route target: %s contains: %s";
    public static final String NON_PARENT_ALIAS = "Non parent RouteAlias target: %s contains: %s";
    public static final String NON_ROUTER_LAYOUT = "Non RouterLayout: %s contains: %s";
    public static final String MIDDLE_ROUTER_LAYOUT = "Middle layout: %s contains: %s";

    protected void validateClasses(Collection<Class<?>> classSet) {
        if (classSet == null) {
            return;
        }
        List<String> offendingAnnotations = this.validateAnnotatedClasses(classSet);
        if (!offendingAnnotations.isEmpty()) {
            String message = ERROR_MESSAGE_BEGINNING + String.join((CharSequence)"\n", offendingAnnotations);
            throw new InvalidApplicationConfigurationException(message);
        }
    }

    protected abstract List<Class<?>> getAnnotations();

    private List<String> validateAnnotatedClasses(Collection<Class<?>> classSet) {
        ArrayList<String> offendingAnnotations = new ArrayList<String>();
        for (Class<?> clazz : classSet) {
            Route route = clazz.getAnnotation(Route.class);
            if (route != null) {
                RouteAlias routeAlias;
                if (!UI.class.equals(route.layout())) {
                    offendingAnnotations.add(String.format(NON_PARENT, clazz.getName(), this.getClassAnnotations(clazz)));
                }
                if ((routeAlias = clazz.getAnnotation(RouteAlias.class)) == null || UI.class.equals(routeAlias.layout())) continue;
                offendingAnnotations.add(String.format(NON_PARENT_ALIAS, clazz.getName(), this.getClassAnnotations(clazz)));
                continue;
            }
            if (!RouterLayout.class.isAssignableFrom(clazz)) {
                if (Modifier.isAbstract(clazz.getModifiers())) continue;
                offendingAnnotations.add(String.format(NON_ROUTER_LAYOUT, clazz.getName(), this.getClassAnnotations(clazz)));
                continue;
            }
            if (!RouterLayout.class.isAssignableFrom(clazz) || clazz.getAnnotation(ParentLayout.class) == null) continue;
            offendingAnnotations.add(String.format(MIDDLE_ROUTER_LAYOUT, clazz.getName(), this.getClassAnnotations(clazz)));
        }
        return offendingAnnotations;
    }

    private String getClassAnnotations(Class<?> clazz) {
        List faultyAnnotations = Stream.of(clazz.getAnnotations()).map(Annotation::annotationType).filter(this.getAnnotations()::contains).map(Class::getSimpleName).collect(Collectors.toList());
        return String.join((CharSequence)", ", faultyAnnotations);
    }
}

