/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.router.internal;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.router.BeforeEnterEvent;
import com.vaadin.flow.router.ErrorNavigationEvent;
import com.vaadin.flow.router.HasErrorParameter;
import com.vaadin.flow.router.LocationChangeEvent;
import com.vaadin.flow.router.NavigationEvent;
import com.vaadin.flow.router.NavigationState;
import com.vaadin.flow.router.RouterLayout;
import com.vaadin.flow.router.internal.AbstractNavigationStateRenderer;
import com.vaadin.flow.router.internal.RouterUtil;
import java.util.List;

public class ErrorStateRenderer
extends AbstractNavigationStateRenderer {
    public ErrorStateRenderer(NavigationState navigationState) {
        super(navigationState);
    }

    @Override
    public int handle(NavigationEvent event) {
        assert (event instanceof ErrorNavigationEvent) : "Error handling needs ErrorNavigationEvent";
        return super.handle(event);
    }

    @Override
    protected void notifyNavigationTarget(Component componentInstance, NavigationEvent navigationEvent, BeforeEnterEvent beforeEnterEvent, LocationChangeEvent locationChangeEvent) {
        int statusCode = ((HasErrorParameter)((Object)componentInstance)).setErrorParameter(beforeEnterEvent, ((ErrorNavigationEvent)navigationEvent).getErrorParameter());
        locationChangeEvent.setStatusCode(statusCode);
    }

    @Override
    public List<Class<? extends RouterLayout>> getRouterLayoutTypes(Class<? extends Component> targetType) {
        assert (targetType == this.getNavigationState().getNavigationTarget());
        return RouterUtil.getParentLayoutsForNonRouteTarget(targetType);
    }

    @Override
    protected boolean eventActionsSupported() {
        return false;
    }
}

