/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.internal.nodefeature;

import com.vaadin.flow.internal.NodeOwner;
import com.vaadin.flow.internal.StateNode;
import com.vaadin.flow.internal.StateTree;
import com.vaadin.flow.internal.nodefeature.NodeMap;
import com.vaadin.flow.server.AbstractStreamResource;
import com.vaadin.flow.server.Command;
import com.vaadin.flow.server.StreamRegistration;
import com.vaadin.flow.server.StreamResourceRegistry;
import com.vaadin.flow.server.VaadinSession;
import com.vaadin.flow.shared.Registration;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;

public class ElementAttributeMap
extends NodeMap {
    private Map<String, StreamRegistration> resourceRegistrations;
    private Map<String, Registration> pendingRegistrations;

    public ElementAttributeMap(StateNode node) {
        super(node);
    }

    public void set(String attribute, String value) {
        this.unregisterResource(attribute);
        this.put(attribute, (Serializable)((Object)value));
    }

    public boolean has(String attribute) {
        return this.contains(attribute);
    }

    @Override
    public Serializable remove(String attribute) {
        this.unregisterResource(attribute);
        return super.remove(attribute);
    }

    public String get(String attribute) {
        return (String)((Object)super.get(attribute));
    }

    public Stream<String> attributes() {
        return super.keySet().stream();
    }

    public void setResource(String attribute, AbstractStreamResource resource) {
        this.set(attribute, StreamResourceRegistry.getURI(resource).toASCIIString());
        if (this.getNode().isAttached()) {
            this.registerResource(attribute, resource);
        } else {
            this.deferRegistration(attribute, resource);
        }
    }

    private void ensurePendingRegistrations() {
        if (this.pendingRegistrations == null) {
            this.pendingRegistrations = new HashMap<String, Registration>();
        }
    }

    private void ensureResourceRegistrations() {
        if (this.resourceRegistrations == null) {
            this.resourceRegistrations = new HashMap<String, StreamRegistration>();
        }
    }

    private void unregisterResource(String attribute) {
        this.ensureResourceRegistrations();
        this.ensurePendingRegistrations();
        StreamRegistration registration = this.resourceRegistrations.remove(attribute);
        Registration handle = this.pendingRegistrations.remove(attribute);
        if (handle != null) {
            handle.remove();
        }
        if (registration != null) {
            registration.unregister();
        }
        if (this.resourceRegistrations.isEmpty()) {
            this.resourceRegistrations = null;
        }
        if (this.pendingRegistrations.isEmpty()) {
            this.pendingRegistrations = null;
        }
    }

    private void deferRegistration(final String attribute, final AbstractStreamResource resource) {
        this.ensurePendingRegistrations();
        assert (!this.pendingRegistrations.containsKey(attribute));
        Registration handle = this.getNode().addAttachListener(new Command(){

            @Override
            public void execute() {
                ElementAttributeMap.this.registerResource(attribute, resource);
            }
        });
        this.pendingRegistrations.put(attribute, handle);
    }

    private void registerResource(final String attribute, AbstractStreamResource resource) {
        this.ensureResourceRegistrations();
        this.ensurePendingRegistrations();
        assert (!this.resourceRegistrations.containsKey(attribute));
        StreamRegistration registration = this.getSession().getResourceRegistry().registerResource(resource);
        this.resourceRegistrations.put(attribute, registration);
        Registration handle = this.pendingRegistrations.remove(attribute);
        if (handle != null) {
            handle.remove();
        }
        this.pendingRegistrations.put(attribute, this.getNode().addDetachListener(new Command(){

            @Override
            public void execute() {
                ElementAttributeMap.this.unsetResource(attribute);
            }
        }));
    }

    private void unsetResource(String attribute) {
        this.ensureResourceRegistrations();
        StreamRegistration registration = this.resourceRegistrations.get(attribute);
        Optional<Object> resource = Optional.empty();
        if (registration != null) {
            resource = Optional.ofNullable(registration.getResource());
        }
        this.unregisterResource(attribute);
        resource.ifPresent(res -> this.deferRegistration(attribute, (AbstractStreamResource)res));
    }

    private VaadinSession getSession() {
        NodeOwner owner = this.getNode().getOwner();
        assert (owner instanceof StateTree);
        return ((StateTree)owner).getUI().getSession();
    }
}

