/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.router;

import com.vaadin.flow.component.UI;
import com.vaadin.flow.router.BeforeEvent;
import com.vaadin.flow.router.Location;
import com.vaadin.flow.router.NavigationEvent;
import com.vaadin.flow.router.NavigationHandler;
import com.vaadin.flow.router.NavigationTrigger;
import com.vaadin.flow.router.Router;
import java.io.Serializable;

public class BeforeLeaveEvent
extends BeforeEvent {
    private ContinueNavigationAction continueNavigationAction = null;

    public BeforeLeaveEvent(NavigationEvent event, Class<?> navigationTarget) {
        super(event, navigationTarget);
    }

    public BeforeLeaveEvent(Router router, NavigationTrigger trigger, Location location, Class<?> navigationTarget, UI ui) {
        super(router, trigger, location, navigationTarget, ui);
    }

    public ContinueNavigationAction postpone() {
        this.continueNavigationAction = new ContinueNavigationAction();
        return this.continueNavigationAction;
    }

    public boolean isPostponed() {
        return this.continueNavigationAction != null;
    }

    public ContinueNavigationAction getContinueNavigationAction() {
        return this.continueNavigationAction;
    }

    public class ContinueNavigationAction
    implements Serializable {
        private NavigationHandler handler = null;
        private NavigationEvent event = null;

        private ContinueNavigationAction() {
        }

        public void setReferences(NavigationHandler handler, NavigationEvent event) {
            if (event != null) {
                event.getUI().getSession().hasLock();
            } else assert (UI.getCurrent() != null && UI.getCurrent().getSession().hasLock());
            this.handler = handler;
            this.event = event;
        }

        public void proceed() {
            BeforeLeaveEvent.this.continueNavigationAction = null;
            if (this.handler != null && this.event != null) {
                if (!this.event.getUI().getSession().hasLock()) {
                    throw new IllegalStateException("The method 'proceed' may not be called without the session lock. Use UI.access() to execute any UI related code from a separate thread properly");
                }
                this.handler.handle(this.event);
                this.setReferences(null, null);
            }
        }
    }
}

