/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.router;

import com.vaadin.flow.component.HasElement;
import com.vaadin.flow.router.HighlightCondition;
import com.vaadin.flow.router.RouterLink;

public final class HighlightConditions {
    private HighlightConditions() {
    }

    public static HighlightCondition<RouterLink> sameLocation() {
        return (link, event) -> event.getLocation().getPath().equals(link.getHref());
    }

    public static HighlightCondition<RouterLink> locationPrefix() {
        return (link, event) -> event.getLocation().getPath().startsWith(link.getHref());
    }

    public static <C extends HasElement> HighlightCondition<C> locationPrefix(String prefix) {
        return (component, event) -> event.getLocation().getPath().startsWith(prefix);
    }

    public static <C extends HasElement> HighlightCondition<C> always() {
        return (component, event) -> true;
    }

    public static <C extends HasElement> HighlightCondition<C> never() {
        return (component, event) -> false;
    }
}

