/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentUtil;
import com.vaadin.flow.component.Key;
import com.vaadin.flow.component.KeyDownEvent;
import com.vaadin.flow.component.KeyModifier;
import com.vaadin.flow.component.ShortcutEvent;
import com.vaadin.flow.component.ShortcutEventListener;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.dom.DomListenerRegistration;
import com.vaadin.flow.function.SerializableConsumer;
import com.vaadin.flow.function.SerializableSupplier;
import com.vaadin.flow.internal.ExecutionContext;
import com.vaadin.flow.internal.StateTree;
import com.vaadin.flow.shared.Registration;
import java.io.Serializable;
import java.security.InvalidParameterException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;

public class ShortcutRegistration
implements Registration,
Serializable {
    private boolean allowDefaultBehavior = false;
    private boolean allowEventPropagation = false;
    private Set<Key> modifiers = new HashSet<Key>(2);
    private Key primaryKey = null;
    private StateTree.ExecutionRegistration executionRegistration;
    private CompoundRegistration lifecycleRegistration;
    private Component lifecycleOwner;
    private CompoundRegistration listenOnAttachListenerRegistration;
    private CompoundRegistration shortcutListenerRegistration;
    private Component listenOnComponent;
    private boolean shortcutActive = false;
    private SerializableSupplier<Component> listenOnSupplier;
    private AtomicBoolean isDirty = new AtomicBoolean(false);
    private ShortcutEventListener eventListener;
    private final SerializableConsumer<ExecutionContext> beforeClientResponseConsumer = executionContext -> {
        if (this.listenOnComponent == null) {
            this.registerOwnerListener();
        }
        this.updateHandlerListenerRegistration();
        this.markClean();
    };

    ShortcutRegistration(Component lifecycleOwner, SerializableSupplier<Component> listenOnSupplier, ShortcutEventListener eventListener, Key key) {
        if (Key.isModifier(key)) {
            throw new InvalidParameterException(String.format("Parameter 'key' cannot belong to %s", KeyModifier.class.getSimpleName()));
        }
        this.eventListener = eventListener;
        this.listenOnSupplier = listenOnSupplier;
        this.setLifecycleOwner(lifecycleOwner);
        this.addKey(key);
    }

    public ShortcutRegistration withModifiers(KeyModifier ... keyModifiers) {
        this.modifiers.clear();
        this.prepareForClientResponse();
        for (KeyModifier keyModifier : keyModifiers) {
            this.addKey(keyModifier);
        }
        return this;
    }

    public ShortcutRegistration withAlt() {
        this.addKey(KeyModifier.ALT);
        return this;
    }

    public ShortcutRegistration withCtrl() {
        this.addKey(KeyModifier.CONTROL);
        return this;
    }

    public ShortcutRegistration withMeta() {
        this.addKey(KeyModifier.META);
        return this;
    }

    public ShortcutRegistration withShift() {
        this.addKey(KeyModifier.SHIFT);
        return this;
    }

    public ShortcutRegistration allowBrowserDefault() {
        if (!this.allowDefaultBehavior) {
            this.allowDefaultBehavior = true;
            this.prepareForClientResponse();
        }
        return this;
    }

    public ShortcutRegistration allowEventPropagation() {
        if (!this.allowEventPropagation) {
            this.allowEventPropagation = true;
            this.prepareForClientResponse();
        }
        return this;
    }

    public ShortcutRegistration bindLifecycleTo(Component component) {
        if (component == null) {
            throw new InvalidParameterException(String.format("Parameter '%s' must not be null!", "component"));
        }
        this.setLifecycleOwner(component);
        return this;
    }

    public ShortcutRegistration listenOn(Component listenOnComponent) {
        this.removeAllListenerRegistrations();
        this.listenOnSupplier = () -> listenOnComponent;
        this.prepareForClientResponse();
        return this;
    }

    @Override
    public void remove() {
        if (this.executionRegistration != null) {
            this.executionRegistration.remove();
            this.executionRegistration = null;
        }
        if (this.lifecycleRegistration != null) {
            this.lifecycleRegistration.remove();
            this.lifecycleRegistration = null;
        }
        this.removeAllListenerRegistrations();
        this.lifecycleOwner = null;
        this.listenOnComponent = null;
        this.eventListener = null;
    }

    public boolean isShortcutActive() {
        return this.shortcutActive;
    }

    public Key getKey() {
        return this.primaryKey;
    }

    public Set<Key> getModifiers() {
        return Collections.unmodifiableSet(this.modifiers);
    }

    @Deprecated
    public boolean preventsDefault() {
        return !this.allowDefaultBehavior;
    }

    public boolean isBrowserDefaultAllowed() {
        return this.allowDefaultBehavior;
    }

    public void setBrowserDefaultAllowed(boolean browserDefaultAllowed) {
        if (this.allowDefaultBehavior != browserDefaultAllowed) {
            this.allowDefaultBehavior = browserDefaultAllowed;
            this.prepareForClientResponse();
        }
    }

    @Deprecated
    public boolean stopsPropagation() {
        return !this.allowEventPropagation;
    }

    public boolean isEventPropagationAllowed() {
        return this.allowEventPropagation;
    }

    public void setEventPropagationAllowed(boolean eventPropagationAllowed) {
        if (this.allowEventPropagation != eventPropagationAllowed) {
            this.allowEventPropagation = eventPropagationAllowed;
            this.prepareForClientResponse();
        }
    }

    public Component getOwner() {
        return this.listenOnComponent;
    }

    public Component getLifecycleOwner() {
        return this.lifecycleOwner;
    }

    boolean isDirty() {
        return this.isDirty.get();
    }

    private void setLifecycleOwner(Component owner) {
        assert (owner != null);
        if (this.lifecycleRegistration != null) {
            this.lifecycleRegistration.remove();
        }
        this.registerLifecycleOwner(owner);
    }

    private void addKey(Key key) {
        assert (key != null);
        HashableKey hashableKey = new HashableKey(key);
        if (Key.isModifier(key)) {
            if (!this.modifiers.contains(hashableKey)) {
                this.modifiers.add(hashableKey);
                this.prepareForClientResponse();
            }
        } else if (this.primaryKey == null || !this.primaryKey.equals(hashableKey)) {
            this.primaryKey = hashableKey;
            this.prepareForClientResponse();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void prepareForClientResponse() {
        assert (this.lifecycleOwner != null);
        ShortcutRegistration shortcutRegistration = this;
        synchronized (shortcutRegistration) {
            if (this.isDirty.get()) {
                return;
            }
            this.isDirty.set(true);
        }
        this.queueBeforeExecutionCallback();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void markClean() {
        ShortcutRegistration shortcutRegistration = this;
        synchronized (shortcutRegistration) {
            if (!this.isDirty.get()) {
                return;
            }
            this.isDirty.set(false);
            this.executionRegistration = null;
        }
    }

    private String filterText() {
        return ShortcutRegistration.generateEventKeyFilter(this.primaryKey) + " && " + ShortcutRegistration.generateEventModifierFilter(this.modifiers);
    }

    private void updateHandlerListenerRegistration() {
        assert (this.listenOnComponent != null);
        if (this.shortcutListenerRegistration == null) {
            if (this.listenOnComponent.getUI().isPresent()) {
                this.shortcutListenerRegistration = new CompoundRegistration(new Registration[0]);
                Registration keydownRegistration = ComponentUtil.addListener(this.listenOnComponent, KeyDownEvent.class, e -> {
                    if (this.lifecycleOwner.isVisible()) {
                        this.invokeShortcutEventListener();
                    }
                }, domRegistration -> {
                    this.shortcutListenerRegistration.addRegistration((Registration)domRegistration);
                    this.configureHandlerListenerRegistration();
                });
                this.shortcutListenerRegistration.addRegistration(keydownRegistration);
            }
        } else {
            this.configureHandlerListenerRegistration();
        }
    }

    private void configureHandlerListenerRegistration() {
        if (this.shortcutListenerRegistration != null) {
            Optional<Registration> registration = this.shortcutListenerRegistration.registrations.stream().filter(r -> r instanceof DomListenerRegistration).findFirst();
            registration.ifPresent(r -> {
                DomListenerRegistration listenerRegistration = (DomListenerRegistration)r;
                String filterText = this.filterText();
                if (!this.allowDefaultBehavior) {
                    filterText = filterText + " && (event.preventDefault() || true)";
                }
                if (!this.allowEventPropagation) {
                    filterText = filterText + " && (event.stopPropagation() || true)";
                }
                listenerRegistration.setFilter(filterText);
                this.shortcutActive = true;
            });
        }
    }

    private void invokeShortcutEventListener() {
        ShortcutEvent event = new ShortcutEvent(this.listenOnComponent, this.lifecycleOwner, this.primaryKey, this.modifiers.stream().map(k -> (KeyModifier)((HashableKey)k).key).collect(Collectors.toSet()));
        this.eventListener.onShortcut(event);
    }

    private void registerLifecycleOwner(Component owner) {
        assert (owner != null);
        this.lifecycleOwner = owner;
        Registration attachRegistration = owner.addAttachListener(e -> this.queueBeforeExecutionCallback());
        Registration detachRegistration = owner.addDetachListener(e -> this.removeListenerRegistration());
        this.lifecycleRegistration = new CompoundRegistration(attachRegistration, detachRegistration);
    }

    private void registerOwnerListener() {
        assert (this.listenOnSupplier != null);
        this.listenOnComponent = (Component)this.listenOnSupplier.get();
        if (this.listenOnComponent == null) {
            throw new IllegalStateException(String.format("Could register shortcut listener for %s. %s<%s> supplied a null value.", this.toString(), SerializableSupplier.class.getSimpleName(), Component.class.getSimpleName()));
        }
        if (!(this.listenOnComponent instanceof UI)) {
            this.listenOnAttachListenerRegistration = new CompoundRegistration(new Registration[0]);
            this.listenOnAttachListenerRegistration.addRegistration(this.listenOnComponent.addAttachListener(attachEvent -> this.updateHandlerListenerRegistration()));
            this.listenOnAttachListenerRegistration.addRegistration(this.listenOnComponent.addDetachListener(detachEvent -> this.removeListenerRegistration()));
        }
        if (this.listenOnComponent.getUI().isPresent()) {
            this.updateHandlerListenerRegistration();
        }
    }

    private void removeAllListenerRegistrations() {
        if (this.listenOnAttachListenerRegistration != null) {
            this.listenOnAttachListenerRegistration.remove();
            this.listenOnAttachListenerRegistration = null;
        }
        this.removeListenerRegistration();
        this.listenOnComponent = null;
    }

    private void removeListenerRegistration() {
        if (this.shortcutListenerRegistration != null) {
            this.shortcutListenerRegistration.remove();
            this.shortcutListenerRegistration = null;
        }
        this.shortcutActive = false;
    }

    private void queueBeforeExecutionCallback() {
        if (this.lifecycleOwner == null || !this.lifecycleOwner.getUI().isPresent()) {
            return;
        }
        if (this.executionRegistration != null) {
            this.executionRegistration.remove();
        }
        this.executionRegistration = this.lifecycleOwner.getUI().get().beforeClientResponse(this.lifecycleOwner, this.beforeClientResponseConsumer);
    }

    private static String generateEventModifierFilter(Collection<Key> modifiers) {
        if (modifiers.isEmpty()) {
            return "true";
        }
        return modifiers.stream().filter(Key::isModifier).map(modifier -> "event.getModifierState('" + modifier.getKeys().get(0) + "')").collect(Collectors.joining(" && "));
    }

    private static String generateEventKeyFilter(Key key) {
        assert (key != null);
        String keyList = "[" + key.getKeys().stream().map(s -> "'" + s + "'").collect(Collectors.joining(",")) + "]";
        return "(" + keyList + ".indexOf(event.code) !== -1 || " + keyList + ".indexOf(event.key) !== -1)";
    }

    public String toString() {
        return String.format("%s [key = %s, modifiers = %s, owner = %s, listenOn = %s, default = %s, propagation = %s]", this.getClass().getSimpleName(), this.primaryKey != null ? this.primaryKey.getKeys().get(0) : "null", Arrays.toString(this.modifiers.stream().map(k -> k.getKeys().get(0)).toArray()), this.lifecycleOwner != null ? this.lifecycleOwner.getClass().getSimpleName() : "null", this.listenOnComponent != null ? this.listenOnComponent.getClass().getSimpleName() : "null", this.allowDefaultBehavior, this.allowEventPropagation);
    }

    private static class CompoundRegistration
    implements Registration {
        private Set<Registration> registrations;

        CompoundRegistration(Registration ... registrations) {
            this.registrations = new HashSet<Registration>(Arrays.asList(registrations));
        }

        void addRegistration(Registration registration) {
            if (registration != null) {
                this.registrations.add(registration);
            }
        }

        @Override
        public void remove() {
            if (this.registrations != null) {
                this.registrations.forEach(Registration::remove);
                this.registrations = null;
            }
        }
    }

    private static class HashableKey
    implements Key {
        private Key key;
        private Integer hashcode;

        HashableKey(Key key) {
            assert (key != null);
            this.key = key;
        }

        public int hashCode() {
            if (this.hashcode == null) {
                this.hashcode = Arrays.hashCode(this.key.getKeys().stream().map(String::toLowerCase).sorted(String::compareTo).toArray(String[]::new));
            }
            return this.hashcode;
        }

        public boolean equals(Object obj) {
            if (obj instanceof HashableKey) {
                HashableKey other = (HashableKey)obj;
                return this.key.matches(other.getKeys().get(0));
            }
            return false;
        }

        @Override
        public List<String> getKeys() {
            return this.key.getKeys();
        }
    }
}

