/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.component.page;

import com.vaadin.flow.component.UI;
import com.vaadin.flow.router.Location;
import com.vaadin.flow.router.NavigationTrigger;
import elemental.json.JsonValue;
import java.io.Serializable;
import java.util.EventObject;
import java.util.Optional;

public class History
implements Serializable {
    private final UI ui;
    private HistoryStateChangeHandler historyStateChangeHandler;

    public History(UI ui) {
        assert (ui != null);
        this.ui = ui;
    }

    public UI getUI() {
        return this.ui;
    }

    public void pushState(JsonValue state, String location) {
        this.pushState(state, (Location)Optional.ofNullable(location).map(Location::new).orElse(null));
    }

    public void pushState(JsonValue state, Location location) {
        this.ui.getPage().executeJavaScript("history.pushState($0, '', $1)", new Serializable[]{state, location.getPathWithQueryParameters()});
    }

    public void replaceState(JsonValue state, String location) {
        this.replaceState(state, (Location)Optional.ofNullable(location).map(Location::new).orElse(null));
    }

    public void replaceState(JsonValue state, Location location) {
        this.ui.getPage().executeJavaScript("history.replaceState($0, '', $1)", new Serializable[]{state, location.getPathWithQueryParameters()});
    }

    public void setHistoryStateChangeHandler(HistoryStateChangeHandler historyStateChangeHandler) {
        this.historyStateChangeHandler = historyStateChangeHandler;
    }

    public HistoryStateChangeHandler getHistoryStateChangeHandler() {
        return this.historyStateChangeHandler;
    }

    public void back() {
        this.ui.getPage().executeJavaScript("history.back()", new Serializable[0]);
    }

    public void forward() {
        this.ui.getPage().executeJavaScript("history.forward()", new Serializable[0]);
    }

    public void go(int steps) {
        this.ui.getPage().executeJavaScript("history.go($0)", Integer.valueOf(steps));
    }

    @FunctionalInterface
    public static interface HistoryStateChangeHandler
    extends Serializable {
        public void onHistoryStateChange(HistoryStateChangeEvent var1);
    }

    public static class HistoryStateChangeEvent
    extends EventObject {
        private final Location location;
        private final transient JsonValue state;
        private final NavigationTrigger trigger;

        public HistoryStateChangeEvent(History history, JsonValue state, Location location, NavigationTrigger trigger) {
            super(history);
            assert (location != null);
            assert (trigger != null);
            this.location = location;
            this.state = state;
            this.trigger = trigger;
        }

        @Override
        public History getSource() {
            return (History)super.getSource();
        }

        public Location getLocation() {
            return this.location;
        }

        public Optional<JsonValue> getState() {
            return Optional.ofNullable(this.state);
        }

        public NavigationTrigger getTrigger() {
            return this.trigger;
        }
    }
}

