/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.dom.impl;

import com.vaadin.flow.dom.Node;
import com.vaadin.flow.dom.impl.AbstractTextElementStateProvider;
import com.vaadin.flow.dom.impl.BasicElementStateProvider;
import com.vaadin.flow.internal.StateNode;
import com.vaadin.flow.internal.nodefeature.ComponentMapping;
import com.vaadin.flow.internal.nodefeature.TextNodeMap;
import java.util.Collections;

public class BasicTextElementStateProvider
extends AbstractTextElementStateProvider {
    private static final BasicTextElementStateProvider INSTANCE = new BasicTextElementStateProvider();

    private BasicTextElementStateProvider() {
    }

    public static StateNode createStateNode(String text) {
        assert (text != null);
        StateNode node = new StateNode(Collections.singletonList(TextNodeMap.class), ComponentMapping.class);
        node.getFeature(TextNodeMap.class).setText(text);
        return node;
    }

    public static BasicTextElementStateProvider get() {
        return INSTANCE;
    }

    @Override
    public boolean supports(StateNode node) {
        return node.hasFeature(TextNodeMap.class);
    }

    @Override
    public String getTextContent(StateNode node) {
        assert (node != null);
        return node.getFeature(TextNodeMap.class).getText();
    }

    @Override
    public void setTextContent(StateNode node, String textContent) {
        assert (node != null);
        assert (textContent != null);
        node.getFeature(TextNodeMap.class).setText(textContent);
    }

    @Override
    public Node<?> getParent(StateNode node) {
        return BasicElementStateProvider.get().getParent(node);
    }
}

