/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server;

import com.vaadin.flow.function.DeploymentConfiguration;
import com.vaadin.flow.internal.ResponseWriter;
import com.vaadin.flow.server.StaticFileHandler;
import com.vaadin.flow.server.VaadinServletService;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StaticFileServer
implements StaticFileHandler {
    private final ResponseWriter responseWriter;
    private final VaadinServletService servletService;
    private DeploymentConfiguration deploymentConfiguration;

    public StaticFileServer(VaadinServletService servletService) {
        this.servletService = servletService;
        this.deploymentConfiguration = servletService.getDeploymentConfiguration();
        this.responseWriter = new ResponseWriter(this.deploymentConfiguration);
    }

    @Override
    public boolean isStaticResourceRequest(HttpServletRequest request) {
        String requestFilename = this.getRequestFilename(request);
        if (requestFilename.endsWith("/")) {
            return false;
        }
        if (requestFilename.startsWith("/VAADIN/static/")) {
            return true;
        }
        URL resource = this.servletService.getStaticResource(requestFilename);
        return resource != null;
    }

    @Override
    public boolean serveStaticResource(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String filenameWithPath = this.getRequestFilename(request);
        URL resourceUrl = this.servletService.getStaticResource(filenameWithPath);
        if (resourceUrl == null) {
            response.sendError(404);
            return true;
        }
        this.writeCacheHeaders(filenameWithPath, response);
        long timestamp = this.writeModificationTimestamp(resourceUrl, request, response);
        if (this.browserHasNewestVersion(request, timestamp)) {
            response.setStatus(304);
            return true;
        }
        this.responseWriter.writeResponseContents(filenameWithPath, resourceUrl, request, response);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long writeModificationTimestamp(URL resourceUrl, HttpServletRequest request, HttpServletResponse response) {
        URLConnection connection = null;
        try {
            connection = resourceUrl.openConnection();
            long lastModifiedTime = connection.getLastModified();
            lastModifiedTime -= lastModifiedTime % 1000L;
            response.setDateHeader("Last-Modified", lastModifiedTime);
            long l = lastModifiedTime;
            return l;
        }
        catch (Exception e) {
            StaticFileServer.getLogger().trace("Failed to find out last modified timestamp. Continuing without it.", (Throwable)e);
        }
        finally {
            try {
                InputStream is;
                if (connection != null && (is = connection.getInputStream()) != null) {
                    is.close();
                }
            }
            catch (IOException e) {
                StaticFileServer.getLogger().warn("Error closing URLConnection input stream", (Throwable)e);
            }
        }
        return -1L;
    }

    protected void writeCacheHeaders(String filenameWithPath, HttpServletResponse response) {
        int resourceCacheTime = this.getCacheTime(filenameWithPath);
        String cacheControl = !this.deploymentConfiguration.isProductionMode() ? "no-cache" : (resourceCacheTime > 0 ? "max-age=" + resourceCacheTime : "public, max-age=0, must-revalidate");
        response.setHeader("Cache-Control", cacheControl);
    }

    String getRequestFilename(HttpServletRequest request) {
        return request.getPathInfo() == null ? request.getServletPath() : request.getServletPath() + request.getPathInfo();
    }

    protected int getCacheTime(String filenameWithPath) {
        if (filenameWithPath.contains(".nocache.")) {
            return 0;
        }
        if (filenameWithPath.contains(".cache.")) {
            return 31536000;
        }
        return 3600;
    }

    protected boolean browserHasNewestVersion(HttpServletRequest request, long resourceLastModifiedTimestamp) {
        assert (resourceLastModifiedTimestamp >= -1L);
        if (resourceLastModifiedTimestamp == -1L) {
            return false;
        }
        try {
            long headerIfModifiedSince = request.getDateHeader("If-Modified-Since");
            if (headerIfModifiedSince >= resourceLastModifiedTimestamp) {
                return true;
            }
        }
        catch (Exception e) {
            StaticFileServer.getLogger().trace("Unable to parse If-Modified-Since", (Throwable)e);
        }
        return false;
    }

    private static Logger getLogger() {
        return LoggerFactory.getLogger((String)StaticFileServer.class.getName());
    }
}

