/*
 * Decompiled with CFR 0.152.
 */
package com.vaadin.flow.server.communication;

import com.vaadin.flow.component.PushConfiguration;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.webcomponent.WebComponentUI;
import com.vaadin.flow.server.BootstrapHandler;
import com.vaadin.flow.server.ServletHelper;
import com.vaadin.flow.server.VaadinRequest;
import com.vaadin.flow.server.VaadinResponse;
import com.vaadin.flow.server.VaadinServletRequest;
import com.vaadin.flow.server.VaadinSession;
import com.vaadin.flow.server.webcomponent.WebComponentConfigurationRegistry;
import com.vaadin.flow.theme.Theme;
import com.vaadin.flow.theme.ThemeDefinition;
import elemental.json.JsonObject;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.lang.annotation.Annotation;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import java.util.function.Function;
import java.util.regex.Pattern;
import org.jsoup.nodes.Attribute;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;

public class WebComponentBootstrapHandler
extends BootstrapHandler {
    private static final String REQ_PARAM_URL = "url";
    private static final String PATH_PREFIX = "/web-component/web-component";
    private static final Pattern PATH_PATTERN = Pattern.compile(".*/web-component/web-component-(ui|bootstrap)\\.(js|html)$");

    public WebComponentBootstrapHandler() {
    }

    protected WebComponentBootstrapHandler(BootstrapHandler.PageBuilder pageBuilder) {
        super(pageBuilder);
    }

    @Override
    protected boolean canHandleRequest(VaadinRequest request) {
        String pathInfo = request.getPathInfo();
        if (pathInfo == null || pathInfo.isEmpty()) {
            return false;
        }
        return PATH_PATTERN.matcher(pathInfo).find();
    }

    protected String getRequestUrl(VaadinRequest request) {
        return ((VaadinServletRequest)request).getRequestURL().toString();
    }

    @Override
    protected BootstrapHandler.BootstrapContext createAndInitUI(Class<? extends UI> uiClass, VaadinRequest request, VaadinResponse response, VaadinSession session) {
        BootstrapHandler.BootstrapContext context = super.createAndInitUI(WebComponentUI.class, request, response, session);
        JsonObject config = context.getApplicationParameters();
        String requestURL = this.getRequestUrl(request);
        if (!this.canHandleRequest(request)) {
            throw new IllegalStateException("Unexpected request URL '" + requestURL + "' in the bootstrap handler for web component UI which should handle path " + PATH_PATTERN.toString());
        }
        String serviceUrl = this.getServiceUrl(request);
        String pushURL = context.getSession().getConfiguration().getPushURL();
        if (pushURL == null) {
            pushURL = serviceUrl;
        } else {
            try {
                URI uri = new URI(serviceUrl);
                pushURL = uri.resolve(new URI(pushURL)).toASCIIString();
            }
            catch (URISyntaxException exception) {
                throw new IllegalStateException(String.format("Can't resolve pushURL '%s' based on the service URL '%s'", pushURL, serviceUrl), exception);
            }
        }
        PushConfiguration pushConfiguration = context.getUI().getPushConfiguration();
        pushConfiguration.setPushUrl(pushURL);
        assert (serviceUrl.endsWith("/"));
        config.put("serviceUrl", serviceUrl);
        return context;
    }

    @Override
    protected BootstrapHandler.BootstrapContext createBootstrapContext(VaadinRequest request, VaadinResponse response, UI ui, Function<VaadinRequest, String> callback) {
        return new WebComponentBootstrapContext(request, response, ui, callback);
    }

    @Override
    public boolean synchronizedHandleRequest(VaadinSession session, VaadinRequest request, VaadinResponse response) throws IOException {
        if (session.getService().getDeploymentConfiguration().isCompatibilityMode()) {
            return super.synchronizedHandleRequest(session, request, response);
        }
        Class<? extends UI> uiClass = WebComponentBootstrapHandler.getUIClass(request);
        BootstrapHandler.BootstrapContext context = this.createAndInitUI(uiClass, request, response, session);
        ServletHelper.setResponseNoCacheHeaders(response::setHeader, response::setDateHeader);
        String serviceUrl = this.getServiceUrl(request);
        Document document = this.getPageBuilder().getBootstrapPage(context);
        this.writeBootstrapPage(response, document.head(), serviceUrl);
        return true;
    }

    private void writeBootstrapPage(VaadinResponse response, Element head, String serviceUrl) throws IOException {
        this.writeBootstrapPage("text/javascript; charset=utf-8", response, head, serviceUrl);
    }

    protected void writeBootstrapPage(String contentType, VaadinResponse response, Element head, String serviceUrl) throws IOException {
        response.setContentType(contentType);
        try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(response.getOutputStream(), StandardCharsets.UTF_8));){
            String varName = "headElem";
            writer.append("var ").append(varName).append("=null;");
            for (Element element : head.children()) {
                if (WebComponentBootstrapHandler.elementShouldNotBeTransferred(element)) continue;
                writer.append(varName).append("=");
                writer.append("document.createElement('").append(element.tagName()).append("');");
                WebComponentBootstrapHandler.transferAttribute(writer, varName, element, serviceUrl);
                String elementHtml = element.html();
                if (elementHtml != null && elementHtml.length() > 0) {
                    writer.append(varName).append(".innerHTML=\"").append(WebComponentBootstrapHandler.inlineHTML(elementHtml)).append("\";");
                }
                writer.append("document.head.appendChild(").append(varName).append(");");
            }
        }
    }

    private static boolean elementShouldNotBeTransferred(Element element) {
        if ("base".equals(element.tagName())) {
            return true;
        }
        return "script".equals(element.tagName()) && element.attr("src").contains("webcomponents-loader.js");
    }

    private static void transferAttribute(Writer writer, String elementRef, Element element, String basePath) throws IOException {
        for (Attribute attribute : element.attributes()) {
            writer.append(elementRef).append(".setAttribute('").append(attribute.getKey()).append("',");
            if (attribute.getValue() == null) {
                writer.append("''");
            } else {
                String path = attribute.getValue();
                if ("src".equals(attribute.getKey())) {
                    path = URI.create(basePath + path).toString();
                }
                writer.append("'").append(path).append("'");
            }
            writer.append(");");
        }
    }

    private static String inlineHTML(String html) {
        return html.replace("\\", "\\\\").replace("\"", "\\\"").replace("//<![CDATA[", "/*<![CDATA[*/").replace("//]]>", "/*]]>*/").replaceAll("\\s{2,}", "").replace("\t", "").replace("\n", "").replace("\r", "");
    }

    protected String getServiceUrl(VaadinRequest request) {
        String url = request.getParameter(REQ_PARAM_URL);
        if (url == null) {
            url = ((VaadinServletRequest)request).getRequestURL().toString();
        }
        return url.substring(0, url.indexOf(PATH_PREFIX) + 1).replaceFirst("^.*://", "//");
    }

    private static class WebComponentBootstrapContext
    extends BootstrapHandler.BootstrapContext {
        private WebComponentBootstrapContext(VaadinRequest request, VaadinResponse response, UI ui, Function<VaadinRequest, String> callback) {
            super(request, response, ui.getInternals().getSession(), ui, callback);
        }

        @Override
        public <T extends Annotation> Optional<T> getPageConfigurationAnnotation(Class<T> annotationType) {
            WebComponentConfigurationRegistry registry = WebComponentConfigurationRegistry.getInstance(this.getRequest().getService().getContext());
            return registry.getEmbeddedApplicationAnnotation(annotationType);
        }

        @Override
        protected Optional<ThemeDefinition> getTheme() {
            Optional<Theme> optionalTheme = this.getPageConfigurationAnnotation(Theme.class);
            return optionalTheme.map(ThemeDefinition::new);
        }
    }
}

